/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.mr.hive;

import java.util.List;
import java.util.function.BiFunction;
import java.util.function.Function;
import org.apache.hadoop.hive.ql.exec.UDFArgumentException;
import org.apache.hadoop.hive.ql.parse.TransformSpec;
import org.apache.hadoop.hive.ql.plan.ExprNodeConstantDesc;
import org.apache.hadoop.hive.ql.plan.ExprNodeDesc;
import org.apache.hadoop.hive.ql.plan.ExprNodeGenericFuncDesc;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDF;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoFactory;
import org.apache.iceberg.mr.hive.udf.GenericUDFIcebergBucket;
import org.apache.iceberg.mr.hive.udf.GenericUDFIcebergDay;
import org.apache.iceberg.mr.hive.udf.GenericUDFIcebergHour;
import org.apache.iceberg.mr.hive.udf.GenericUDFIcebergMonth;
import org.apache.iceberg.mr.hive.udf.GenericUDFIcebergTruncate;
import org.apache.iceberg.mr.hive.udf.GenericUDFIcebergYear;
import org.apache.iceberg.relocated.com.google.common.collect.Lists;

public final class IcebergTransformSortFunctionUtil {
    private static final BiFunction<Integer, Integer, Function<List<ExprNodeDesc>, ExprNodeDesc>> BUCKET_SORT_EXPR = (idx, bucket) -> cols -> {
        try {
            ExprNodeDesc icebergBucketSourceCol = (ExprNodeDesc)cols.get((int)idx);
            return ExprNodeGenericFuncDesc.newInstance((GenericUDF)new GenericUDFIcebergBucket(), (String)"iceberg_bucket", Lists.newArrayList(icebergBucketSourceCol, new ExprNodeConstantDesc((TypeInfo)TypeInfoFactory.intTypeInfo, bucket)));
        }
        catch (UDFArgumentException e) {
            throw new RuntimeException(e);
        }
    };
    private static final BiFunction<Integer, Integer, Function<List<ExprNodeDesc>, ExprNodeDesc>> TRUNCATE_SORT_EXPR = (idx, truncateLength) -> cols -> {
        try {
            ExprNodeDesc icebergTruncateSourceCol = (ExprNodeDesc)cols.get((int)idx);
            return ExprNodeGenericFuncDesc.newInstance((GenericUDF)new GenericUDFIcebergTruncate(), (String)"iceberg_truncate", Lists.newArrayList(icebergTruncateSourceCol, new ExprNodeConstantDesc((TypeInfo)TypeInfoFactory.intTypeInfo, truncateLength)));
        }
        catch (UDFArgumentException e) {
            throw new RuntimeException(e);
        }
    };
    private static final Function<Integer, Function<List<ExprNodeDesc>, ExprNodeDesc>> YEAR_SORT_EXPR = idx -> cols -> {
        try {
            ExprNodeDesc icebergYearSourceCol = (ExprNodeDesc)cols.get((int)idx);
            return ExprNodeGenericFuncDesc.newInstance((GenericUDF)new GenericUDFIcebergYear(), (String)"iceberg_year", Lists.newArrayList(icebergYearSourceCol));
        }
        catch (UDFArgumentException e) {
            throw new RuntimeException(e);
        }
    };
    private static final Function<Integer, Function<List<ExprNodeDesc>, ExprNodeDesc>> MONTH_SORT_EXPR = idx -> cols -> {
        try {
            ExprNodeDesc icebergMonthSourceCol = (ExprNodeDesc)cols.get((int)idx);
            return ExprNodeGenericFuncDesc.newInstance((GenericUDF)new GenericUDFIcebergMonth(), (String)"iceberg_month", Lists.newArrayList(icebergMonthSourceCol));
        }
        catch (UDFArgumentException e) {
            throw new RuntimeException(e);
        }
    };
    private static final Function<Integer, Function<List<ExprNodeDesc>, ExprNodeDesc>> DAY_SORT_EXPR = idx -> cols -> {
        try {
            ExprNodeDesc icebergDaySourceCol = (ExprNodeDesc)cols.get((int)idx);
            return ExprNodeGenericFuncDesc.newInstance((GenericUDF)new GenericUDFIcebergDay(), (String)"iceberg_day", Lists.newArrayList(icebergDaySourceCol));
        }
        catch (UDFArgumentException e) {
            throw new RuntimeException(e);
        }
    };
    private static final Function<Integer, Function<List<ExprNodeDesc>, ExprNodeDesc>> HOUR_SORT_EXPR = idx -> cols -> {
        try {
            ExprNodeDesc icebergHourSourceCol = (ExprNodeDesc)cols.get((int)idx);
            return ExprNodeGenericFuncDesc.newInstance((GenericUDF)new GenericUDFIcebergHour(), (String)"iceberg_hour", Lists.newArrayList(icebergHourSourceCol));
        }
        catch (UDFArgumentException e) {
            throw new RuntimeException(e);
        }
    };

    private IcebergTransformSortFunctionUtil() {
    }

    public static Function<List<ExprNodeDesc>, ExprNodeDesc> getCustomSortExprs(TransformSpec spec, int index) {
        switch (spec.getTransformType()) {
            case BUCKET: {
                return BUCKET_SORT_EXPR.apply(index, (Integer)spec.getTransformParam().get());
            }
            case TRUNCATE: {
                return TRUNCATE_SORT_EXPR.apply(index, (Integer)spec.getTransformParam().get());
            }
            case YEAR: {
                return YEAR_SORT_EXPR.apply(index);
            }
            case MONTH: {
                return MONTH_SORT_EXPR.apply(index);
            }
            case DAY: {
                return DAY_SORT_EXPR.apply(index);
            }
            case HOUR: {
                return HOUR_SORT_EXPR.apply(index);
            }
        }
        return cols -> ((ExprNodeDesc)cols.get(index)).clone();
    }
}

