/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.wm;

import java.util.Objects;
import org.apache.hadoop.hive.metastore.api.WMTrigger;
import org.apache.hadoop.hive.ql.wm.Action;
import org.apache.hadoop.hive.ql.wm.Expression;
import org.apache.hadoop.hive.ql.wm.ExpressionFactory;
import org.apache.hadoop.hive.ql.wm.Trigger;

public class ExecutionTrigger
implements Trigger {
    private String name;
    private Expression expression;
    private Action action;
    private String violationMsg;

    public ExecutionTrigger(String name, Expression expression, Action action) {
        this.name = name;
        this.expression = expression;
        this.action = action;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public Expression getExpression() {
        return this.expression;
    }

    @Override
    public Action getAction() {
        return this.action;
    }

    @Override
    public Trigger clone() {
        return new ExecutionTrigger(this.name, this.expression.clone(), this.action);
    }

    @Override
    public String getViolationMsg() {
        return this.violationMsg;
    }

    @Override
    public void setViolationMsg(String violationMsg) {
        this.violationMsg = violationMsg;
    }

    @Override
    public boolean apply(long current) {
        return this.expression.evaluate(current);
    }

    public String toString() {
        return "{ name: " + this.name + ", expression: " + this.expression + ", action: " + this.action + " }";
    }

    public int hashCode() {
        int hash = this.name == null ? 31 : 31 * this.name.hashCode();
        return hash += this.action == null ? 31 * hash : 31 * (hash += this.expression == null ? 31 * hash : 31 * hash * this.expression.hashCode()) * this.action.hashCode();
    }

    public boolean equals(Object other) {
        if (other == null || !(other instanceof ExecutionTrigger)) {
            return false;
        }
        if (other == this) {
            return true;
        }
        ExecutionTrigger otherQR = (ExecutionTrigger)other;
        return Objects.equals(this.name, otherQR.name) && Objects.equals(this.expression, otherQR.expression) && Objects.equals(this.action, otherQR.action);
    }

    public static ExecutionTrigger fromWMTrigger(WMTrigger trigger) {
        Action action = Action.fromMetastoreExpression(trigger.getActionExpression());
        ExecutionTrigger execTrigger = new ExecutionTrigger(trigger.getTriggerName(), ExpressionFactory.fromString(trigger.getTriggerExpression()), action);
        return execTrigger;
    }
}

