/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.udf.generic;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.hadoop.hive.ql.exec.Description;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.udf.generic.AbstractGenericUDFArrayBase;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDF;
import org.apache.hadoop.hive.serde2.objectinspector.ListObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;

@Description(name="array_compact", value="_FUNC_(array) - Removes NULL elements from array.", extended="Example:\n  > SELECT _FUNC_(array(1,NULL,3,NULL,4)) FROM src;\n  [1,3,4]")
public class GenericUDFArrayCompact
extends AbstractGenericUDFArrayBase {
    private static final String FUNC_NAME = "ARRAY_COMPACT";

    public GenericUDFArrayCompact() {
        super(FUNC_NAME, 1, 1, ObjectInspector.Category.LIST);
    }

    @Override
    public Object evaluate(GenericUDF.DeferredObject[] arguments) throws HiveException {
        Object array = arguments[0].get();
        int arrayLength = this.arrayOI.getListLength(array);
        if (arrayLength == 0) {
            return Collections.emptyList();
        }
        if (arrayLength < 0) {
            return null;
        }
        ArrayList resultArray = new ArrayList(((ListObjectInspector)this.argumentOIs[0]).getList(array));
        return resultArray.stream().filter(Objects::nonNull).map(o -> this.converter.convert(o)).collect(Collectors.toList());
    }
}

