/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.udf;

import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import org.apache.hadoop.hive.ql.exec.Description;
import org.apache.hadoop.hive.ql.exec.UDF;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedExpressions;
import org.apache.hadoop.hive.ql.exec.vector.expressions.StringSubstrColStart;
import org.apache.hadoop.hive.ql.exec.vector.expressions.StringSubstrColStartLen;
import org.apache.hadoop.hive.ql.plan.ColStatistics;
import org.apache.hadoop.hive.ql.stats.estimator.StatEstimator;
import org.apache.hadoop.hive.ql.stats.estimator.StatEstimatorProvider;
import org.apache.hadoop.io.BytesWritable;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.Text;

@Description(name="substr,substring,mid", value="_FUNC_(str, pos[, len]) - returns the substring of str that starts at pos and is of length len or_FUNC_(bin, pos[, len]) - returns the slice of byte array that starts at pos and is of length len", extended="pos is a 1-based index. If pos<0 the starting position is determined by counting backwards from the end of str.\nExample:\n   > SELECT _FUNC_('Facebook', 5) FROM src LIMIT 1;\n  'book'\n  > SELECT _FUNC_('Facebook', -5) FROM src LIMIT 1;\n  'ebook'\n  > SELECT _FUNC_('Facebook', 5, 1) FROM src LIMIT 1;\n  'b'")
@VectorizedExpressions(value={StringSubstrColStart.class, StringSubstrColStartLen.class})
public class UDFSubstr
extends UDF
implements StatEstimatorProvider {
    private final int[] index;
    private final Text r;
    private final IntWritable maxValue = new IntWritable(Integer.MAX_VALUE);
    private final LongWritable maxLongValue = new LongWritable(Integer.MAX_VALUE);

    public UDFSubstr() {
        this.index = new int[2];
        this.r = new Text();
    }

    public Text evaluate(Text t, LongWritable pos, LongWritable len) {
        if (t == null || pos == null || len == null) {
            return null;
        }
        long longPos = pos.get();
        long longLen = len.get();
        if (longPos > Integer.MAX_VALUE || longLen > Integer.MAX_VALUE || longPos < Integer.MIN_VALUE || longLen < Integer.MIN_VALUE) {
            return null;
        }
        return this.evaluateInternal(t, (int)longPos, (int)longLen);
    }

    public Text evaluate(Text t, IntWritable pos, IntWritable len) {
        if (t == null || pos == null || len == null) {
            return null;
        }
        return this.evaluateInternal(t, pos.get(), len.get());
    }

    private Text evaluateInternal(Text t, int pos, int len) {
        this.r.clear();
        if (len <= 0) {
            return this.r;
        }
        String s = t.toString();
        int[] index = this.makeIndex(pos, len, s.length());
        if (index == null) {
            return this.r;
        }
        this.r.set(s.substring(index[0], index[1]));
        return this.r;
    }

    private int[] makeIndex(int pos, int len, int inputLen) {
        if (Math.abs(pos) > inputLen) {
            return null;
        }
        int start = pos > 0 ? pos - 1 : (pos < 0 ? inputLen + pos : 0);
        int end = inputLen - start < len ? inputLen : start + len;
        this.index[0] = start;
        this.index[1] = end;
        return this.index;
    }

    public Text evaluate(Text s, IntWritable pos) {
        return this.evaluate(s, pos, this.maxValue);
    }

    public Text evaluate(Text s, LongWritable pos) {
        return this.evaluate(s, pos, this.maxLongValue);
    }

    public BytesWritable evaluate(BytesWritable bw, LongWritable pos, LongWritable len) {
        if (bw == null || pos == null || len == null) {
            return null;
        }
        long longPos = pos.get();
        long longLen = len.get();
        if (longPos > Integer.MAX_VALUE || longLen > Integer.MAX_VALUE || longPos < Integer.MIN_VALUE || longLen < Integer.MIN_VALUE) {
            return null;
        }
        return this.evaluateInternal(bw, (int)longPos, (int)longLen);
    }

    public BytesWritable evaluate(BytesWritable bw, IntWritable pos, IntWritable len) {
        if (bw == null || pos == null || len == null) {
            return null;
        }
        return this.evaluateInternal(bw, pos.get(), len.get());
    }

    private BytesWritable evaluateInternal(BytesWritable bw, int pos, int len) {
        if (len <= 0) {
            return new BytesWritable();
        }
        int[] index = this.makeIndex(pos, len, bw.getLength());
        if (index == null) {
            return new BytesWritable();
        }
        return new BytesWritable(Arrays.copyOfRange(bw.getBytes(), index[0], index[1]));
    }

    public BytesWritable evaluate(BytesWritable bw, IntWritable pos) {
        return this.evaluate(bw, pos, this.maxValue);
    }

    public BytesWritable evaluate(BytesWritable bw, LongWritable pos) {
        return this.evaluate(bw, pos, this.maxLongValue);
    }

    @Override
    public StatEstimator getStatEstimator() {
        return new SubStrStatEstimator();
    }

    private static class SubStrStatEstimator
    implements StatEstimator {
        private SubStrStatEstimator() {
        }

        @Override
        public Optional<ColStatistics> estimate(List<ColStatistics> csList) {
            ColStatistics.Range lengthRange;
            double newAvgColLen;
            ColStatistics cs = csList.get(0).clone();
            Optional<Double> start = this.getRangeWidth(csList.get(1).getRange());
            ColStatistics.Range startRange = csList.get(1).getRange();
            if (startRange != null && startRange.minValue != null && (newAvgColLen = cs.getAvgColLen() - startRange.minValue.doubleValue()) > 0.0) {
                cs.setAvgColLen(newAvgColLen);
            }
            if (csList.size() > 2 && (lengthRange = csList.get(2).getRange()) != null && lengthRange.maxValue != null) {
                Double w = lengthRange.maxValue.doubleValue();
                if (cs.getAvgColLen() > w) {
                    cs.setAvgColLen(w);
                }
            }
            return Optional.of(cs);
        }

        private Optional<Double> getRangeWidth(ColStatistics.Range range) {
            if (range != null && range.minValue != null && range.maxValue != null) {
                return Optional.of(range.maxValue.doubleValue() - range.minValue.doubleValue());
            }
            return Optional.empty();
        }
    }
}

