/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.security.authorization.plugin;

import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.hive.common.classification.InterfaceAudience;
import org.apache.hadoop.hive.metastore.api.PrincipalType;

@InterfaceStability.Evolving
@InterfaceAudience.LimitedPrivate(value={"Apache Argus (incubating)"})
public class HivePrivilegeObject
implements Comparable<HivePrivilegeObject> {
    private final HivePrivilegeObjectType type;
    private final String dbname;
    private final String objectName;
    private final List<String> commandParams;
    private final List<String> partKeys;
    private final List<String> columns;
    private final HivePrivObjectActionType actionType;
    private final String className;
    private final String ownerName;
    private final PrincipalType ownerType;
    private List<String> cellValueTransformers;
    private String rowFilterExpression;

    @Override
    public int compareTo(HivePrivilegeObject o) {
        int compare = this.type.compareTo(o.type);
        if (compare == 0) {
            int n = this.dbname != null ? (o.dbname != null ? this.dbname.compareTo(o.dbname) : 1) : (compare = o.dbname != null ? -1 : 0);
        }
        if (compare == 0) {
            int n = this.objectName != null ? (o.objectName != null ? this.objectName.compareTo(o.objectName) : 1) : (compare = o.objectName != null ? -1 : 0);
        }
        if (compare == 0) {
            int n = this.partKeys != null ? (o.partKeys != null ? this.compare(this.partKeys, o.partKeys) : 1) : (compare = o.partKeys != null ? -1 : 0);
        }
        if (compare == 0) {
            int n = this.columns != null ? (o.columns != null ? this.compare(this.columns, o.columns) : 1) : (compare = o.columns != null ? -1 : 0);
        }
        if (compare == 0) {
            int n = this.className != null ? (o.className != null ? this.className.compareTo(o.className) : 1) : (compare = o.className != null ? -1 : 0);
        }
        if (compare == 0) {
            int n = this.ownerName != null ? (o.ownerName != null ? this.ownerName.compareTo(o.ownerName) : 1) : (compare = o.ownerName != null ? -1 : 0);
        }
        if (compare == 0) {
            compare = this.ownerType != null ? (o.ownerType != null ? this.ownerType.compareTo((Enum)o.ownerType) : 1) : (o.ownerType != null ? -1 : 0);
        }
        return compare;
    }

    private int compare(Collection<String> o1, Collection<String> o2) {
        Iterator<String> it1 = o1.iterator();
        Iterator<String> it2 = o2.iterator();
        while (it1.hasNext() && it2.hasNext()) {
            String s1 = it1.next();
            String s2 = it2.next();
            int compare = s1 != null ? (s2 != null ? s1.compareTo(s2) : 1) : (s2 != null ? -1 : 0);
            if (compare == 0) continue;
            return compare;
        }
        return o1.size() > o2.size() ? 1 : (o1.size() < o2.size() ? -1 : 0);
    }

    public HivePrivilegeObject(HivePrivilegeObjectType type, String dbname, String objectName) {
        this(type, dbname, objectName, HivePrivObjectActionType.OTHER);
    }

    public HivePrivilegeObject(HivePrivilegeObjectType type, String dbname, String objectName, HivePrivObjectActionType actionType) {
        this(type, dbname, objectName, null, null, actionType, null, null);
    }

    public HivePrivilegeObject(HivePrivilegeObjectType type, String dbname, String objectName, List<String> partKeys, String column) {
        this(type, dbname, objectName, partKeys, column == null ? null : Arrays.asList(column), HivePrivObjectActionType.OTHER, null, null);
    }

    public static HivePrivilegeObject createHivePrivilegeObject(List<String> cmdParams) {
        return new HivePrivilegeObject(HivePrivilegeObjectType.COMMAND_PARAMS, null, null, null, null, cmdParams);
    }

    public HivePrivilegeObject(HivePrivilegeObjectType type, String dbname, String objectName, List<String> partKeys, List<String> columns, List<String> commandParams) {
        this(type, dbname, objectName, partKeys, columns, HivePrivObjectActionType.OTHER, commandParams, null);
    }

    public HivePrivilegeObject(String dbname, String objectName, List<String> columns) {
        this(HivePrivilegeObjectType.TABLE_OR_VIEW, dbname, objectName, null, columns, null);
    }

    public HivePrivilegeObject(String dbname, String objectName, List<String> columns, String ownerName, PrincipalType ownerType) {
        this(HivePrivilegeObjectType.TABLE_OR_VIEW, dbname, objectName, null, columns, HivePrivObjectActionType.OTHER, null, null, ownerName, ownerType);
    }

    public HivePrivilegeObject(HivePrivilegeObjectType type, String dbname, String objectName, List<String> partKeys, List<String> columns, HivePrivObjectActionType actionType, List<String> commandParams, String className) {
        this(type, dbname, objectName, partKeys, columns, actionType, commandParams, className, null, null);
    }

    public HivePrivilegeObject(HivePrivilegeObjectType type, String dbname, String objectName, List<String> partKeys, List<String> columns, HivePrivObjectActionType actionType, List<String> commandParams, String className, String ownerName, PrincipalType ownerType) {
        this.type = type;
        this.dbname = dbname;
        this.objectName = objectName;
        this.partKeys = partKeys;
        this.columns = columns;
        this.actionType = actionType;
        this.commandParams = commandParams;
        this.className = className;
        this.ownerName = ownerName;
        this.ownerType = ownerType;
    }

    public static HivePrivilegeObject forScheduledQuery(String owner, String clusterNamespace, String scheduleName) {
        return new HivePrivilegeObject(HivePrivilegeObjectType.SCHEDULED_QUERY, clusterNamespace, scheduleName, null, null, null, null, null, owner, null);
    }

    public HivePrivilegeObjectType getType() {
        return this.type;
    }

    public String getDbname() {
        return this.dbname;
    }

    public String getObjectName() {
        return this.objectName;
    }

    public HivePrivObjectActionType getActionType() {
        return this.actionType;
    }

    public List<String> getCommandParams() {
        return this.commandParams;
    }

    public List<String> getPartKeys() {
        return this.partKeys;
    }

    public List<String> getColumns() {
        return this.columns;
    }

    public String getClassName() {
        return this.className;
    }

    public String toString() {
        Object name = null;
        switch (this.type) {
            case DATABASE: {
                name = this.dbname;
                break;
            }
            case TABLE_OR_VIEW: 
            case PARTITION: {
                name = this.getDbObjectName(this.dbname, this.objectName);
                if (this.partKeys == null) break;
                name = (String)name + this.partKeys.toString();
                break;
            }
            case FUNCTION: {
                name = this.getDbObjectName(this.dbname, this.objectName);
                break;
            }
            case COLUMN: 
            case LOCAL_URI: 
            case DFS_URI: 
            case STORAGEHANDLER_URI: {
                name = this.objectName;
                break;
            }
            case COMMAND_PARAMS: {
                name = this.commandParams.toString();
                break;
            }
            case SERVICE_NAME: {
                name = this.objectName;
                break;
            }
            case DATACONNECTOR: {
                name = this.objectName;
            }
        }
        Object actionTypeStr = "";
        if (this.actionType != null) {
            switch (this.actionType) {
                case INSERT: 
                case INSERT_OVERWRITE: {
                    actionTypeStr = ", action=" + this.actionType;
                }
            }
        }
        return "Object [type=" + this.type + ", name=" + (String)name + (String)actionTypeStr + "]";
    }

    public String getOwnerName() {
        return this.ownerName;
    }

    public PrincipalType getOwnerType() {
        return this.ownerType;
    }

    private String getDbObjectName(String dbname2, String objectName2) {
        return (String)(this.dbname == null ? "" : this.dbname + ".") + this.objectName;
    }

    public List<String> getCellValueTransformers() {
        return this.cellValueTransformers;
    }

    public void setCellValueTransformers(List<String> cellValueTransformers) {
        this.cellValueTransformers = cellValueTransformers;
    }

    public String getRowFilterExpression() {
        return this.rowFilterExpression;
    }

    public void setRowFilterExpression(String rowFilterExpression) {
        this.rowFilterExpression = rowFilterExpression;
    }

    public static enum HivePrivilegeObjectType {
        GLOBAL,
        DATABASE,
        TABLE_OR_VIEW,
        PARTITION,
        COLUMN,
        LOCAL_URI,
        DFS_URI,
        COMMAND_PARAMS,
        FUNCTION,
        DATACONNECTOR,
        SERVICE_NAME,
        SCHEDULED_QUERY,
        STORAGEHANDLER_URI;

    }

    public static enum HivePrivObjectActionType {
        OTHER,
        INSERT,
        INSERT_OVERWRITE,
        UPDATE,
        DELETE;

    }
}

