/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.security.authorization;

import java.util.Arrays;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.curator.framework.recipes.leader.LeaderLatch;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.DefaultMetaStoreFilterHookImpl;
import org.apache.hadoop.hive.metastore.IMetaStoreClient;
import org.apache.hadoop.hive.metastore.api.FieldSchema;
import org.apache.hadoop.hive.metastore.api.HiveObjectPrivilege;
import org.apache.hadoop.hive.metastore.api.HiveObjectRef;
import org.apache.hadoop.hive.metastore.api.HiveObjectType;
import org.apache.hadoop.hive.metastore.api.MetaException;
import org.apache.hadoop.hive.metastore.api.PrincipalType;
import org.apache.hadoop.hive.metastore.api.PrivilegeBag;
import org.apache.hadoop.hive.metastore.api.PrivilegeGrantInfo;
import org.apache.hadoop.hive.metastore.api.Table;
import org.apache.hadoop.hive.metastore.conf.MetastoreConf;
import org.apache.hadoop.hive.ql.metadata.Hive;
import org.apache.hadoop.hive.ql.security.authorization.PolicyProviderContainer;
import org.apache.hadoop.hive.ql.security.authorization.plugin.HivePolicyProvider;
import org.apache.hadoop.hive.ql.security.authorization.plugin.HivePrivilegeObject;
import org.apache.hadoop.hive.ql.security.authorization.plugin.HiveResourceACLs;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PrivilegeSynchronizer
implements Runnable {
    private static final Logger LOG = LoggerFactory.getLogger(PrivilegeSynchronizer.class);
    public static final String GRANTOR = "ranger";
    private IMetaStoreClient hiveClient;
    private LeaderLatch privilegeSynchronizerLatch;
    private HiveConf hiveConf;
    private PolicyProviderContainer policyProviderContainer;

    public PrivilegeSynchronizer(LeaderLatch privilegeSynchronizerLatch, PolicyProviderContainer policyProviderContainer, HiveConf hiveConf) {
        this.hiveConf = new HiveConf(hiveConf);
        this.hiveConf.set(MetastoreConf.ConfVars.FILTER_HOOK.getVarname(), DefaultMetaStoreFilterHookImpl.class.getName());
        try {
            this.hiveClient = Hive.get(this.hiveConf).getMSC();
        }
        catch (Exception e) {
            throw new RuntimeException("Error creating HiveMetastoreClient", e);
        }
        this.privilegeSynchronizerLatch = privilegeSynchronizerLatch;
        this.policyProviderContainer = policyProviderContainer;
        this.hiveConf = hiveConf;
    }

    private void addACLsToBag(Map<String, Map<HiveResourceACLs.Privilege, HiveResourceACLs.AccessResult>> principalAclsMap, PrivilegeBag privBag, HiveObjectType objectType, String dbName, String tblName, String columnName, PrincipalType principalType, String authorizer) {
        for (Map.Entry<String, Map<HiveResourceACLs.Privilege, HiveResourceACLs.AccessResult>> principalAcls : principalAclsMap.entrySet()) {
            String principal = principalAcls.getKey();
            int[] columnPrivilegeBits = new int[]{0, 0, 0, 0, 0, 0, 0, 0, 0};
            boolean columnUpdateFlag = false;
            block6: for (Map.Entry<HiveResourceACLs.Privilege, HiveResourceACLs.AccessResult> acl : principalAcls.getValue().entrySet()) {
                if (acl.getValue() != HiveResourceACLs.AccessResult.ALLOWED) continue;
                switch (objectType) {
                    case DATABASE: {
                        privBag.addToPrivileges(new HiveObjectPrivilege(new HiveObjectRef(HiveObjectType.DATABASE, dbName, null, null, null), principal, principalType, new PrivilegeGrantInfo(acl.getKey().toString(), (int)(System.currentTimeMillis() / 1000L), GRANTOR, PrincipalType.USER, false), authorizer));
                        continue block6;
                    }
                    case TABLE: {
                        privBag.addToPrivileges(new HiveObjectPrivilege(new HiveObjectRef(HiveObjectType.TABLE, dbName, tblName, null, null), principal, principalType, new PrivilegeGrantInfo(acl.getKey().toString(), (int)(System.currentTimeMillis() / 1000L), GRANTOR, PrincipalType.USER, false), authorizer));
                        continue block6;
                    }
                    case COLUMN: {
                        int privilegeBit = acl.getKey().ordinal();
                        columnPrivilegeBits[privilegeBit] = 1;
                        columnUpdateFlag = true;
                        continue block6;
                    }
                }
                throw new RuntimeException("Get unknown object type " + objectType);
            }
            if (!columnUpdateFlag) continue;
            String columnPrivilegeBitsString = StringUtils.join(Arrays.asList(ArrayUtils.toObject((int[])columnPrivilegeBits)), (String)" ");
            privBag.addToPrivileges(new HiveObjectPrivilege(new HiveObjectRef(HiveObjectType.COLUMN, dbName, tblName, null, columnName), principal, principalType, new PrivilegeGrantInfo(columnPrivilegeBitsString, (int)(System.currentTimeMillis() / 1000L), GRANTOR, PrincipalType.USER, false), authorizer));
            columnUpdateFlag = false;
        }
    }

    private HiveObjectRef getObjToRefresh(HiveObjectType type, String dbName, String objectName) throws Exception {
        HiveObjectRef objToRefresh = null;
        switch (type) {
            case DATACONNECTOR: {
                objToRefresh = new HiveObjectRef(HiveObjectType.DATACONNECTOR, null, objectName, null, null);
                break;
            }
            case DATABASE: {
                objToRefresh = new HiveObjectRef(HiveObjectType.DATABASE, dbName, null, null, null);
                break;
            }
            case TABLE: {
                objToRefresh = new HiveObjectRef(HiveObjectType.TABLE, dbName, objectName, null, null);
                break;
            }
            case COLUMN: {
                objToRefresh = new HiveObjectRef(HiveObjectType.COLUMN, dbName, objectName, null, null);
                break;
            }
            default: {
                throw new RuntimeException("Get unknown object type " + type);
            }
        }
        return objToRefresh;
    }

    private void addGrantPrivilegesToBag(HivePolicyProvider policyProvider, PrivilegeBag privBag, HiveObjectType type, String dbName, String objName, String columnName, String authorizer) throws Exception {
        HiveResourceACLs objectAcls = null;
        switch (type) {
            case DATACONNECTOR: {
                objectAcls = policyProvider.getResourceACLs(new HivePrivilegeObject(HivePrivilegeObject.HivePrivilegeObjectType.DATACONNECTOR, null, objName));
                break;
            }
            case DATABASE: {
                objectAcls = policyProvider.getResourceACLs(new HivePrivilegeObject(HivePrivilegeObject.HivePrivilegeObjectType.DATABASE, dbName, null));
                break;
            }
            case TABLE: {
                objectAcls = policyProvider.getResourceACLs(new HivePrivilegeObject(HivePrivilegeObject.HivePrivilegeObjectType.TABLE_OR_VIEW, dbName, objName));
                break;
            }
            case COLUMN: {
                objectAcls = policyProvider.getResourceACLs(new HivePrivilegeObject(HivePrivilegeObject.HivePrivilegeObjectType.COLUMN, dbName, objName, null, columnName));
                break;
            }
            default: {
                throw new RuntimeException("Get unknown object type " + type);
            }
        }
        if (objectAcls == null) {
            return;
        }
        this.addACLsToBag(objectAcls.getUserPermissions(), privBag, type, dbName, objName, columnName, PrincipalType.USER, authorizer);
        this.addACLsToBag(objectAcls.getGroupPermissions(), privBag, type, dbName, objName, columnName, PrincipalType.GROUP, authorizer);
    }

    @Override
    public void run() {
        while (true) {
            long interval = HiveConf.getTimeVar((Configuration)this.hiveConf, (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_PRIVILEGE_SYNCHRONIZER_INTERVAL, (TimeUnit)TimeUnit.SECONDS);
            try {
                for (HivePolicyProvider policyProvider : this.policyProviderContainer) {
                    LOG.info("Start synchronize privilege " + policyProvider.getClass().getName());
                    String authorizer = policyProvider.getClass().getSimpleName();
                    if (!this.privilegeSynchronizerLatch.await(interval, TimeUnit.SECONDS)) {
                        LOG.info("Not selected as leader, skip");
                        continue;
                    }
                    int numDc = 0;
                    int numDb = 0;
                    int numTbl = 0;
                    for (String dcName : this.hiveClient.getAllDataConnectorNames()) {
                        ++numDc;
                        HiveObjectRef dcToRefresh = this.getObjToRefresh(HiveObjectType.DATACONNECTOR, null, dcName);
                        PrivilegeBag grantDataConnectorBag = new PrivilegeBag();
                        this.addGrantPrivilegesToBag(policyProvider, grantDataConnectorBag, HiveObjectType.DATACONNECTOR, null, dcName, null, authorizer);
                        this.hiveClient.refresh_privileges(dcToRefresh, authorizer, grantDataConnectorBag);
                        LOG.debug("processing data connector: " + dcName);
                    }
                    LOG.info("Success synchronize privilege " + policyProvider.getClass().getName() + ":" + numDc + " dataconnectors");
                    for (String dbName : this.hiveClient.getAllDatabases()) {
                        ++numDb;
                        HiveObjectRef dbToRefresh = this.getObjToRefresh(HiveObjectType.DATABASE, dbName, null);
                        PrivilegeBag grantDatabaseBag = new PrivilegeBag();
                        this.addGrantPrivilegesToBag(policyProvider, grantDatabaseBag, HiveObjectType.DATABASE, dbName, null, null, authorizer);
                        this.hiveClient.refresh_privileges(dbToRefresh, authorizer, grantDatabaseBag);
                        LOG.debug("processing " + dbName);
                        for (String tblName : this.hiveClient.getAllTables(dbName)) {
                            ++numTbl;
                            LOG.debug("processing " + dbName + "." + tblName);
                            HiveObjectRef tableToRefresh = this.getObjToRefresh(HiveObjectType.TABLE, dbName, tblName);
                            PrivilegeBag grantTableBag = new PrivilegeBag();
                            this.addGrantPrivilegesToBag(policyProvider, grantTableBag, HiveObjectType.TABLE, dbName, tblName, null, authorizer);
                            this.hiveClient.refresh_privileges(tableToRefresh, authorizer, grantTableBag);
                            HiveObjectRef tableOfColumnsToRefresh = this.getObjToRefresh(HiveObjectType.COLUMN, dbName, tblName);
                            PrivilegeBag grantColumnBag = new PrivilegeBag();
                            Table tbl = null;
                            try {
                                tbl = this.hiveClient.getTable(dbName, tblName);
                                for (FieldSchema fs : tbl.getPartitionKeys()) {
                                    this.addGrantPrivilegesToBag(policyProvider, grantColumnBag, HiveObjectType.COLUMN, dbName, tblName, fs.getName(), authorizer);
                                }
                                for (FieldSchema fs : tbl.getSd().getCols()) {
                                    this.addGrantPrivilegesToBag(policyProvider, grantColumnBag, HiveObjectType.COLUMN, dbName, tblName, fs.getName(), authorizer);
                                }
                                this.hiveClient.refresh_privileges(tableOfColumnsToRefresh, authorizer, grantColumnBag);
                            }
                            catch (MetaException e) {
                                LOG.debug("Unable to synchronize " + tblName + ":" + e.getMessage());
                            }
                        }
                    }
                    LOG.info("Success synchronize privilege " + policyProvider.getClass().getName() + ":" + numDb + " databases, " + numTbl + " tables");
                }
            }
            catch (Exception e) {
                LOG.error("Error initializing PrivilegeSynchronizer: " + e.getMessage(), (Throwable)e);
            }
            LOG.info("Wait for " + interval + " seconds");
            try {
                Thread.sleep(interval * 1000L);
            }
            catch (InterruptedException interruptedException) {
            }
        }
    }
}

