/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.plan;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.hadoop.hive.ql.exec.vector.VectorColumnMapping;
import org.apache.hadoop.hive.ql.exec.vector.expressions.VectorExpression;
import org.apache.hadoop.hive.ql.plan.Explain;
import org.apache.hadoop.hive.ql.plan.VectorDesc;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfo;

public class OperatorExplainVectorization {
    protected final VectorDesc vectorDesc;
    protected final boolean isNative;

    public OperatorExplainVectorization(VectorDesc vectorDesc, boolean isNative) {
        this.vectorDesc = vectorDesc;
        this.isNative = isNative;
    }

    public List<String> vectorExpressionsToStringList(VectorExpression[] vectorExpressions) {
        if (vectorExpressions == null) {
            return null;
        }
        ArrayList<String> vecExprList = new ArrayList<String>(vectorExpressions.length);
        for (VectorExpression vecExpr : vectorExpressions) {
            vecExprList.add(vecExpr.toString());
        }
        return vecExprList;
    }

    public String outputColumnsToStringList(VectorColumnMapping vectorColumnMapping) {
        int size = vectorColumnMapping.getCount();
        if (size == 0) {
            return null;
        }
        int[] outputColumns = vectorColumnMapping.getOutputColumns();
        return Arrays.toString(outputColumns);
    }

    public List<String> outputColumnsAndTypesToStringList(int[] outputColumns, TypeInfo[] typeInfos) {
        int size = outputColumns.length;
        ArrayList<String> result = new ArrayList<String>(size);
        for (int i = 0; i < size; ++i) {
            result.add(outputColumns[i] + ":" + typeInfos[i].toString());
        }
        return result;
    }

    public List<String> outputColumnsAndTypesToStringList(VectorColumnMapping vectorColumnMapping) {
        int size = vectorColumnMapping.getCount();
        if (size == 0) {
            return null;
        }
        int[] outputColumns = vectorColumnMapping.getOutputColumns();
        TypeInfo[] typeInfos = vectorColumnMapping.getTypeInfos();
        return this.outputColumnsAndTypesToStringList(outputColumns, typeInfos);
    }

    public List<String> columnMappingToStringList(VectorColumnMapping vectorColumnMapping) {
        int size = vectorColumnMapping.getCount();
        if (size == 0) {
            return null;
        }
        int[] inputColumns = vectorColumnMapping.getInputColumns();
        int[] outputColumns = vectorColumnMapping.getOutputColumns();
        ArrayList<String> result = new ArrayList<String>(size);
        for (int i = 0; i < size; ++i) {
            result.add(inputColumns[i] + " -> " + outputColumns[i]);
        }
        return result;
    }

    @Explain(vectorization=Explain.Vectorization.OPERATOR, displayName="className", explainLevels={Explain.Level.DEFAULT, Explain.Level.EXTENDED})
    public String getClassName() {
        return this.vectorDesc.getVectorOpClass().getSimpleName();
    }

    @Explain(vectorization=Explain.Vectorization.OPERATOR, displayName="native", explainLevels={Explain.Level.DEFAULT, Explain.Level.EXTENDED})
    public boolean getNative() {
        return this.isNative;
    }
}

