/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.plan;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Interner;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.common.StringInternUtils;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.exec.IConfigureJobConf;
import org.apache.hadoop.hive.ql.exec.Operator;
import org.apache.hadoop.hive.ql.exec.OperatorUtils;
import org.apache.hadoop.hive.ql.exec.TableScanOperator;
import org.apache.hadoop.hive.ql.exec.Utilities;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedRowBatch;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedSupport;
import org.apache.hadoop.hive.ql.io.AcidUtils;
import org.apache.hadoop.hive.ql.io.HiveInputFormat;
import org.apache.hadoop.hive.ql.optimizer.physical.BucketingSortingCtx;
import org.apache.hadoop.hive.ql.optimizer.physical.VectorizerReason;
import org.apache.hadoop.hive.ql.parse.SplitSample;
import org.apache.hadoop.hive.ql.plan.BaseWork;
import org.apache.hadoop.hive.ql.plan.Explain;
import org.apache.hadoop.hive.ql.plan.ExprNodeDesc;
import org.apache.hadoop.hive.ql.plan.MapredLocalWork;
import org.apache.hadoop.hive.ql.plan.OperatorDesc;
import org.apache.hadoop.hive.ql.plan.PartitionDesc;
import org.apache.hadoop.hive.ql.plan.PlanUtils;
import org.apache.hadoop.hive.ql.plan.TableDesc;
import org.apache.hadoop.hive.ql.plan.VectorPartitionDesc;
import org.apache.hadoop.hive.ql.plan.VectorizationCondition;
import org.apache.hadoop.mapred.InputFormat;
import org.apache.hadoop.mapred.JobConf;

public class MapWork
extends BaseWork {
    private Map<Path, List<String>> pathToAliases = new LinkedHashMap<Path, List<String>>();
    private Map<Path, PartitionDesc> pathToPartitionInfo = new LinkedHashMap<Path, PartitionDesc>();
    private Map<String, Operator<? extends OperatorDesc>> aliasToWork = new LinkedHashMap<String, Operator<? extends OperatorDesc>>();
    private Map<String, PartitionDesc> aliasToPartnInfo = new LinkedHashMap<String, PartitionDesc>();
    private Map<String, SplitSample> nameToSplitSample = new LinkedHashMap<String, SplitSample>();
    private final Map<String, List<BucketingSortingCtx.BucketCol>> bucketedColsByDirectory = new HashMap<String, List<BucketingSortingCtx.BucketCol>>();
    private final Map<String, List<BucketingSortingCtx.SortCol>> sortedColsByDirectory = new HashMap<String, List<BucketingSortingCtx.SortCol>>();
    private Path tmpHDFSPath;
    private Path tmpPathForPartitionPruning;
    private String inputformat;
    private Integer numMapTasks;
    private Long maxSplitSize;
    private Long minSplitSize;
    private Long minSplitSizePerNode;
    private Long minSplitSizePerRack;
    private int samplingType;
    public static final int SAMPLING_ON_PREV_MR = 1;
    public static final int SAMPLING_ON_START = 2;
    private boolean leftInputJoin;
    private String[] baseSrc;
    private List<String> mapAliases;
    private boolean mapperCannotSpanPartns;
    private boolean inputFormatSorted = false;
    private boolean useBucketizedHiveInputFormat;
    private boolean dummyTableScan = false;
    private Map<String, List<TableDesc>> eventSourceTableDescMap = new LinkedHashMap<String, List<TableDesc>>();
    private Map<String, List<String>> eventSourceColumnNameMap = new LinkedHashMap<String, List<String>>();
    private Map<String, List<String>> eventSourceColumnTypeMap = new LinkedHashMap<String, List<String>>();
    private Map<String, List<ExprNodeDesc>> eventSourcePartKeyExprMap = new LinkedHashMap<String, List<ExprNodeDesc>>();
    private Map<String, List<ExprNodeDesc>> eventSourcePredicateExprMap = new LinkedHashMap<String, List<ExprNodeDesc>>();
    private boolean doSplitsGrouping = true;
    private VectorizedRowBatch vectorizedRowBatch;
    private VectorizerReason notEnabledInputFileFormatReason;
    private Set<String> vectorizationInputFileFormatClassNameSet;
    private List<VectorPartitionDesc> vectorPartitionDescList;
    private List<String> vectorizationEnabledConditionsMet;
    private List<String> vectorizationEnabledConditionsNotMet;
    private byte[] includedBuckets;
    private LlapIODescriptor llapIoDesc;
    private boolean isMergeFromResolver;
    private TableScanOperator.ProbeDecodeContext probeDecodeContext = null;
    protected List<Path> inputPaths;
    private boolean useInputPathsDirectly;
    private Properties mergeSplitProperties;

    public MapWork() {
    }

    public MapWork(String name) {
        super(name);
    }

    @Explain(displayName="Path -> Alias", explainLevels={Explain.Level.EXTENDED})
    public Map<Path, List<String>> getPathToAliases() {
        return this.pathToAliases;
    }

    public void setPathToAliases(Map<Path, List<String>> pathToAliases) {
        for (Path p : pathToAliases.keySet()) {
            StringInternUtils.internUriStringsInPath((Path)p);
        }
        this.pathToAliases = pathToAliases;
    }

    public void addPathToAlias(Path path, List<String> aliases) {
        StringInternUtils.internUriStringsInPath((Path)path);
        this.pathToAliases.put(path, aliases);
    }

    public void addPathToAlias(Path path, String newAlias) {
        List<String> aliases = this.pathToAliases.get(path);
        if (aliases == null) {
            aliases = new ArrayList<String>(1);
            StringInternUtils.internUriStringsInPath((Path)path);
            this.pathToAliases.put(path, aliases);
        }
        aliases.add(newAlias.intern());
    }

    public void removePathToAlias(Path path) {
        this.pathToAliases.remove(path);
    }

    @Explain(displayName="Truncated Path -> Alias", explainLevels={Explain.Level.EXTENDED})
    public Map<String, List<String>> getTruncatedPathToAliases() {
        LinkedHashMap<String, List<String>> trunPathToAliases = new LinkedHashMap<String, List<String>>();
        for (Map.Entry<Path, List<String>> entry : this.pathToAliases.entrySet()) {
            Path origiKey = entry.getKey();
            String newKey = PlanUtils.removePrefixFromWarehouseConfig(origiKey.toString());
            List<String> value = entry.getValue();
            trunPathToAliases.put(newKey, value);
        }
        return trunPathToAliases;
    }

    @Explain(displayName="Path -> Partition", explainLevels={Explain.Level.EXTENDED})
    public Map<Path, PartitionDesc> getPathToPartitionInfo() {
        return this.pathToPartitionInfo;
    }

    public void setPathToPartitionInfo(Map<Path, PartitionDesc> pathToPartitionInfo) {
        for (Path p : pathToPartitionInfo.keySet()) {
            StringInternUtils.internUriStringsInPath((Path)p);
        }
        this.pathToPartitionInfo = pathToPartitionInfo;
    }

    public void addPathToPartitionInfo(Path path, PartitionDesc partitionInfo) {
        if (this.pathToPartitionInfo == null) {
            this.pathToPartitionInfo = new LinkedHashMap<Path, PartitionDesc>();
        }
        this.pathToPartitionInfo.put(path, partitionInfo);
    }

    public void removePathToPartitionInfo(Path path) {
        this.pathToPartitionInfo.remove(path);
    }

    public void deriveExplainAttributes() {
        MapredLocalWork mapLocalWork;
        if (this.pathToPartitionInfo != null) {
            for (Map.Entry<Path, PartitionDesc> entry : this.pathToPartitionInfo.entrySet()) {
                entry.getValue().deriveBaseFileName(entry.getKey());
            }
        }
        if ((mapLocalWork = this.getMapRedLocalWork()) != null) {
            mapLocalWork.deriveExplainAttributes();
        }
    }

    public void deriveLlap(Configuration conf, boolean isExecDriver) {
        boolean hasPathToPartInfo;
        boolean hasLlap = false;
        boolean hasNonLlap = false;
        boolean hasAcid = false;
        boolean hasCacheOnly = false;
        boolean isLlapOn = HiveConf.getBoolVar((Configuration)conf, (HiveConf.ConfVars)HiveConf.ConfVars.LLAP_IO_ENABLED, (boolean)this.llapMode);
        boolean canWrapAny = false;
        boolean doCheckIfs = false;
        if (isLlapOn && !(canWrapAny = Utilities.getIsVectorized(conf, this)) && !isExecDriver) {
            canWrapAny = HiveConf.getBoolVar((Configuration)conf, (HiveConf.ConfVars)HiveConf.ConfVars.LLAP_IO_NONVECTOR_WRAPPER_ENABLED);
            doCheckIfs = true;
        }
        boolean bl = hasPathToPartInfo = this.pathToPartitionInfo != null && !this.pathToPartitionInfo.isEmpty();
        if (hasPathToPartInfo) {
            for (PartitionDesc part : this.pathToPartitionInfo.values()) {
                boolean isUsingLlapIo;
                Class<? extends InputFormat> inputFormatClass = part.getInputFileFormatClass();
                boolean bl2 = isUsingLlapIo = canWrapAny && (HiveInputFormat.canWrapForLlap(inputFormatClass, doCheckIfs) || HiveInputFormat.checkInputFormatForLlapEncode(conf, inputFormatClass.getCanonicalName()));
                if (isUsingLlapIo) {
                    if (part.getTableDesc() != null && AcidUtils.isTablePropertyTransactional(part.getTableDesc().getProperties())) {
                        hasAcid = true;
                        continue;
                    }
                    hasLlap = true;
                    continue;
                }
                if (isLlapOn && HiveInputFormat.canInjectCaches(inputFormatClass, Utilities.getIsVectorized(conf, this))) {
                    hasCacheOnly = true;
                    continue;
                }
                hasNonLlap = true;
            }
        }
        this.llapIoDesc = MapWork.deriveLlapIoDescString(isLlapOn, canWrapAny, hasPathToPartInfo, hasLlap, hasNonLlap, hasAcid, hasCacheOnly);
    }

    private static LlapIODescriptor deriveLlapIoDescString(boolean isLlapOn, boolean canWrapAny, boolean hasPathToPartInfo, boolean hasLlap, boolean hasNonLlap, boolean hasAcid, boolean hasCacheOnly) {
        if (!isLlapOn) {
            return LlapIODescriptor.DISABLED;
        }
        if (!canWrapAny && !hasCacheOnly) {
            return LlapIODescriptor.NO_INPUTS;
        }
        if (!hasPathToPartInfo) {
            return LlapIODescriptor.UNKNOWN;
        }
        int varieties = (hasAcid ? 1 : 0) + (hasLlap ? 1 : 0) + (hasCacheOnly ? 1 : 0) + (hasNonLlap ? 1 : 0);
        if (varieties > 1) {
            return LlapIODescriptor.SOME_INPUTS;
        }
        if (hasAcid) {
            return LlapIODescriptor.ACID;
        }
        if (hasLlap) {
            return LlapIODescriptor.ALL_INPUTS;
        }
        if (hasCacheOnly) {
            return LlapIODescriptor.CACHE_ONLY;
        }
        return LlapIODescriptor.NO_INPUTS;
    }

    public void internTable(Interner<TableDesc> interner) {
        if (this.aliasToPartnInfo != null) {
            for (PartitionDesc part : this.aliasToPartnInfo.values()) {
                if (part == null) continue;
                part.intern(interner);
            }
        }
        if (this.pathToPartitionInfo != null) {
            for (PartitionDesc part : this.pathToPartitionInfo.values()) {
                part.intern(interner);
            }
        }
    }

    public Map<String, PartitionDesc> getAliasToPartnInfo() {
        return this.aliasToPartnInfo;
    }

    public void setAliasToPartnInfo(LinkedHashMap<String, PartitionDesc> aliasToPartnInfo) {
        this.aliasToPartnInfo = aliasToPartnInfo;
    }

    public Map<String, Operator<? extends OperatorDesc>> getAliasToWork() {
        return this.aliasToWork;
    }

    public void setAliasToWork(Map<String, Operator<? extends OperatorDesc>> aliasToWork) {
        this.aliasToWork = aliasToWork;
    }

    @Explain(displayName="Split Sample", explainLevels={Explain.Level.EXTENDED})
    public Map<String, SplitSample> getNameToSplitSample() {
        return this.nameToSplitSample;
    }

    @Explain(displayName="LLAP IO", vectorization=Explain.Vectorization.SUMMARY_PATH)
    public String getLlapIoDescString() {
        return this.llapIoDesc.desc;
    }

    public boolean getCacheAffinity() {
        return this.llapIoDesc.cached;
    }

    public void setNameToSplitSample(Map<String, SplitSample> nameToSplitSample) {
        this.nameToSplitSample = nameToSplitSample;
    }

    public Integer getNumMapTasks() {
        return this.numMapTasks;
    }

    public void setNumMapTasks(Integer numMapTasks) {
        this.numMapTasks = numMapTasks;
    }

    @VisibleForTesting
    public void addMapWork(Path path, String alias, Operator<?> work, PartitionDesc pd) {
        StringInternUtils.internUriStringsInPath((Path)path);
        List<String> curAliases = this.pathToAliases.get(path);
        if (curAliases == null) {
            assert (this.pathToPartitionInfo.get(path) == null);
            curAliases = new ArrayList<String>();
            this.pathToAliases.put(path, curAliases);
            this.pathToPartitionInfo.put(path, pd);
        } else assert (this.pathToPartitionInfo.get(path) != null);
        for (String oneAlias : curAliases) {
            if (!oneAlias.equals(alias)) continue;
            throw new RuntimeException("Multiple aliases named: " + alias + " for path: " + path);
        }
        curAliases.add(alias);
        if (this.aliasToWork.get(alias) != null) {
            throw new RuntimeException("Existing work for alias: " + alias);
        }
        this.aliasToWork.put(alias, work);
    }

    public boolean isInputFormatSorted() {
        return this.inputFormatSorted;
    }

    public void setInputFormatSorted(boolean inputFormatSorted) {
        this.inputFormatSorted = inputFormatSorted;
    }

    public void resolveDynamicPartitionStoredAsSubDirsMerge(HiveConf conf, Path path, TableDesc tblDesc, List<String> aliases, PartitionDesc partDesc) {
        StringInternUtils.internUriStringsInPath((Path)path);
        this.pathToAliases.put(path, aliases);
        this.pathToPartitionInfo.put(path, partDesc);
    }

    private void setAliases() {
        if (this.aliasToWork == null) {
            return;
        }
        for (String oneAlias : this.aliasToWork.keySet()) {
            this.aliasToWork.get(oneAlias).setAlias(oneAlias);
        }
    }

    @Explain(displayName="Execution mode", explainLevels={Explain.Level.USER, Explain.Level.DEFAULT, Explain.Level.EXTENDED}, vectorization=Explain.Vectorization.SUMMARY_PATH)
    public String getExecutionMode() {
        if (!(!this.vectorMode || this.getIsTestForcedVectorizationEnable() && this.getIsTestVectorizationSuppressExplainExecutionMode())) {
            if (this.llapMode) {
                if (this.uberMode) {
                    return "vectorized, uber";
                }
                return "vectorized, llap";
            }
            return "vectorized";
        }
        if (this.llapMode) {
            return this.uberMode ? "uber" : "llap";
        }
        return null;
    }

    @Override
    public void replaceRoots(Map<Operator<?>, Operator<?>> replacementMap) {
        LinkedHashMap<String, Operator<? extends OperatorDesc>> newAliasToWork = new LinkedHashMap<String, Operator<? extends OperatorDesc>>();
        for (Map.Entry<String, Operator<? extends OperatorDesc>> entry : this.aliasToWork.entrySet()) {
            newAliasToWork.put(entry.getKey(), replacementMap.get(entry.getValue()));
        }
        this.setAliasToWork(newAliasToWork);
    }

    @Override
    @Explain(displayName="Map Operator Tree", explainLevels={Explain.Level.USER, Explain.Level.DEFAULT, Explain.Level.EXTENDED}, vectorization=Explain.Vectorization.OPERATOR_PATH)
    public Set<Operator<? extends OperatorDesc>> getAllRootOperators() {
        LinkedHashSet<Operator<? extends OperatorDesc>> opSet = new LinkedHashSet<Operator<? extends OperatorDesc>>();
        for (Operator<? extends OperatorDesc> op : this.getAliasToWork().values()) {
            opSet.add(op);
        }
        return opSet;
    }

    @Override
    public Operator<? extends OperatorDesc> getAnyRootOperator() {
        return this.aliasToWork.isEmpty() ? null : this.aliasToWork.values().iterator().next();
    }

    public void mergeAliasedInput(String alias, Path pathDir, PartitionDesc partitionInfo) {
        StringInternUtils.internUriStringsInPath((Path)pathDir);
        alias = alias.intern();
        List<String> aliases = this.pathToAliases.get(pathDir);
        if (aliases == null) {
            aliases = new ArrayList<String>(Arrays.asList(alias));
            this.pathToAliases.put(pathDir, aliases);
            this.pathToPartitionInfo.put(pathDir, partitionInfo);
        } else {
            aliases.add(alias);
        }
    }

    public void initialize() {
        this.setAliases();
    }

    public Long getMaxSplitSize() {
        return this.maxSplitSize;
    }

    public void setMaxSplitSize(Long maxSplitSize) {
        this.maxSplitSize = maxSplitSize;
    }

    public Long getMinSplitSize() {
        return this.minSplitSize;
    }

    public void setMinSplitSize(Long minSplitSize) {
        this.minSplitSize = minSplitSize;
    }

    public Long getMinSplitSizePerNode() {
        return this.minSplitSizePerNode;
    }

    public void setMinSplitSizePerNode(Long minSplitSizePerNode) {
        this.minSplitSizePerNode = minSplitSizePerNode;
    }

    public Long getMinSplitSizePerRack() {
        return this.minSplitSizePerRack;
    }

    public void setMinSplitSizePerRack(Long minSplitSizePerRack) {
        this.minSplitSizePerRack = minSplitSizePerRack;
    }

    public String getInputformat() {
        return this.inputformat;
    }

    public void setInputformat(String inputformat) {
        this.inputformat = inputformat;
    }

    public boolean isUseBucketizedHiveInputFormat() {
        return this.useBucketizedHiveInputFormat;
    }

    public void setUseBucketizedHiveInputFormat(boolean useBucketizedHiveInputFormat) {
        this.useBucketizedHiveInputFormat = useBucketizedHiveInputFormat;
    }

    public void setMapperCannotSpanPartns(boolean mapperCannotSpanPartns) {
        this.mapperCannotSpanPartns = mapperCannotSpanPartns;
    }

    public boolean isMapperCannotSpanPartns() {
        return this.mapperCannotSpanPartns;
    }

    public ArrayList<String> getAliases() {
        return new ArrayList<String>(this.aliasToWork.keySet());
    }

    public ArrayList<Operator<?>> getWorks() {
        return new ArrayList(this.aliasToWork.values());
    }

    public ArrayList<Path> getPaths() {
        return new ArrayList<Path>(this.pathToAliases.keySet());
    }

    public ArrayList<PartitionDesc> getPartitionDescs() {
        return new ArrayList<PartitionDesc>(this.aliasToPartnInfo.values());
    }

    public Path getTmpHDFSPath() {
        return this.tmpHDFSPath;
    }

    public void setTmpHDFSPath(Path tmpHDFSPath) {
        this.tmpHDFSPath = tmpHDFSPath;
    }

    public Path getTmpPathForPartitionPruning() {
        return this.tmpPathForPartitionPruning;
    }

    public void setTmpPathForPartitionPruning(Path tmpPathForPartitionPruning) {
        this.tmpPathForPartitionPruning = tmpPathForPartitionPruning;
    }

    public void mergingInto(MapWork mapWork) {
        mapWork.useBucketizedHiveInputFormat |= this.useBucketizedHiveInputFormat;
    }

    @Explain(displayName="Path -> Bucketed Columns", explainLevels={Explain.Level.EXTENDED})
    public Map<String, List<BucketingSortingCtx.BucketCol>> getBucketedColsByDirectory() {
        return this.bucketedColsByDirectory;
    }

    @Explain(displayName="Path -> Sorted Columns", explainLevels={Explain.Level.EXTENDED})
    public Map<String, List<BucketingSortingCtx.SortCol>> getSortedColsByDirectory() {
        return this.sortedColsByDirectory;
    }

    public int getSamplingType() {
        return this.samplingType;
    }

    public void setSamplingType(int samplingType) {
        this.samplingType = samplingType;
    }

    @Explain(displayName="Sampling", explainLevels={Explain.Level.EXTENDED})
    public String getSamplingTypeString() {
        return this.samplingType == 1 ? "SAMPLING_ON_PREV_MR" : (this.samplingType == 2 ? "SAMPLING_ON_START" : null);
    }

    @Override
    public void configureJobConf(JobConf job) {
        super.configureJobConf(job);
        for (PartitionDesc partition : this.aliasToPartnInfo.values()) {
            PlanUtils.configureJobConf(partition.getTableDesc(), job);
        }
        Collection<Operator<?>> mappers = this.aliasToWork.values();
        for (IConfigureJobConf icjc : OperatorUtils.findOperators(mappers, IConfigureJobConf.class)) {
            icjc.configureJobConf(job);
        }
    }

    public void setDummyTableScan(boolean dummyTableScan) {
        this.dummyTableScan = dummyTableScan;
    }

    public boolean getDummyTableScan() {
        return this.dummyTableScan;
    }

    public void setEventSourceTableDescMap(Map<String, List<TableDesc>> map) {
        this.eventSourceTableDescMap = map;
    }

    public Map<String, List<TableDesc>> getEventSourceTableDescMap() {
        return this.eventSourceTableDescMap;
    }

    public void setEventSourceColumnNameMap(Map<String, List<String>> map) {
        this.eventSourceColumnNameMap = map;
    }

    public Map<String, List<String>> getEventSourceColumnNameMap() {
        return this.eventSourceColumnNameMap;
    }

    public Map<String, List<String>> getEventSourceColumnTypeMap() {
        return this.eventSourceColumnTypeMap;
    }

    public void setEventSourceColumnTypeMap(Map<String, List<String>> eventSourceColumnTypeMap) {
        this.eventSourceColumnTypeMap = eventSourceColumnTypeMap;
    }

    public Map<String, List<ExprNodeDesc>> getEventSourcePartKeyExprMap() {
        return this.eventSourcePartKeyExprMap;
    }

    public void setEventSourcePartKeyExprMap(Map<String, List<ExprNodeDesc>> map) {
        this.eventSourcePartKeyExprMap = map;
    }

    public Map<String, List<ExprNodeDesc>> getEventSourcePredicateExprMap() {
        return this.eventSourcePredicateExprMap;
    }

    public void setEventSourcePredicateExprMap(Map<String, List<ExprNodeDesc>> eventSourcePredicateExprMap) {
        this.eventSourcePredicateExprMap = eventSourcePredicateExprMap;
    }

    public void setDoSplitsGrouping(boolean doSplitsGrouping) {
        this.doSplitsGrouping = doSplitsGrouping;
    }

    public boolean getDoSplitsGrouping() {
        return this.doSplitsGrouping;
    }

    public boolean isLeftInputJoin() {
        return this.leftInputJoin;
    }

    public void setLeftInputJoin(boolean leftInputJoin) {
        this.leftInputJoin = leftInputJoin;
    }

    public String[] getBaseSrc() {
        return this.baseSrc;
    }

    public void setBaseSrc(String[] baseSrc) {
        this.baseSrc = baseSrc;
    }

    public List<String> getMapAliases() {
        return this.mapAliases;
    }

    public void setMapAliases(List<String> mapAliases) {
        this.mapAliases = mapAliases;
    }

    public BitSet getIncludedBuckets() {
        return this.includedBuckets != null ? BitSet.valueOf(this.includedBuckets) : null;
    }

    public void setIncludedBuckets(BitSet includedBuckets) {
        this.includedBuckets = includedBuckets == null ? null : includedBuckets.toByteArray();
    }

    public void setVectorizedRowBatch(VectorizedRowBatch vectorizedRowBatch) {
        this.vectorizedRowBatch = vectorizedRowBatch;
    }

    public VectorizedRowBatch getVectorizedRowBatch() {
        return this.vectorizedRowBatch;
    }

    public void setIsMergeFromResolver(boolean b) {
        this.isMergeFromResolver = b;
    }

    public boolean isMergeFromResolver() {
        return this.isMergeFromResolver;
    }

    public void setUseVectorizedInputFileFormat(boolean useVectorizedInputFileFormat) {
        this.useVectorizedInputFileFormat = useVectorizedInputFileFormat;
    }

    public boolean getUseVectorizedInputFileFormat() {
        return this.useVectorizedInputFileFormat;
    }

    public void setInputFormatSupportSet(Set<VectorizedSupport.Support> inputFormatSupportSet) {
        this.inputFormatSupportSet = inputFormatSupportSet;
    }

    public Set<VectorizedSupport.Support> getInputFormatSupportSet() {
        return this.inputFormatSupportSet;
    }

    public void setSupportSetInUse(Set<VectorizedSupport.Support> supportSetInUse) {
        this.supportSetInUse = supportSetInUse;
    }

    public Set<VectorizedSupport.Support> getSupportSetInUse() {
        return this.supportSetInUse;
    }

    public void setSupportRemovedReasons(List<String> supportRemovedReasons) {
        this.supportRemovedReasons = supportRemovedReasons;
    }

    public List<String> getSupportRemovedReasons() {
        return this.supportRemovedReasons;
    }

    public void setNotEnabledInputFileFormatReason(VectorizerReason notEnabledInputFileFormatReason) {
        this.notEnabledInputFileFormatReason = notEnabledInputFileFormatReason;
    }

    public VectorizerReason getNotEnabledInputFileFormatReason() {
        return this.notEnabledInputFileFormatReason;
    }

    public void setVectorizationInputFileFormatClassNameSet(Set<String> vectorizationInputFileFormatClassNameSet) {
        this.vectorizationInputFileFormatClassNameSet = vectorizationInputFileFormatClassNameSet;
    }

    public Set<String> getVectorizationInputFileFormatClassNameSet() {
        return this.vectorizationInputFileFormatClassNameSet;
    }

    public void setVectorPartitionDescList(List<VectorPartitionDesc> vectorPartitionDescList) {
        this.vectorPartitionDescList = vectorPartitionDescList;
    }

    public List<VectorPartitionDesc> getVectorPartitionDescList() {
        return this.vectorPartitionDescList;
    }

    public void setVectorizationEnabledConditionsMet(Collection<String> vectorizationEnabledConditionsMet) {
        this.vectorizationEnabledConditionsMet = vectorizationEnabledConditionsMet == null ? null : VectorizationCondition.addBooleans(vectorizationEnabledConditionsMet, true);
    }

    public List<String> getVectorizationEnabledConditionsMet() {
        return this.vectorizationEnabledConditionsMet;
    }

    public void setVectorizationEnabledConditionsNotMet(Collection<String> vectorizationEnabledConditionsNotMet) {
        this.vectorizationEnabledConditionsNotMet = vectorizationEnabledConditionsNotMet == null ? null : VectorizationCondition.addBooleans(vectorizationEnabledConditionsNotMet, false);
    }

    public List<String> getVectorizationEnabledConditionsNotMet() {
        return this.vectorizationEnabledConditionsNotMet;
    }

    public TableScanOperator.ProbeDecodeContext getProbeDecodeContext() {
        return this.probeDecodeContext;
    }

    public void setProbeDecodeContext(TableScanOperator.ProbeDecodeContext probeDecodeContext) {
        this.probeDecodeContext = probeDecodeContext;
    }

    @Explain(vectorization=Explain.Vectorization.SUMMARY, displayName="Map Vectorization", explainLevels={Explain.Level.DEFAULT, Explain.Level.EXTENDED})
    public MapExplainVectorization getMapExplainVectorization() {
        if (!this.getVectorizationExamined()) {
            return null;
        }
        return new MapExplainVectorization(this);
    }

    public List<Path> getInputPaths() {
        return this.inputPaths;
    }

    public void setInputPaths(List<Path> inputPaths) {
        this.inputPaths = inputPaths;
    }

    public void setUseInputPathsDirectly(boolean useInputPathsDirectly) {
        this.useInputPathsDirectly = useInputPathsDirectly;
    }

    public boolean isUseInputPathsDirectly() {
        return this.useInputPathsDirectly;
    }

    public Properties getMergeSplitProperties() {
        return this.mergeSplitProperties;
    }

    public void setMergeSplitProperties(Properties mergeSplitProperties) {
        this.mergeSplitProperties = mergeSplitProperties;
    }

    public static enum LlapIODescriptor {
        DISABLED(null, false),
        NO_INPUTS("no inputs", false),
        UNKNOWN("unknown", false),
        SOME_INPUTS("some inputs", false),
        ACID("may be used (ACID table)", true),
        ALL_INPUTS("all inputs", true),
        CACHE_ONLY("all inputs (cache only)", true);

        final String desc;
        final boolean cached;

        private LlapIODescriptor(String desc, boolean cached) {
            this.desc = desc;
            this.cached = cached;
        }
    }

    public class MapExplainVectorization
    extends BaseWork.BaseExplainVectorization {
        private final MapWork mapWork;

        public MapExplainVectorization(MapWork mapWork) {
            super(mapWork);
            this.mapWork = mapWork;
        }

        @Explain(vectorization=Explain.Vectorization.SUMMARY, displayName="inputFileFormats", explainLevels={Explain.Level.DEFAULT, Explain.Level.EXTENDED})
        public Set<String> inputFileFormats() {
            return this.mapWork.getVectorizationInputFileFormatClassNameSet();
        }

        @Explain(vectorization=Explain.Vectorization.SUMMARY, displayName="inputFormatFeatureSupport", explainLevels={Explain.Level.DEFAULT, Explain.Level.EXTENDED})
        public String getInputFormatSupport() {
            Set<VectorizedSupport.Support> inputFormatSupportSet = this.mapWork.getInputFormatSupportSet();
            if (inputFormatSupportSet == null) {
                return null;
            }
            return inputFormatSupportSet.toString();
        }

        @Explain(vectorization=Explain.Vectorization.SUMMARY, displayName="featureSupportInUse", explainLevels={Explain.Level.DEFAULT, Explain.Level.EXTENDED})
        public String getVectorizationSupportInUse() {
            Set<VectorizedSupport.Support> supportSet = this.mapWork.getSupportSetInUse();
            if (supportSet == null) {
                return null;
            }
            return supportSet.toString();
        }

        @Explain(vectorization=Explain.Vectorization.SUMMARY, displayName="vectorizationSupportRemovedReasons", explainLevels={Explain.Level.DEFAULT, Explain.Level.EXTENDED})
        public String getSupportRemovedReasons() {
            List<String> supportRemovedReasons = this.mapWork.getSupportRemovedReasons();
            if (supportRemovedReasons == null || supportRemovedReasons.isEmpty()) {
                return null;
            }
            return supportRemovedReasons.toString();
        }

        @Explain(vectorization=Explain.Vectorization.SUMMARY, displayName="enabledConditionsMet", explainLevels={Explain.Level.DEFAULT, Explain.Level.EXTENDED})
        public List<String> enabledConditionsMet() {
            return this.mapWork.getVectorizationEnabledConditionsMet();
        }

        @Explain(vectorization=Explain.Vectorization.SUMMARY, displayName="enabledConditionsNotMet", explainLevels={Explain.Level.DEFAULT, Explain.Level.EXTENDED})
        public List<String> enabledConditionsNotMet() {
            return this.mapWork.getVectorizationEnabledConditionsNotMet();
        }
    }
}

