/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.parse.repl.dump.events;

import java.util.ArrayList;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.api.NotificationEvent;
import org.apache.hadoop.hive.metastore.api.Partition;
import org.apache.hadoop.hive.metastore.messaging.AlterPartitionsMessage;
import org.apache.hadoop.hive.ql.metadata.Table;
import org.apache.hadoop.hive.ql.parse.EximUtil;
import org.apache.hadoop.hive.ql.parse.repl.DumpType;
import org.apache.hadoop.hive.ql.parse.repl.dump.Utils;
import org.apache.hadoop.hive.ql.parse.repl.dump.events.AbstractEventHandler;
import org.apache.hadoop.hive.ql.parse.repl.dump.events.EventHandler;
import org.apache.hadoop.hive.ql.parse.repl.load.DumpMetaData;

public class AlterPartitionsHandler
extends AbstractEventHandler<AlterPartitionsMessage> {
    private final boolean isTruncateOp;
    private final org.apache.hadoop.hive.metastore.api.Table tableObject;
    private final Iterable<Partition> partitions;

    AlterPartitionsHandler(NotificationEvent event) throws Exception {
        super(event);
        AlterPartitionsMessage apm = (AlterPartitionsMessage)this.eventMessage;
        this.isTruncateOp = apm.getIsTruncateOp();
        this.tableObject = apm.getTableObj();
        this.partitions = apm.getPartitionObjs();
    }

    @Override
    AlterPartitionsMessage eventMessage(String stringRepresentation) {
        return this.deserializer.getAlterPartitionsMessage(stringRepresentation);
    }

    @Override
    public void handle(EventHandler.Context withinContext) throws Exception {
        LOG.info("Processing#{} ALTER_PARTITIONS message : {}", (Object)this.fromEventId(), (Object)this.eventMessageAsJSON);
        if (withinContext.hiveConf.getBoolVar(HiveConf.ConfVars.REPL_DUMP_METADATA_ONLY)) {
            return;
        }
        Table qlMdTable = new Table(this.tableObject);
        if (!Utils.shouldReplicate(withinContext.replicationSpec, qlMdTable, true, withinContext.getTablesForBootstrap(), withinContext.oldReplScope, withinContext.hiveConf)) {
            return;
        }
        if (!this.isTruncateOp) {
            withinContext.replicationSpec.setIsMetadataOnly(true);
            ArrayList<org.apache.hadoop.hive.ql.metadata.Partition> partitionObjs = new ArrayList<org.apache.hadoop.hive.ql.metadata.Partition>();
            for (Partition part : this.partitions) {
                partitionObjs.add(new org.apache.hadoop.hive.ql.metadata.Partition(qlMdTable, part));
            }
            Path metaDataPath = new Path(withinContext.eventRoot, "_metadata");
            EximUtil.createExportDump(metaDataPath.getFileSystem((Configuration)withinContext.hiveConf), metaDataPath, qlMdTable, partitionObjs, withinContext.replicationSpec, withinContext.hiveConf);
        }
        DumpMetaData dmd = withinContext.createDmd(this);
        dmd.setPayload(this.eventMessageAsJSON);
        dmd.write();
    }

    @Override
    public DumpType dumpType() {
        return this.isTruncateOp ? DumpType.EVENT_TRUNCATE_PARTITION : DumpType.EVENT_ALTER_PARTITION;
    }
}

