/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.parse.repl.dump.events;

import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import javax.security.auth.login.LoginException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.ReplChangeManager;
import org.apache.hadoop.hive.metastore.api.NotificationEvent;
import org.apache.hadoop.hive.metastore.messaging.EventMessage;
import org.apache.hadoop.hive.metastore.messaging.MessageDeserializer;
import org.apache.hadoop.hive.metastore.messaging.MessageEncoder;
import org.apache.hadoop.hive.metastore.messaging.json.JSONMessageEncoder;
import org.apache.hadoop.hive.ql.exec.repl.util.ReplUtils;
import org.apache.hadoop.hive.ql.metadata.HiveFatalException;
import org.apache.hadoop.hive.ql.metadata.Partition;
import org.apache.hadoop.hive.ql.metadata.Table;
import org.apache.hadoop.hive.ql.parse.SemanticException;
import org.apache.hadoop.hive.ql.parse.repl.CopyUtils;
import org.apache.hadoop.hive.ql.parse.repl.dump.Utils;
import org.apache.hadoop.hive.ql.parse.repl.dump.events.EventHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class AbstractEventHandler<T extends EventMessage>
implements EventHandler {
    static final Logger LOG = LoggerFactory.getLogger(AbstractEventHandler.class);
    static final MessageEncoder jsonMessageEncoder = JSONMessageEncoder.getInstance();
    final NotificationEvent event;
    final MessageDeserializer deserializer;
    final String eventMessageAsJSON;
    final T eventMessage;

    AbstractEventHandler(NotificationEvent event) {
        this.event = event;
        this.deserializer = ReplUtils.getEventDeserializer(event);
        this.eventMessage = this.eventMessage(event.getMessage());
        this.eventMessageAsJSON = this.eventMessageAsJSON(this.eventMessage);
    }

    abstract T eventMessage(String var1);

    private String eventMessageAsJSON(T eventMessage) {
        if (eventMessage == null) {
            return null;
        }
        return jsonMessageEncoder.getSerializer().serialize(eventMessage);
    }

    @Override
    public long fromEventId() {
        return this.event.getEventId();
    }

    @Override
    public long toEventId() {
        return this.event.getEventId();
    }

    private BufferedWriter writer(EventHandler.Context withinContext, Path dataPath) throws IOException {
        Path filesPath = new Path(dataPath, "_files");
        FileSystem fs = dataPath.getFileSystem((Configuration)withinContext.hiveConf);
        return new BufferedWriter(new OutputStreamWriter((OutputStream)fs.create(filesPath)));
    }

    protected void writeEncodedDumpFiles(EventHandler.Context withinContext, Iterable<String> files, Path dataPath) throws IOException, SemanticException {
        boolean replaceNSInHACase = withinContext.hiveConf.getBoolVar(HiveConf.ConfVars.REPL_HA_DATAPATH_REPLACE_REMOTE_NAMESERVICE);
        try (BufferedWriter fileListWriter = this.writer(withinContext, dataPath);){
            for (String file : files) {
                String encodedFilePath = replaceNSInHACase ? Utils.replaceNameserviceInEncodedURI(file, withinContext.hiveConf) : file;
                fileListWriter.write(encodedFilePath);
                fileListWriter.newLine();
            }
        }
    }

    protected void writeFileEntry(Table table, Partition ptn, String file, EventHandler.Context withinContext) throws IOException, LoginException, HiveFatalException {
        HiveConf hiveConf = withinContext.hiveConf;
        String distCpDoAsUser = hiveConf.getVar(HiveConf.ConfVars.HIVE_DISTCP_DOAS_USER);
        if (!Utils.shouldDumpMetaDataOnly(withinContext.hiveConf)) {
            Path dataPath = new Path(withinContext.eventRoot, "data");
            if (table.isPartitioned()) {
                dataPath = new Path(dataPath, ptn.getName());
            }
            String[] decodedURISplits = ReplChangeManager.decodeFileUri((String)file);
            Path srcDataPath = new Path(decodedURISplits[0]);
            if (dataPath.toUri().getScheme() == null) {
                dataPath = new Path(srcDataPath.toUri().getScheme(), srcDataPath.toUri().getAuthority(), dataPath.toString());
            }
            ArrayList<ReplChangeManager.FileInfo> filePaths = new ArrayList<ReplChangeManager.FileInfo>();
            ReplChangeManager.FileInfo fileInfo = ReplChangeManager.getFileInfo((Path)new Path(decodedURISplits[0]), (String)decodedURISplits[1], (String)decodedURISplits[2], (String)decodedURISplits[3], (Configuration)hiveConf);
            filePaths.add(fileInfo);
            FileSystem dstFs = dataPath.getFileSystem((Configuration)hiveConf);
            CopyUtils copyUtils = new CopyUtils(distCpDoAsUser, hiveConf, dstFs);
            copyUtils.copyAndVerify(dataPath, filePaths, srcDataPath, true, false);
            copyUtils.renameFileCopiedFromCmPath(dataPath, dstFs, filePaths);
        }
    }
}

