/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.parse;

import org.apache.calcite.rel.RelNode;
import org.apache.hadoop.hive.ql.parse.ASTNode;
import org.apache.hadoop.hive.ql.parse.QBSubQuery;
import org.apache.hadoop.hive.ql.parse.SemanticException;
import org.apache.hadoop.hive.ql.parse.SubQueryUtils;

public class QBSubQueryParseInfo {
    private final boolean hasAggregateExprs;
    private final boolean hasExplicitGby;
    private final QBSubQuery.SubQueryTypeDef operator;
    private RelNode subQueryRelNode;

    public static QBSubQueryParseInfo parse(ASTNode subQueryExprNode) throws SemanticException {
        ASTNode subQueryOperatorAST = (ASTNode)subQueryExprNode.getChild(0);
        ASTNode subQueryAST = (ASTNode)subQueryExprNode.getChild(1);
        ASTNode insertClause = (ASTNode)subQueryAST.getFirstChildWithType(1055);
        ASTNode selectClause = (ASTNode)insertClause.getChild(1);
        int selectExprStart = 0;
        if (selectClause.getChild(0).getType() == 427) {
            selectExprStart = 1;
        }
        boolean hasAggregateExprs = false;
        for (int i = selectExprStart; i < selectClause.getChildCount(); ++i) {
            ASTNode selectItem = (ASTNode)selectClause.getChild(i);
            int r = SubQueryUtils.checkAggOrWindowing(selectItem);
            hasAggregateExprs |= r == 1 | r == 2;
        }
        boolean hasExplicitGby = false;
        for (int i = 0; i < insertClause.getChildCount(); ++i) {
            if (insertClause.getChild(i).getType() != 1044) continue;
            hasExplicitGby = true;
            break;
        }
        return new QBSubQueryParseInfo(hasAggregateExprs, hasExplicitGby, SubQueryUtils.buildSQOperator(subQueryOperatorAST));
    }

    public QBSubQueryParseInfo(boolean hasAggregateExprs, boolean hasExplicitGby, QBSubQuery.SubQueryTypeDef operator) {
        this.hasAggregateExprs = hasAggregateExprs;
        this.hasExplicitGby = hasExplicitGby;
        this.operator = operator;
    }

    public boolean hasFullAggregate() {
        return this.hasAggregateExprs && !this.hasExplicitGby;
    }

    public QBSubQuery.SubQueryTypeDef getOperator() {
        return this.operator;
    }

    public QBSubQueryParseInfo setSubQueryRelNode(RelNode subQueryRelNode) {
        this.subQueryRelNode = subQueryRelNode;
        return this;
    }

    public RelNode getSubQueryRelNode() {
        return this.subQueryRelNode;
    }
}

