/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.parse;

import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.ContentSummary;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.PathFilter;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.Context;
import org.apache.hadoop.hive.ql.QueryState;
import org.apache.hadoop.hive.ql.exec.ConditionalTask;
import org.apache.hadoop.hive.ql.exec.FileSinkOperator;
import org.apache.hadoop.hive.ql.exec.MapJoinOperator;
import org.apache.hadoop.hive.ql.exec.Operator;
import org.apache.hadoop.hive.ql.exec.ReduceSinkOperator;
import org.apache.hadoop.hive.ql.exec.TableScanOperator;
import org.apache.hadoop.hive.ql.exec.Task;
import org.apache.hadoop.hive.ql.exec.UnionOperator;
import org.apache.hadoop.hive.ql.exec.Utilities;
import org.apache.hadoop.hive.ql.exec.mr.ExecDriver;
import org.apache.hadoop.hive.ql.exec.mr.MapRedTask;
import org.apache.hadoop.hive.ql.hooks.ReadEntity;
import org.apache.hadoop.hive.ql.hooks.WriteEntity;
import org.apache.hadoop.hive.ql.lib.DefaultRuleDispatcher;
import org.apache.hadoop.hive.ql.lib.Node;
import org.apache.hadoop.hive.ql.lib.RuleRegExp;
import org.apache.hadoop.hive.ql.lib.SemanticNodeProcessor;
import org.apache.hadoop.hive.ql.lib.SemanticRule;
import org.apache.hadoop.hive.ql.metadata.Hive;
import org.apache.hadoop.hive.ql.optimizer.GenMRFileSink1;
import org.apache.hadoop.hive.ql.optimizer.GenMROperator;
import org.apache.hadoop.hive.ql.optimizer.GenMRProcContext;
import org.apache.hadoop.hive.ql.optimizer.GenMRRedSink1;
import org.apache.hadoop.hive.ql.optimizer.GenMRRedSink2;
import org.apache.hadoop.hive.ql.optimizer.GenMRRedSink3;
import org.apache.hadoop.hive.ql.optimizer.GenMRTableScan1;
import org.apache.hadoop.hive.ql.optimizer.GenMRUnion1;
import org.apache.hadoop.hive.ql.optimizer.MapJoinFactory;
import org.apache.hadoop.hive.ql.optimizer.physical.PhysicalContext;
import org.apache.hadoop.hive.ql.optimizer.physical.PhysicalOptimizer;
import org.apache.hadoop.hive.ql.parse.GenMapRedWalker;
import org.apache.hadoop.hive.ql.parse.GlobalLimitCtx;
import org.apache.hadoop.hive.ql.parse.ParseContext;
import org.apache.hadoop.hive.ql.parse.SemanticException;
import org.apache.hadoop.hive.ql.parse.TaskCompiler;
import org.apache.hadoop.hive.ql.plan.MapWork;
import org.apache.hadoop.hive.ql.plan.MapredWork;
import org.apache.hadoop.hive.ql.plan.MoveWork;
import org.apache.hadoop.hive.ql.plan.OperatorDesc;
import org.apache.hadoop.hive.ql.session.SessionState;
import org.apache.hadoop.hive.shims.ShimLoader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MapReduceCompiler
extends TaskCompiler {
    protected final Logger LOG = LoggerFactory.getLogger(MapReduceCompiler.class);

    @Override
    public void init(QueryState queryState, SessionState.LogHelper console, Hive db) {
        super.init(queryState, console, db);
        if (this.conf.getBoolVar(HiveConf.ConfVars.HIVE_OPTIMIZE_UNION_REMOVE)) {
            this.conf.setBoolean("mapred.input.dir.recursive", true);
        }
    }

    @Override
    protected void setInputFormat(Task<?> task) {
        if (task instanceof ExecDriver) {
            MapWork work = ((MapredWork)task.getWork()).getMapWork();
            Map<String, Operator<? extends OperatorDesc>> opMap = work.getAliasToWork();
            if (!opMap.isEmpty()) {
                for (Operator op : opMap.values()) {
                    this.setInputFormat(work, op);
                }
            }
        } else if (task instanceof ConditionalTask) {
            List<Task<?>> listTasks = ((ConditionalTask)task).getListTasks();
            for (Task task2 : listTasks) {
                this.setInputFormat(task2);
            }
        }
        if (task.getChildTasks() != null) {
            for (Task<?> childTask : task.getChildTasks()) {
                this.setInputFormat(childTask);
            }
        }
    }

    @Override
    protected void optimizeOperatorPlan(ParseContext pCtx) throws SemanticException {
        this.runDynPartitionSortOptimizations(pCtx, this.conf);
    }

    private void setInputFormat(MapWork work, Operator<? extends OperatorDesc> op) {
        if (op.isUseBucketizedHiveInputFormat()) {
            work.setUseBucketizedHiveInputFormat(true);
            return;
        }
        if (op.getChildOperators() != null) {
            for (Operator<OperatorDesc> childOp : op.getChildOperators()) {
                this.setInputFormat(work, childOp);
            }
        }
    }

    private void breakTaskTree(Task<?> task) {
        if (task instanceof ExecDriver) {
            Map<String, Operator<? extends OperatorDesc>> opMap = ((MapredWork)task.getWork()).getMapWork().getAliasToWork();
            if (!opMap.isEmpty()) {
                for (Operator operator : opMap.values()) {
                    this.breakOperatorTree(operator);
                }
            }
        } else if (task instanceof ConditionalTask) {
            List<Task<?>> listTasks = ((ConditionalTask)task).getListTasks();
            for (Task task2 : listTasks) {
                this.breakTaskTree(task2);
            }
        }
        if (task.getChildTasks() == null) {
            return;
        }
        for (Task<?> childTask : task.getChildTasks()) {
            this.breakTaskTree(childTask);
        }
    }

    private void breakOperatorTree(Operator<? extends OperatorDesc> topOp) {
        if (topOp instanceof ReduceSinkOperator) {
            topOp.setChildOperators(null);
        }
        for (Operator<OperatorDesc> op : topOp.getChildOperators()) {
            this.breakOperatorTree(op);
        }
    }

    private static int getNumberOfReducers(MapredWork mrwork, HiveConf conf) {
        if (mrwork.getReduceWork() == null) {
            return 0;
        }
        if (mrwork.getReduceWork().getNumReduceTasks() >= 0) {
            return mrwork.getReduceWork().getNumReduceTasks();
        }
        return conf.getIntVar(HiveConf.ConfVars.HADOOP_NUM_REDUCERS);
    }

    @Override
    protected void decideExecMode(List<Task<?>> rootTasks, Context ctx, GlobalLimitCtx globalLimitCtx) throws SemanticException {
        if (ctx.isExplainSkipExecution()) {
            return;
        }
        if (ctx.isLocalOnlyExecutionMode() || !this.conf.getBoolVar(HiveConf.ConfVars.LOCAL_MODE_AUTO)) {
            return;
        }
        final Context lCtx = ctx;
        PathFilter p = new PathFilter(){

            public boolean accept(Path file) {
                return !lCtx.isMRTmpFileURI(file.toUri().getPath());
            }
        };
        List<ExecDriver> mrtasks = Utilities.getMRTasks(rootTasks);
        boolean hasNonLocalJob = false;
        for (ExecDriver mrtask : mrtasks) {
            try {
                long estimatedInput;
                ContentSummary inputSummary = Utilities.getInputSummary(ctx, ((MapredWork)mrtask.getWork()).getMapWork(), p);
                int numReducers = MapReduceCompiler.getNumberOfReducers((MapredWork)mrtask.getWork(), this.conf);
                if (globalLimitCtx != null && globalLimitCtx.isEnable()) {
                    long sizePerRow = HiveConf.getLongVar((Configuration)this.conf, (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_LIMIT_MAX_ROW_SIZE);
                    estimatedInput = (long)(globalLimitCtx.getGlobalOffset() + globalLimitCtx.getGlobalLimit()) * sizePerRow;
                    long minSplitSize = HiveConf.getLongVar((Configuration)this.conf, (HiveConf.ConfVars)HiveConf.ConfVars.MAPRED_MIN_SPLIT_SIZE);
                    long estimatedNumMap = inputSummary.getLength() / minSplitSize + 1L;
                    estimatedInput *= estimatedNumMap + 1L;
                } else {
                    estimatedInput = inputSummary.getLength();
                }
                if (this.LOG.isDebugEnabled()) {
                    this.LOG.debug("Task: " + mrtask.getId() + ", Summary: " + inputSummary.getLength() + "," + inputSummary.getFileCount() + "," + numReducers + ", estimated Input: " + estimatedInput);
                }
                if (MapRedTask.isEligibleForLocalMode(this.conf, numReducers, estimatedInput, inputSummary.getFileCount()) != null) {
                    hasNonLocalJob = true;
                    break;
                }
                mrtask.setLocalMode(true);
            }
            catch (IOException e) {
                throw new SemanticException((Throwable)e);
            }
        }
        if (!hasNonLocalJob) {
            ctx.setOriginalTracker(ShimLoader.getHadoopShims().getJobLauncherRpcAddress((Configuration)this.conf));
            ShimLoader.getHadoopShims().setJobLauncherRpcAddress((Configuration)this.conf, "local");
            this.console.printInfo("Automatically selecting local only mode for query");
        }
    }

    @Override
    protected void optimizeTaskPlan(List<Task<?>> rootTasks, ParseContext pCtx, Context ctx) throws SemanticException {
        for (Task<?> rootTask : rootTasks) {
            this.breakTaskTree(rootTask);
        }
        PhysicalContext physicalContext = new PhysicalContext(this.conf, this.getParseContext(pCtx, rootTasks), ctx, rootTasks, pCtx.getFetchTask());
        PhysicalOptimizer physicalOptimizer = new PhysicalOptimizer(physicalContext, this.conf);
        physicalOptimizer.optimize();
    }

    @Override
    protected void generateTaskTree(List<Task<?>> rootTasks, ParseContext pCtx, List<Task<MoveWork>> mvTask, Set<ReadEntity> inputs, Set<WriteEntity> outputs) throws SemanticException {
        ParseContext tempParseContext = this.getParseContext(pCtx, rootTasks);
        GenMRProcContext procCtx = new GenMRProcContext(this.conf, new LinkedHashMap(), tempParseContext, mvTask, rootTasks, new LinkedHashMap<Operator<? extends OperatorDesc>, GenMRProcContext.GenMapRedCtx>(), inputs, outputs);
        LinkedHashMap<SemanticRule, SemanticNodeProcessor> opRules = new LinkedHashMap<SemanticRule, SemanticNodeProcessor>();
        opRules.put(new RuleRegExp(new String("R1"), TableScanOperator.getOperatorName() + "%"), new GenMRTableScan1());
        opRules.put(new RuleRegExp(new String("R2"), TableScanOperator.getOperatorName() + "%.*" + ReduceSinkOperator.getOperatorName() + "%"), new GenMRRedSink1());
        opRules.put(new RuleRegExp(new String("R3"), ReduceSinkOperator.getOperatorName() + "%.*" + ReduceSinkOperator.getOperatorName() + "%"), new GenMRRedSink2());
        opRules.put(new RuleRegExp(new String("R4"), FileSinkOperator.getOperatorName() + "%"), new GenMRFileSink1());
        opRules.put(new RuleRegExp(new String("R5"), UnionOperator.getOperatorName() + "%"), new GenMRUnion1());
        opRules.put(new RuleRegExp(new String("R6"), UnionOperator.getOperatorName() + "%.*" + ReduceSinkOperator.getOperatorName() + "%"), new GenMRRedSink3());
        opRules.put(new RuleRegExp(new String("R7"), MapJoinOperator.getOperatorName() + "%"), MapJoinFactory.getTableScanMapJoin());
        DefaultRuleDispatcher disp = new DefaultRuleDispatcher(new GenMROperator(), opRules, procCtx);
        GenMapRedWalker ogw = new GenMapRedWalker(disp);
        ArrayList<Node> topNodes = new ArrayList<Node>();
        topNodes.addAll(pCtx.getTopOps().values());
        ogw.startWalking(topNodes, null);
    }
}

