/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.parse;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import org.apache.hadoop.hive.ql.exec.Operator;
import org.apache.hadoop.hive.ql.exec.UnionOperator;
import org.apache.hadoop.hive.ql.lib.DefaultGraphWalker;
import org.apache.hadoop.hive.ql.lib.Node;
import org.apache.hadoop.hive.ql.lib.SemanticDispatcher;
import org.apache.hadoop.hive.ql.parse.GenTezProcContext;
import org.apache.hadoop.hive.ql.parse.SemanticException;
import org.apache.hadoop.hive.ql.plan.BaseWork;
import org.apache.hadoop.hive.ql.plan.OperatorDesc;

public class GenTezWorkWalker
extends DefaultGraphWalker {
    private final GenTezProcContext ctx;

    public GenTezWorkWalker(SemanticDispatcher disp, GenTezProcContext ctx) {
        super(disp);
        this.ctx = ctx;
    }

    private void setRoot(Node nd) {
        this.ctx.currentRootOperator = (Operator)nd;
        this.ctx.preceedingWork = null;
        this.ctx.parentOfRoot = null;
        this.ctx.currentUnionOperators = new ArrayList<UnionOperator>();
    }

    @Override
    public void startWalking(Collection<Node> startNodes, HashMap<Node, Object> nodeOutput) throws SemanticException {
        this.toWalk.addAll(startNodes);
        while (this.toWalk.size() > 0) {
            Node nd = (Node)this.toWalk.remove(0);
            this.setRoot(nd);
            this.walk(nd);
            if (nodeOutput == null) continue;
            nodeOutput.put(nd, this.retMap.get(nd));
        }
    }

    @Override
    protected void walk(Node nd) throws SemanticException {
        List children = nd.getChildren();
        this.opStack.push(nd);
        Boolean skip = (Boolean)this.dispatchAndReturn(nd, this.opStack);
        Operator<? extends OperatorDesc> currentRoot = this.ctx.currentRootOperator;
        Operator<? extends OperatorDesc> parentOfRoot = this.ctx.parentOfRoot;
        List<UnionOperator> currentUnionOperators = this.ctx.currentUnionOperators;
        BaseWork preceedingWork = this.ctx.preceedingWork;
        if (skip == null || !skip.booleanValue()) {
            for (Node ch : children) {
                this.ctx.currentRootOperator = currentRoot;
                this.ctx.parentOfRoot = parentOfRoot;
                this.ctx.preceedingWork = preceedingWork;
                this.ctx.currentUnionOperators = new ArrayList<UnionOperator>();
                this.ctx.currentUnionOperators.addAll(currentUnionOperators);
                this.walk(ch);
            }
        }
        this.opStack.pop();
    }
}

