/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.parse;

import java.util.HashMap;
import java.util.Map;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.exec.Utilities;
import org.apache.hadoop.hive.ql.metadata.Table;
import org.apache.hadoop.hive.ql.parse.ASTNode;
import org.apache.hadoop.hive.ql.parse.BaseSemanticAnalyzer;
import org.apache.hadoop.hive.ql.parse.ColumnStatsSemanticAnalyzer;
import org.apache.hadoop.hive.ql.parse.SemanticException;
import org.apache.hadoop.hive.ql.session.SessionState;

public final class AnalyzeCommandUtils {
    private AnalyzeCommandUtils() {
        throw new UnsupportedOperationException("AnalyzeCommandUtils should not be instantiated");
    }

    public static boolean isPartitionLevelStats(ASTNode tree) {
        boolean isPartitioned = false;
        ASTNode child = (ASTNode)tree.getChild(0);
        if (child.getChildCount() > 1 && (child = (ASTNode)child.getChild(1)).getToken().getType() == 1132) {
            isPartitioned = true;
        }
        return isPartitioned;
    }

    public static Table getTable(ASTNode tree, BaseSemanticAnalyzer sa) throws SemanticException {
        String tableName = ColumnStatsSemanticAnalyzer.getUnescapedName((ASTNode)tree.getChild(0).getChild(0));
        String currentDb = SessionState.get().getCurrentDatabase();
        String[] names = Utilities.getDbTableName(currentDb, tableName);
        return sa.getTable(names[0], names[1], true);
    }

    public static Map<String, String> getPartKeyValuePairsFromAST(Table tbl, ASTNode tree, HiveConf hiveConf) throws SemanticException {
        ASTNode child = (ASTNode)tree.getChild(0).getChild(1);
        Map<String, String> partSpec = new HashMap<String, String>();
        if (child != null) {
            partSpec = BaseSemanticAnalyzer.getValidatedPartSpec(tbl, child, hiveConf, false);
        }
        return partSpec;
    }
}

