/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.optimizer.physical;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import org.apache.hadoop.hive.ql.exec.FileSinkOperator;
import org.apache.hadoop.hive.ql.exec.FilterOperator;
import org.apache.hadoop.hive.ql.exec.ForwardOperator;
import org.apache.hadoop.hive.ql.exec.GroupByOperator;
import org.apache.hadoop.hive.ql.exec.JoinOperator;
import org.apache.hadoop.hive.ql.exec.LateralViewForwardOperator;
import org.apache.hadoop.hive.ql.exec.LateralViewJoinOperator;
import org.apache.hadoop.hive.ql.exec.LimitOperator;
import org.apache.hadoop.hive.ql.exec.Operator;
import org.apache.hadoop.hive.ql.exec.SelectOperator;
import org.apache.hadoop.hive.ql.exec.Utilities;
import org.apache.hadoop.hive.ql.exec.mr.ExecDriver;
import org.apache.hadoop.hive.ql.lib.DefaultRuleDispatcher;
import org.apache.hadoop.hive.ql.lib.Node;
import org.apache.hadoop.hive.ql.lib.PreOrderWalker;
import org.apache.hadoop.hive.ql.lib.RuleExactMatch;
import org.apache.hadoop.hive.ql.lib.RuleRegExp;
import org.apache.hadoop.hive.ql.lib.SemanticNodeProcessor;
import org.apache.hadoop.hive.ql.lib.SemanticRule;
import org.apache.hadoop.hive.ql.optimizer.physical.BucketingSortingCtx;
import org.apache.hadoop.hive.ql.optimizer.physical.BucketingSortingOpProcFactory;
import org.apache.hadoop.hive.ql.optimizer.physical.PhysicalContext;
import org.apache.hadoop.hive.ql.optimizer.physical.PhysicalPlanResolver;
import org.apache.hadoop.hive.ql.parse.SemanticException;
import org.apache.hadoop.hive.ql.plan.MapredWork;

public class BucketingSortingInferenceOptimizer
implements PhysicalPlanResolver {
    @Override
    public PhysicalContext resolve(PhysicalContext pctx) throws SemanticException {
        this.inferBucketingSorting(Utilities.getMRTasks(pctx.rootTasks));
        return pctx;
    }

    private void inferBucketingSorting(List<ExecDriver> mapRedTasks) throws SemanticException {
        for (ExecDriver mapRedTask : mapRedTasks) {
            if (!((MapredWork)mapRedTask.getWork()).isFinalMapRed() || ((MapredWork)mapRedTask.getWork()).getReduceWork() == null) continue;
            Operator<?> reducer = ((MapredWork)mapRedTask.getWork()).getReduceWork().getReducer();
            boolean disableBucketing = ((MapredWork)mapRedTask.getWork()).getMapWork().getSamplingType() > 0;
            BucketingSortingCtx bCtx = new BucketingSortingCtx(disableBucketing);
            LinkedHashMap<SemanticRule, SemanticNodeProcessor> opRules = new LinkedHashMap<SemanticRule, SemanticNodeProcessor>();
            opRules.put(new RuleRegExp("R1", SelectOperator.getOperatorName() + "%"), BucketingSortingOpProcFactory.getSelProc());
            opRules.put(new RuleExactMatch("R2", new String[]{GroupByOperator.getOperatorName()}), BucketingSortingOpProcFactory.getGroupByProc());
            opRules.put(new RuleExactMatch("R3", new String[]{JoinOperator.getOperatorName()}), BucketingSortingOpProcFactory.getJoinProc());
            opRules.put(new RuleRegExp("R5", FileSinkOperator.getOperatorName() + "%"), BucketingSortingOpProcFactory.getFileSinkProc());
            opRules.put(new RuleRegExp("R7", FilterOperator.getOperatorName() + "%"), BucketingSortingOpProcFactory.getFilterProc());
            opRules.put(new RuleRegExp("R8", LimitOperator.getOperatorName() + "%"), BucketingSortingOpProcFactory.getLimitProc());
            opRules.put(new RuleRegExp("R9", LateralViewForwardOperator.getOperatorName() + "%"), BucketingSortingOpProcFactory.getLateralViewForwardProc());
            opRules.put(new RuleRegExp("R10", LateralViewJoinOperator.getOperatorName() + "%"), BucketingSortingOpProcFactory.getLateralViewJoinProc());
            opRules.put(new RuleRegExp("R11", ".+" + ForwardOperator.getOperatorName() + "%"), BucketingSortingOpProcFactory.getForwardProc());
            opRules.put(new RuleExactMatch("R12", new String[]{ForwardOperator.getOperatorName(), GroupByOperator.getOperatorName()}), BucketingSortingOpProcFactory.getMultiGroupByProc());
            DefaultRuleDispatcher disp = new DefaultRuleDispatcher(BucketingSortingOpProcFactory.getDefaultProc(), opRules, bCtx);
            PreOrderWalker ogw = new PreOrderWalker(disp);
            ArrayList<Node> topNodes = new ArrayList<Node>();
            topNodes.add(reducer);
            ogw.startWalking(topNodes, null);
            ((MapredWork)mapRedTask.getWork()).getMapWork().getBucketedColsByDirectory().putAll(bCtx.getBucketedColsByDirectory());
            ((MapredWork)mapRedTask.getWork()).getMapWork().getSortedColsByDirectory().putAll(bCtx.getSortedColsByDirectory());
        }
    }
}

