/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.optimizer.metainfo.annotation;

import com.google.common.base.Preconditions;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Multimap;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Stack;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.api.Order;
import org.apache.hadoop.hive.ql.exec.GroupByOperator;
import org.apache.hadoop.hive.ql.exec.JoinOperator;
import org.apache.hadoop.hive.ql.exec.Operator;
import org.apache.hadoop.hive.ql.exec.PTFOperator;
import org.apache.hadoop.hive.ql.exec.ReduceSinkOperator;
import org.apache.hadoop.hive.ql.exec.SelectOperator;
import org.apache.hadoop.hive.ql.exec.TableScanOperator;
import org.apache.hadoop.hive.ql.lib.Node;
import org.apache.hadoop.hive.ql.lib.NodeProcessorCtx;
import org.apache.hadoop.hive.ql.lib.SemanticNodeProcessor;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.metadata.Partition;
import org.apache.hadoop.hive.ql.metadata.Table;
import org.apache.hadoop.hive.ql.optimizer.AbstractBucketJoinProc;
import org.apache.hadoop.hive.ql.optimizer.metainfo.annotation.AnnotateOpTraitsProcCtx;
import org.apache.hadoop.hive.ql.parse.ParseContext;
import org.apache.hadoop.hive.ql.parse.PrunedPartitionList;
import org.apache.hadoop.hive.ql.parse.SemanticException;
import org.apache.hadoop.hive.ql.plan.CustomBucketFunction;
import org.apache.hadoop.hive.ql.plan.ExprNodeColumnDesc;
import org.apache.hadoop.hive.ql.plan.ExprNodeDesc;
import org.apache.hadoop.hive.ql.plan.ExprNodeDescUtils;
import org.apache.hadoop.hive.ql.plan.GroupByDesc;
import org.apache.hadoop.hive.ql.plan.JoinDesc;
import org.apache.hadoop.hive.ql.plan.OpTraits;
import org.apache.hadoop.hive.ql.plan.OperatorDesc;
import org.apache.hadoop.hive.ql.plan.PTFDesc;
import org.apache.hadoop.hive.ql.plan.PartitionAwareOptimizationCtx;
import org.apache.hadoop.hive.ql.plan.ReduceSinkDesc;
import org.apache.hadoop.hive.ql.plan.TableScanDesc;
import org.apache.hadoop.hive.ql.plan.ptf.PTFExpressionDef;
import org.apache.hadoop.hive.ql.plan.ptf.PartitionDef;

public class OpTraitsRulesProcFactory {
    public static SemanticNodeProcessor getTableScanRule() {
        return new TableScanRule();
    }

    public static SemanticNodeProcessor getReduceSinkRule() {
        return new ReduceSinkRule();
    }

    public static SemanticNodeProcessor getSelectRule() {
        return new SelectRule();
    }

    public static SemanticNodeProcessor getDefaultRule() {
        return new DefaultRule();
    }

    public static SemanticNodeProcessor getMultiParentRule() {
        return new MultiParentRule();
    }

    public static SemanticNodeProcessor getGroupByRule() {
        return new GroupByRule();
    }

    public static SemanticNodeProcessor getPTFRule() {
        return new PTFRule();
    }

    public static SemanticNodeProcessor getJoinRule() {
        return new JoinRule();
    }

    public static class TableScanRule
    implements SemanticNodeProcessor {
        public boolean checkBucketedTable(Table tbl, ParseContext pGraphContext, PrunedPartitionList prunedParts) throws SemanticException {
            int numBuckets = tbl.getNumBuckets();
            if (numBuckets <= 0) {
                return false;
            }
            if (!HiveConf.getVar((Configuration)pGraphContext.getConf(), (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_EXECUTION_ENGINE).equals("tez")) {
                if (tbl.isPartitioned()) {
                    List<Partition> partitions = prunedParts.getNotDeniedPartns();
                    if (!partitions.isEmpty()) {
                        for (Partition p : partitions) {
                            List<String> fileNames = AbstractBucketJoinProc.getBucketFilePathsOfPartition(p.getDataLocation(), pGraphContext);
                            if (fileNames.size() == 0 || fileNames.size() == numBuckets) continue;
                            return false;
                        }
                    }
                } else {
                    List<String> fileNames = AbstractBucketJoinProc.getBucketFilePathsOfPartition(tbl.getDataLocation(), pGraphContext);
                    if (fileNames.size() != 0 && fileNames.size() != numBuckets) {
                        return false;
                    }
                }
            }
            return true;
        }

        @Override
        public Object process(Node nd, Stack<Node> stack, NodeProcessorCtx procCtx, Object ... nodeOutputs) throws SemanticException {
            TableScanOperator ts = (TableScanOperator)nd;
            AnnotateOpTraitsProcCtx opTraitsCtx = (AnnotateOpTraitsProcCtx)procCtx;
            Table table = ((TableScanDesc)ts.getConf()).getTableMetadata();
            PrunedPartitionList prunedPartList = null;
            try {
                prunedPartList = opTraitsCtx.getParseContext().getPrunedPartitions(((TableScanDesc)ts.getConf()).getAlias(), ts);
            }
            catch (HiveException e) {
                prunedPartList = null;
            }
            ArrayList<List<String>> bucketColsList = new ArrayList<List<String>>();
            ArrayList<List<String>> sortedColsList = new ArrayList<List<String>>();
            ArrayList<CustomBucketFunction> bucketFunctions = new ArrayList<CustomBucketFunction>();
            int numBuckets = -1;
            if (table.getStorageHandler() != null && table.getStorageHandler().supportsPartitionAwareOptimization(table) && HiveConf.getVar((Configuration)opTraitsCtx.getConf(), (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_EXECUTION_ENGINE).equals("tez")) {
                PartitionAwareOptimizationCtx ctx = table.getStorageHandler().createPartitionAwareOptimizationContext(table);
                bucketColsList.add(ctx.getBucketFunction().getSourceColumnNames());
                bucketFunctions.add(ctx.getBucketFunction());
            } else if (this.checkBucketedTable(table, opTraitsCtx.getParseContext(), prunedPartList)) {
                bucketColsList.add(table.getBucketCols());
                numBuckets = table.getNumBuckets();
                ArrayList<String> sortCols = new ArrayList<String>();
                for (Order colSortOrder : table.getSortCols()) {
                    sortCols.add(colSortOrder.getCol());
                }
                sortedColsList.add(sortCols);
                bucketFunctions.add(null);
            }
            OpTraits opTraits = new OpTraits(bucketColsList, bucketFunctions, numBuckets, sortedColsList, 0);
            ts.setOpTraits(opTraits);
            return null;
        }
    }

    public static class ReduceSinkRule
    implements SemanticNodeProcessor {
        @Override
        public Object process(Node nd, Stack<Node> stack, NodeProcessorCtx procCtx, Object ... nodeOutputs) throws SemanticException {
            ReduceSinkOperator rs = (ReduceSinkOperator)nd;
            int numReduceSinks = 1;
            OpTraits parentOpTraits = rs.getParentOperators().get(0).getOpTraits();
            if (parentOpTraits != null) {
                numReduceSinks += parentOpTraits.getNumReduceSinks();
            }
            ArrayList<String> bucketCols = new ArrayList<String>();
            if (parentOpTraits != null && parentOpTraits.getBucketColNames() != null) {
                if (parentOpTraits.getBucketColNames().size() > 0) {
                    for (List list : parentOpTraits.getBucketColNames()) {
                        block1: for (String string : list) {
                            for (Map.Entry<String, ExprNodeDesc> entry2 : rs.getColumnExprMap().entrySet()) {
                                boolean isKey = false;
                                for (ExprNodeDesc keyDesc : ((ReduceSinkDesc)rs.getConf()).getKeyCols()) {
                                    if (!keyDesc.isSame(entry2.getValue())) continue;
                                    isKey = true;
                                    break;
                                }
                                if (!isKey) continue;
                                ArrayListMultimap colMap = ArrayListMultimap.create();
                                boolean found = false;
                                ExprNodeDescUtils.getExprNodeColumnDesc(entry2.getValue(), (Multimap<Integer, ExprNodeColumnDesc>)colMap);
                                for (Integer hashCode : colMap.keySet()) {
                                    Collection exprs = colMap.get((Object)hashCode);
                                    for (ExprNodeColumnDesc expr : exprs) {
                                        if (!expr.getColumn().equals(string)) continue;
                                        bucketCols.add(entry2.getKey());
                                        found = true;
                                        break;
                                    }
                                    if (!found) continue;
                                    break;
                                }
                                if (!found) continue;
                                continue block1;
                            }
                        }
                    }
                } else {
                    for (ExprNodeDesc exprNodeDesc : ((ReduceSinkDesc)rs.getConf()).getKeyCols()) {
                        for (Map.Entry entry2 : rs.getColumnExprMap().entrySet()) {
                            if (!exprNodeDesc.isSame(entry2.getValue())) continue;
                            bucketCols.add((String)entry2.getKey());
                        }
                    }
                }
            }
            ArrayList<List<String>> listBucketCols = new ArrayList<List<String>>();
            ArrayList<CustomBucketFunction> arrayList = new ArrayList<CustomBucketFunction>();
            int numBuckets = -1;
            if (parentOpTraits == null || !parentOpTraits.hasCustomBucketFunction()) {
                listBucketCols.add(bucketCols);
                arrayList.add(null);
                if (parentOpTraits != null) {
                    numBuckets = parentOpTraits.getNumBuckets();
                }
            } else if (parentOpTraits.getCustomBucketFunctions().size() > 1) {
                Preconditions.checkState((parentOpTraits.getBucketColNames().size() > 1 ? 1 : 0) != 0);
                listBucketCols.add(Collections.emptyList());
                arrayList.add(null);
            } else {
                Preconditions.checkState((parentOpTraits.getBucketColNames().size() == 1 ? 1 : 0) != 0);
                Map<String, String> map = rs.getColumnExprMap().entrySet().stream().filter(entry -> entry.getValue() instanceof ExprNodeColumnDesc).filter(entry -> ((ReduceSinkDesc)rs.getConf()).getKeyCols().stream().anyMatch(keyDesc -> keyDesc.isSame(entry.getValue()))).collect(Collectors.toMap(entry -> ((ExprNodeColumnDesc)entry.getValue()).getColumn(), Map.Entry::getKey, (a, b) -> a));
                List<String> parentBucketColNames = parentOpTraits.getBucketColNames().get(0);
                boolean[] retainedColumns = new boolean[parentBucketColNames.size()];
                ArrayList<String> rsBucketColNames = new ArrayList<String>();
                for (int i = 0; i < parentBucketColNames.size(); ++i) {
                    String rsColumnName = map.get(parentBucketColNames.get(i));
                    if (rsColumnName == null) continue;
                    retainedColumns[i] = true;
                    rsBucketColNames.add(rsColumnName);
                }
                Optional<CustomBucketFunction> rsBucketFunction = parentOpTraits.getCustomBucketFunctions().get(0).select(retainedColumns);
                if (rsBucketFunction.isPresent()) {
                    listBucketCols.add(rsBucketColNames);
                    arrayList.add(rsBucketFunction.get());
                } else {
                    listBucketCols.add(Collections.emptyList());
                    arrayList.add(null);
                }
            }
            OpTraits opTraits = new OpTraits(listBucketCols, arrayList, numBuckets, listBucketCols, numReduceSinks);
            rs.setOpTraits(opTraits);
            return null;
        }
    }

    public static class SelectRule
    implements SemanticNodeProcessor {
        public List<List<String>> getConvertedColNames(List<List<String>> parentColNames, SelectOperator selOp, boolean processSortCols) {
            ArrayList<List<String>> listBucketCols = new ArrayList<List<String>>();
            for (List<String> colNames : parentColNames) {
                ArrayList<String> bucketColNames = new ArrayList<String>();
                boolean found = false;
                for (String colName : colNames) {
                    found = false;
                    for (Map.Entry<String, ExprNodeDesc> entry : selOp.getColumnExprMap().entrySet()) {
                        if (!(entry.getValue() instanceof ExprNodeColumnDesc) || !((ExprNodeColumnDesc)entry.getValue()).getColumn().equals(colName)) continue;
                        bucketColNames.add(entry.getKey());
                        found = true;
                        break;
                    }
                    if (found) continue;
                    break;
                }
                if (!processSortCols && !found) {
                    listBucketCols.add(new ArrayList());
                    continue;
                }
                listBucketCols.add(bucketColNames);
            }
            return listBucketCols;
        }

        @Override
        public Object process(Node nd, Stack<Node> stack, NodeProcessorCtx procCtx, Object ... nodeOutputs) throws SemanticException {
            SelectOperator selOp = (SelectOperator)nd;
            OpTraits parentOpTraits = selOp.getParentOperators().get(0).getOpTraits();
            List<List<String>> parentBucketColNames = parentOpTraits.getBucketColNames();
            List<List<String>> listBucketCols = null;
            List<List<String>> listSortCols = null;
            if (selOp.getColumnExprMap() != null) {
                List<List<String>> parentSortColNames;
                if (parentBucketColNames != null) {
                    listBucketCols = this.getConvertedColNames(parentBucketColNames, selOp, false);
                }
                if ((parentSortColNames = parentOpTraits.getSortCols()) != null) {
                    listSortCols = this.getConvertedColNames(parentSortColNames, selOp, true);
                }
            }
            ArrayList<CustomBucketFunction> bucketFunctions = null;
            if (listBucketCols != null) {
                Preconditions.checkState((parentBucketColNames.size() == listBucketCols.size() ? 1 : 0) != 0);
                bucketFunctions = new ArrayList<CustomBucketFunction>();
                for (int i = 0; i < listBucketCols.size(); ++i) {
                    if (listBucketCols.get(i).isEmpty()) {
                        bucketFunctions.add(null);
                        continue;
                    }
                    Preconditions.checkState((listBucketCols.get(i).size() == parentBucketColNames.get(i).size() ? 1 : 0) != 0);
                    bucketFunctions.add(parentOpTraits.getCustomBucketFunctions().get(i));
                }
            }
            int numBuckets = -1;
            if (CollectionUtils.isNotEmpty(listBucketCols) && CollectionUtils.isNotEmpty((Collection)listBucketCols.get(0)) && bucketFunctions.get(0) == null) {
                numBuckets = parentOpTraits.getNumBuckets();
            }
            int numReduceSinks = parentOpTraits.getNumReduceSinks();
            OpTraits opTraits = new OpTraits(listBucketCols, bucketFunctions, numBuckets, listSortCols, numReduceSinks);
            selOp.setOpTraits(opTraits);
            return null;
        }
    }

    public static class DefaultRule
    implements SemanticNodeProcessor {
        @Override
        public Object process(Node nd, Stack<Node> stack, NodeProcessorCtx procCtx, Object ... nodeOutputs) throws SemanticException {
            Operator op = (Operator)nd;
            op.setOpTraits(op.getParentOperators().get(0).getOpTraits());
            return null;
        }
    }

    public static class MultiParentRule
    implements SemanticNodeProcessor {
        @Override
        public Object process(Node nd, Stack<Node> stack, NodeProcessorCtx procCtx, Object ... nodeOutputs) throws SemanticException {
            Operator operator = (Operator)nd;
            int numReduceSinks = 0;
            for (Operator<OperatorDesc> parentOp : operator.getParentOperators()) {
                if (parentOp.getOpTraits() == null || parentOp.getOpTraits().getNumReduceSinks() <= numReduceSinks) continue;
                numReduceSinks = parentOp.getOpTraits().getNumReduceSinks();
            }
            OpTraits opTraits = new OpTraits(null, null, -1, null, numReduceSinks);
            operator.setOpTraits(opTraits);
            return null;
        }
    }

    public static class GroupByRule
    implements SemanticNodeProcessor {
        @Override
        public Object process(Node nd, Stack<Node> stack, NodeProcessorCtx procCtx, Object ... nodeOutputs) throws SemanticException {
            GroupByOperator gbyOp = (GroupByOperator)nd;
            ArrayList<String> gbyKeys = new ArrayList<String>();
            for (ExprNodeDesc exprDesc : ((GroupByDesc)gbyOp.getConf()).getKeys()) {
                for (Map.Entry<String, ExprNodeDesc> entry : gbyOp.getColumnExprMap().entrySet()) {
                    if (!exprDesc.isSame(entry.getValue())) continue;
                    gbyKeys.add(entry.getKey());
                }
            }
            ArrayList<List<String>> listBucketCols = new ArrayList<List<String>>();
            int numReduceSinks = 0;
            OpTraits parentOpTraits = gbyOp.getParentOperators().get(0).getOpTraits();
            if (parentOpTraits != null) {
                numReduceSinks = parentOpTraits.getNumReduceSinks();
            }
            listBucketCols.add(gbyKeys);
            List<Object> bucketFunctions = Collections.singletonList(null);
            OpTraits opTraits = new OpTraits(listBucketCols, bucketFunctions, -1, listBucketCols, numReduceSinks);
            gbyOp.setOpTraits(opTraits);
            return null;
        }
    }

    public static class PTFRule
    implements SemanticNodeProcessor {
        @Override
        public Object process(Node nd, Stack<Node> stack, NodeProcessorCtx procCtx, Object ... nodeOutputs) throws SemanticException {
            PTFOperator ptfOp = (PTFOperator)nd;
            ArrayList<String> partitionKeys = new ArrayList<String>();
            PartitionDef partition = ((PTFDesc)ptfOp.getConf()).getFuncDef().getPartition();
            if (partition != null && partition.getExpressions() != null) {
                for (PTFExpressionDef expression : partition.getExpressions()) {
                    ExprNodeDesc exprNode = expression.getExprNode();
                    if (!(exprNode instanceof ExprNodeColumnDesc)) {
                        partitionKeys.clear();
                        break;
                    }
                    partitionKeys.add(exprNode.getExprString());
                }
            }
            ArrayList<List<String>> listBucketCols = new ArrayList<List<String>>();
            int numReduceSinks = 0;
            OpTraits parentOptraits = ptfOp.getParentOperators().get(0).getOpTraits();
            if (parentOptraits != null) {
                numReduceSinks = parentOptraits.getNumReduceSinks();
            }
            listBucketCols.add(partitionKeys);
            List<Object> bucketFunctions = Collections.singletonList(null);
            OpTraits opTraits = new OpTraits(listBucketCols, bucketFunctions, -1, listBucketCols, numReduceSinks);
            ptfOp.setOpTraits(opTraits);
            return null;
        }
    }

    public static class JoinRule
    implements SemanticNodeProcessor {
        @Override
        public Object process(Node nd, Stack<Node> stack, NodeProcessorCtx procCtx, Object ... nodeOutputs) throws SemanticException {
            JoinOperator joinOp = (JoinOperator)nd;
            ArrayList<List<String>> bucketColsList = new ArrayList<List<String>>();
            ArrayList<CustomBucketFunction> bucketFunctions = new ArrayList<CustomBucketFunction>();
            ArrayList<List<String>> sortColsList = new ArrayList<List<String>>();
            byte pos = 0;
            int numReduceSinks = 0;
            for (Operator<OperatorDesc> parentOp : joinOp.getParentOperators()) {
                OpTraits parentOpTraits;
                Map.Entry<List<String>, boolean[]> outputColNames;
                if (!(parentOp instanceof ReduceSinkOperator)) break;
                ReduceSinkOperator rsOp = (ReduceSinkOperator)parentOp;
                if (rsOp.getOpTraits() == null) {
                    ReduceSinkRule rsRule = new ReduceSinkRule();
                    rsRule.process(rsOp, stack, procCtx, nodeOutputs);
                }
                if ((outputColNames = this.getOutputColNames(joinOp, (parentOpTraits = rsOp.getOpTraits()).getBucketColNames(), pos)) == null || outputColNames.getKey().isEmpty() || !parentOpTraits.hasCustomBucketFunction()) {
                    bucketColsList.add(outputColNames == null ? null : outputColNames.getKey());
                    bucketFunctions.add(null);
                } else {
                    Preconditions.checkState((parentOpTraits.getBucketColNames().size() == 1 ? 1 : 0) != 0);
                    Optional<CustomBucketFunction> joinBucketFunction = parentOpTraits.getCustomBucketFunctions().get(0).select(outputColNames.getValue());
                    if (joinBucketFunction.isPresent()) {
                        bucketColsList.add(outputColNames.getKey());
                        bucketFunctions.add(joinBucketFunction.get());
                    } else {
                        bucketColsList.add(Collections.emptyList());
                        bucketFunctions.add(null);
                    }
                }
                Map.Entry<List<String>, boolean[]> outputSortColNames = this.getOutputColNames(joinOp, parentOpTraits.getSortCols(), pos);
                sortColsList.add(outputSortColNames == null ? null : outputSortColNames.getKey());
                if (parentOpTraits.getNumReduceSinks() > numReduceSinks) {
                    numReduceSinks = parentOpTraits.getNumReduceSinks();
                }
                pos = (byte)(pos + 1);
            }
            joinOp.setOpTraits(new OpTraits(bucketColsList, bucketFunctions, -1, bucketColsList, numReduceSinks));
            return null;
        }

        private Map.Entry<List<String>, boolean[]> getOutputColNames(JoinOperator joinOp, List<List<String>> parentColNames, byte pos) {
            if (parentColNames == null) {
                return null;
            }
            ArrayList<String> bucketColNames = new ArrayList<String>();
            List<Object> colNames = parentColNames.size() > 0 ? parentColNames.get(0) : new ArrayList();
            boolean[] retainedColumns = new boolean[colNames.size()];
            block0: for (int i = 0; i < colNames.size(); ++i) {
                String colName = (String)colNames.get(i);
                for (ExprNodeDesc exprNode : ((JoinDesc)joinOp.getConf()).getExprs().get(pos)) {
                    if (!(exprNode instanceof ExprNodeColumnDesc) || !((ExprNodeColumnDesc)exprNode).getColumn().equals(colName)) continue;
                    for (Map.Entry<String, ExprNodeDesc> entry : joinOp.getColumnExprMap().entrySet()) {
                        if (!entry.getValue().isSame(exprNode)) continue;
                        bucketColNames.add(entry.getKey());
                        retainedColumns[i] = true;
                        continue block0;
                    }
                }
            }
            return new AbstractMap.SimpleImmutableEntry<List<String>, boolean[]>(bucketColNames, retainedColumns);
        }
    }
}

