/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.optimizer.calcite.stats;

import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Multimap;
import java.lang.reflect.Method;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.calcite.linq4j.Linq4j;
import org.apache.calcite.rel.SingleRel;
import org.apache.calcite.rel.core.Project;
import org.apache.calcite.rel.metadata.BuiltInMetadata;
import org.apache.calcite.rel.metadata.MetadataDef;
import org.apache.calcite.rel.metadata.MetadataHandler;
import org.apache.calcite.rel.metadata.ReflectiveRelMetadataProvider;
import org.apache.calcite.rel.metadata.RelMetadataProvider;
import org.apache.calcite.rel.metadata.RelMetadataQuery;
import org.apache.calcite.rex.RexInputRef;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.util.BuiltInMethod;
import org.apache.calcite.util.ImmutableBitSet;
import org.apache.calcite.util.Util;
import org.apache.hadoop.hive.ql.optimizer.calcite.RelOptHiveTable;
import org.apache.hadoop.hive.ql.optimizer.calcite.reloperators.HiveTableScan;

public class HiveRelMdUniqueKeys
implements MetadataHandler<BuiltInMetadata.UniqueKeys> {
    public static final RelMetadataProvider SOURCE = ReflectiveRelMetadataProvider.reflectiveSource((Method)BuiltInMethod.UNIQUE_KEYS.method, (MetadataHandler)new HiveRelMdUniqueKeys());
    private final int limit;

    private HiveRelMdUniqueKeys() {
        this.limit = 1000;
    }

    public MetadataDef<BuiltInMetadata.UniqueKeys> getDef() {
        return BuiltInMetadata.UniqueKeys.DEF;
    }

    public Set<ImmutableBitSet> getUniqueKeys(Project rel, RelMetadataQuery mq, boolean ignoreNulls) {
        return this.getProjectUniqueKeys((SingleRel)rel, mq, ignoreNulls, rel.getProjects());
    }

    private Set<ImmutableBitSet> getProjectUniqueKeys(SingleRel rel, RelMetadataQuery mq, boolean ignoreNulls, List<RexNode> projExprs) {
        ImmutableMultimap.Builder inToOutPosBuilder = ImmutableMultimap.builder();
        ImmutableBitSet.Builder mappedInColumnsBuilder = ImmutableBitSet.builder();
        for (int i = 0; i < projExprs.size(); ++i) {
            RexNode projExpr = projExprs.get(i);
            if (!(projExpr instanceof RexInputRef)) continue;
            int inputIndex = ((RexInputRef)projExpr).getIndex();
            inToOutPosBuilder.put((Object)inputIndex, (Object)i);
            mappedInColumnsBuilder.set(inputIndex);
        }
        ImmutableBitSet inColumnsUsed = mappedInColumnsBuilder.build();
        if (inColumnsUsed.isEmpty()) {
            return ImmutableSet.of();
        }
        Set childUniqueKeySet = mq.getUniqueKeys(rel.getInput(), ignoreNulls);
        if (childUniqueKeySet == null) {
            return ImmutableSet.of();
        }
        ImmutableMultimap mapInToOutPos = inToOutPosBuilder.build();
        HashSet<ImmutableBitSet> resultBuilder = new HashSet<ImmutableBitSet>();
        block1: for (ImmutableBitSet colMask : childUniqueKeySet) {
            if (!inColumnsUsed.contains(colMask)) continue;
            Iterable product = Linq4j.product((Iterable)Util.transform((List)colMask.toList(), arg_0 -> ((Multimap)mapInToOutPos).get(arg_0)));
            for (List passKey : product) {
                if (resultBuilder.size() == this.limit) break block1;
                resultBuilder.add(ImmutableBitSet.of((Iterable)passKey));
            }
        }
        return resultBuilder;
    }

    public Set<ImmutableBitSet> getUniqueKeys(HiveTableScan rel, RelMetadataQuery mq, boolean ignoreNulls) {
        RelOptHiveTable tbl = (RelOptHiveTable)rel.getTable();
        List<ImmutableBitSet> keyList = tbl.getNonNullableKeys();
        if (keyList != null) {
            HashSet<ImmutableBitSet> keySet = new HashSet<ImmutableBitSet>(keyList);
            return keySet;
        }
        return null;
    }
}

