/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.optimizer.calcite.rules;

import java.util.Collections;
import java.util.List;
import org.apache.calcite.adapter.druid.DruidQuery;
import org.apache.calcite.plan.RelOptRule;
import org.apache.calcite.plan.RelOptRuleCall;
import org.apache.calcite.plan.RelOptRuleOperand;
import org.apache.calcite.plan.RelOptRuleOperandChildren;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.core.Filter;
import org.apache.calcite.rel.core.Project;
import org.apache.calcite.rel.core.RelFactories;
import org.apache.calcite.rel.core.TableScan;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.rex.RexCall;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.rex.RexOver;
import org.apache.calcite.rex.RexUtil;
import org.apache.hadoop.hive.ql.optimizer.calcite.HiveRelFactories;
import org.apache.hadoop.hive.ql.optimizer.calcite.HiveRelOptUtil;
import org.apache.hadoop.hive.ql.optimizer.calcite.reloperators.HiveProject;

public class HiveFilterProjectTSTransposeRule
extends RelOptRule {
    public static final HiveFilterProjectTSTransposeRule INSTANCE = new HiveFilterProjectTSTransposeRule(Filter.class, HiveRelFactories.HIVE_FILTER_FACTORY, HiveProject.class, HiveRelFactories.HIVE_PROJECT_FACTORY, TableScan.class, 100);
    public static final HiveFilterProjectTSTransposeRule INSTANCE_DRUID = new HiveFilterProjectTSTransposeRule(Filter.class, HiveRelFactories.HIVE_FILTER_FACTORY, HiveProject.class, HiveRelFactories.HIVE_PROJECT_FACTORY, DruidQuery.class, 100);
    private final RelFactories.FilterFactory filterFactory;
    private final RelFactories.ProjectFactory projectFactory;
    private final int bloat;

    private HiveFilterProjectTSTransposeRule(Class<? extends Filter> filterClass, RelFactories.FilterFactory filterFactory, Class<? extends Project> projectClass, RelFactories.ProjectFactory projectFactory, Class<? extends RelNode> tsClass, int bloat) {
        super(HiveFilterProjectTSTransposeRule.operand(filterClass, (RelOptRuleOperand)HiveFilterProjectTSTransposeRule.operand(projectClass, (RelOptRuleOperand)HiveFilterProjectTSTransposeRule.operand(tsClass, (RelOptRuleOperandChildren)HiveFilterProjectTSTransposeRule.none()), (RelOptRuleOperand[])new RelOptRuleOperand[0]), (RelOptRuleOperand[])new RelOptRuleOperand[0]));
        this.filterFactory = filterFactory;
        this.projectFactory = projectFactory;
        this.bloat = bloat;
    }

    public boolean matches(RelOptRuleCall call) {
        HiveProject projRel = (HiveProject)call.rel(1);
        if (!projRel.isSynthetic()) {
            return false;
        }
        return super.matches(call);
    }

    public void onMatch(RelOptRuleCall call) {
        Filter filter = (Filter)call.rel(0);
        Project project = (Project)call.rel(1);
        if (RexOver.containsOver((List)project.getProjects(), null)) {
            return;
        }
        if (RexUtil.containsCorrelation((RexNode)filter.getCondition())) {
            return;
        }
        RexNode newCondition = HiveRelOptUtil.pushPastProjectUnlessBloat(filter.getCondition(), project, this.bloat);
        if (newCondition == null) {
            return;
        }
        RelDataTypeFactory typeFactory = filter.getCluster().getTypeFactory();
        if (RexUtil.isNullabilityCast((RelDataTypeFactory)typeFactory, (RexNode)newCondition)) {
            newCondition = (RexNode)((RexCall)newCondition).getOperands().get(0);
        }
        RelNode newFilterRel = this.filterFactory == null ? filter.copy(filter.getTraitSet(), project.getInput(), newCondition) : this.filterFactory.createFilter(project.getInput(), newCondition);
        Project newProjRel = this.projectFactory == null ? project.copy(project.getTraitSet(), newFilterRel, project.getProjects(), project.getRowType()) : this.projectFactory.createProject(newFilterRel, Collections.emptyList(), project.getProjects(), project.getRowType().getFieldNames());
        call.transformTo((RelNode)newProjRel);
    }
}

