/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.optimizer.calcite;

import java.util.ArrayList;
import java.util.List;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rex.RexBuilder;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.fun.SqlStdOperatorTable;
import org.apache.calcite.util.RangeSets;
import org.apache.hadoop.hive.ql.optimizer.calcite.reloperators.HiveBetween;

class RangeConverter<C extends Comparable<C>>
implements RangeSets.Consumer<C> {
    private final RexBuilder rexBuilder;
    private final RelDataType type;
    private final RexNode ref;
    final List<RexNode> inLiterals;
    final List<RexNode> nodes;

    public RangeConverter(RexBuilder rexBuilder, RelDataType type, RexNode ref) {
        this.rexBuilder = rexBuilder;
        this.type = type;
        this.ref = ref;
        this.inLiterals = new ArrayList<RexNode>();
        this.nodes = new ArrayList<RexNode>();
    }

    private RexNode op(SqlOperator op, C value) {
        return this.rexBuilder.makeCall(op, new RexNode[]{this.ref, this.rexBuilder.makeLiteral(value, this.type, true, true)});
    }

    private RexNode and(RexNode ... nodes) {
        return this.rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.AND, nodes);
    }

    public void all() {
        this.nodes.add((RexNode)this.rexBuilder.makeLiteral(true));
    }

    public void atLeast(C lower) {
        this.nodes.add(this.op((SqlOperator)SqlStdOperatorTable.GREATER_THAN_OR_EQUAL, lower));
    }

    public void atMost(C upper) {
        this.nodes.add(this.op((SqlOperator)SqlStdOperatorTable.LESS_THAN_OR_EQUAL, upper));
    }

    public void greaterThan(C lower) {
        this.nodes.add(this.op((SqlOperator)SqlStdOperatorTable.GREATER_THAN, lower));
    }

    public void lessThan(C upper) {
        this.nodes.add(this.op((SqlOperator)SqlStdOperatorTable.LESS_THAN, upper));
    }

    public void singleton(C value) {
        this.inLiterals.add(this.rexBuilder.makeLiteral(value, this.type, true, true));
    }

    public void closed(C lower, C upper) {
        this.nodes.add(this.rexBuilder.makeCall((SqlOperator)HiveBetween.INSTANCE, new RexNode[]{this.rexBuilder.makeLiteral(false), this.ref, this.rexBuilder.makeLiteral(lower, this.type, true, true), this.rexBuilder.makeLiteral(upper, this.type, true, true)}));
    }

    public void closedOpen(C lower, C upper) {
        this.nodes.add(this.and(this.op((SqlOperator)SqlStdOperatorTable.GREATER_THAN_OR_EQUAL, lower), this.op((SqlOperator)SqlStdOperatorTable.LESS_THAN, upper)));
    }

    public void openClosed(C lower, C upper) {
        this.nodes.add(this.and(this.op((SqlOperator)SqlStdOperatorTable.GREATER_THAN, lower), this.op((SqlOperator)SqlStdOperatorTable.LESS_THAN_OR_EQUAL, upper)));
    }

    public void open(C lower, C upper) {
        this.nodes.add(this.and(this.op((SqlOperator)SqlStdOperatorTable.GREATER_THAN, lower), this.op((SqlOperator)SqlStdOperatorTable.LESS_THAN, upper)));
    }
}

