/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.optimizer.calcite;

import java.util.ArrayDeque;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import java.util.function.Supplier;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.RelShuttle;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.rex.RexVisitor;
import org.apache.calcite.tools.RelBuilder;
import org.apache.hadoop.hive.common.TableName;
import org.apache.hadoop.hive.ql.lockmgr.HiveTxnManager;
import org.apache.hadoop.hive.ql.metadata.Hive;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.metadata.HiveRelOptMaterialization;
import org.apache.hadoop.hive.ql.metadata.RewriteAlgorithm;
import org.apache.hadoop.hive.ql.metadata.Table;
import org.apache.hadoop.hive.ql.optimizer.calcite.HiveMaterializedViewASTSubQueryRewriteRexShuttle;
import org.apache.hadoop.hive.ql.optimizer.calcite.HiveRelShuttleImpl;
import org.apache.hadoop.hive.ql.optimizer.calcite.reloperators.HiveFilter;
import org.apache.hadoop.hive.ql.optimizer.calcite.reloperators.HiveProject;
import org.apache.hadoop.hive.ql.optimizer.calcite.rules.views.HiveMaterializedViewUtils;
import org.apache.hadoop.hive.ql.parse.ASTNode;
import org.apache.hadoop.hive.ql.parse.CalcitePlanner;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HiveMaterializedViewASTSubQueryRewriteShuttle
extends HiveRelShuttleImpl {
    private static final Logger LOG = LoggerFactory.getLogger(HiveMaterializedViewASTSubQueryRewriteShuttle.class);
    private final Map<RelNode, ASTNode> subQueryMap;
    private final ASTNode originalAST;
    private final ASTNode expandedAST;
    private final RelBuilder relBuilder;
    private final Hive db;
    private final Set<TableName> tablesUsedByOriginalPlan;
    private final Supplier<String> validTxnsList;
    private final HiveTxnManager txnManager;

    public HiveMaterializedViewASTSubQueryRewriteShuttle(Map<RelNode, ASTNode> subQueryMap, ASTNode originalAST, ASTNode expandedAST, RelBuilder relBuilder, Hive db, Set<TableName> tablesUsedByOriginalPlan, Supplier<String> validTxnsList, HiveTxnManager txnManager) {
        this.subQueryMap = Collections.unmodifiableMap(subQueryMap);
        this.originalAST = originalAST;
        this.expandedAST = expandedAST;
        this.relBuilder = relBuilder;
        this.db = db;
        this.tablesUsedByOriginalPlan = Collections.unmodifiableSet(tablesUsedByOriginalPlan);
        this.validTxnsList = validTxnsList;
        this.txnManager = txnManager;
    }

    public RelNode rewrite(RelNode relNode) {
        return relNode.accept((RelShuttle)this);
    }

    @Override
    public RelNode visit(HiveProject project) {
        if (!this.subQueryMap.containsKey(project)) {
            return super.visit(project);
        }
        ArrayDeque<Integer> path = new ArrayDeque<Integer>();
        for (ASTNode curr = this.subQueryMap.get(project); curr != null && curr != this.originalAST; curr = (ASTNode)curr.getParent()) {
            path.push(curr.getType());
        }
        ASTNode expandedSubqAST = new CalcitePlanner.ASTSearcher().simpleBreadthFirstSearch(this.expandedAST, path);
        if (expandedSubqAST == null) {
            return super.visit(project);
        }
        RelNode match = HiveMaterializedViewASTSubQueryRewriteShuttle.getMaterializedViewByAST(expandedSubqAST, this.relBuilder.getCluster(), RewriteAlgorithm.NON_CALCITE, this.db, this.tablesUsedByOriginalPlan, this.validTxnsList, this.txnManager);
        if (match != null) {
            return match;
        }
        return super.visit(project);
    }

    @Override
    public RelNode visit(HiveFilter filter) {
        RexNode newCond = (RexNode)filter.getCondition().accept((RexVisitor)new HiveMaterializedViewASTSubQueryRewriteRexShuttle(this));
        return this.relBuilder.push(filter.getInput().accept((RelShuttle)this)).filter(new RexNode[]{newCond}).build();
    }

    public static RelNode getMaterializedViewByAST(ASTNode expandedAST, RelOptCluster optCluster, Predicate<Set<RewriteAlgorithm>> filter, Hive db, Set<TableName> tablesUsedByOriginalPlan, Supplier<String> validTxnsList, HiveTxnManager txnManager) {
        try {
            List<HiveRelOptMaterialization> relOptMaterializationList = db.getMaterializedViewsByAST(expandedAST, tablesUsedByOriginalPlan, validTxnsList, txnManager);
            for (HiveRelOptMaterialization relOptMaterialization : relOptMaterializationList) {
                if (!filter.test(relOptMaterialization.getScope())) {
                    LOG.debug("Filter out materialized view {} scope {}", (Object)relOptMaterialization.qualifiedTableName, relOptMaterialization.getScope());
                    continue;
                }
                try {
                    Table hiveTableMD = HiveMaterializedViewUtils.extractTable(relOptMaterialization);
                    if (HiveMaterializedViewUtils.checkPrivilegeForMaterializedViews(Collections.singletonList(hiveTableMD))) {
                        HashSet<TableName> sourceTables = new HashSet<TableName>(1);
                        sourceTables.add(hiveTableMD.getFullTableName());
                        if (!db.validateMaterializedViewsFromRegistry(Collections.singletonList(hiveTableMD), sourceTables, validTxnsList, txnManager)) continue;
                        return relOptMaterialization.copyToNewCluster((RelOptCluster)optCluster).tableRel;
                    }
                    LOG.debug("User does not have privilege to use materialized view {}", (Object)relOptMaterialization.qualifiedTableName);
                }
                catch (HiveException e) {
                    LOG.warn("Skipping materialized view due to validation failure: " + relOptMaterialization.qualifiedTableName, (Throwable)e);
                }
            }
        }
        catch (HiveException e) {
            LOG.warn(String.format("Exception while looking up materialized views for query '%s'", expandedAST), (Throwable)e);
        }
        return null;
    }
}

