/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.optimizer.calcite;

import com.google.common.collect.ImmutableList;
import java.util.List;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.metadata.ChainedRelMetadataProvider;
import org.apache.calcite.rel.metadata.JaninoRelMetadataProvider;
import org.apache.calcite.rel.metadata.RelMetadataProvider;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.optimizer.calcite.cost.HiveDefaultCostModel;
import org.apache.hadoop.hive.ql.optimizer.calcite.cost.HiveOnTezCostModel;
import org.apache.hadoop.hive.ql.optimizer.calcite.cost.HiveRelMdCost;
import org.apache.hadoop.hive.ql.optimizer.calcite.stats.HiveRelMdAggregatedColumns;
import org.apache.hadoop.hive.ql.optimizer.calcite.stats.HiveRelMdCollation;
import org.apache.hadoop.hive.ql.optimizer.calcite.stats.HiveRelMdColumnUniqueness;
import org.apache.hadoop.hive.ql.optimizer.calcite.stats.HiveRelMdCumulativeCost;
import org.apache.hadoop.hive.ql.optimizer.calcite.stats.HiveRelMdDistinctRowCount;
import org.apache.hadoop.hive.ql.optimizer.calcite.stats.HiveRelMdDistribution;
import org.apache.hadoop.hive.ql.optimizer.calcite.stats.HiveRelMdExpressionLineage;
import org.apache.hadoop.hive.ql.optimizer.calcite.stats.HiveRelMdMemory;
import org.apache.hadoop.hive.ql.optimizer.calcite.stats.HiveRelMdParallelism;
import org.apache.hadoop.hive.ql.optimizer.calcite.stats.HiveRelMdPredicates;
import org.apache.hadoop.hive.ql.optimizer.calcite.stats.HiveRelMdRowCount;
import org.apache.hadoop.hive.ql.optimizer.calcite.stats.HiveRelMdRuntimeRowCount;
import org.apache.hadoop.hive.ql.optimizer.calcite.stats.HiveRelMdSelectivity;
import org.apache.hadoop.hive.ql.optimizer.calcite.stats.HiveRelMdSize;
import org.apache.hadoop.hive.ql.optimizer.calcite.stats.HiveRelMdTableReferences;
import org.apache.hadoop.hive.ql.optimizer.calcite.stats.HiveRelMdUniqueKeys;

public class HiveDefaultRelMetadataProvider {
    private static final JaninoRelMetadataProvider DEFAULT = JaninoRelMetadataProvider.of((RelMetadataProvider)ChainedRelMetadataProvider.of((List)ImmutableList.of((Object)HiveRelMdDistinctRowCount.SOURCE, (Object)HiveRelMdCumulativeCost.SOURCE, (Object)new HiveRelMdCost(HiveDefaultCostModel.getCostModel()).getMetadataProvider(), (Object)HiveRelMdSelectivity.SOURCE, (Object)HiveRelMdRuntimeRowCount.SOURCE, (Object)HiveRelMdUniqueKeys.SOURCE, (Object)HiveRelMdColumnUniqueness.SOURCE, (Object)HiveRelMdExpressionLineage.SOURCE, (Object)HiveRelMdSize.SOURCE, (Object)HiveRelMdMemory.SOURCE, (Object)HiveRelMdDistribution.SOURCE, (Object)HiveRelMdCollation.SOURCE, (Object[])new RelMetadataProvider[]{HiveRelMdPredicates.SOURCE, HiveRelMdTableReferences.SOURCE, HiveRelMdAggregatedColumns.SOURCE, JaninoRelMetadataProvider.DEFAULT})));
    private final RelMetadataProvider metadataProvider;

    public HiveDefaultRelMetadataProvider(HiveConf hiveConf, List<Class<? extends RelNode>> nodeClasses) {
        this.metadataProvider = this.init(hiveConf, nodeClasses);
    }

    private RelMetadataProvider init(HiveConf hiveConf, List<Class<? extends RelNode>> nodeClasses) {
        if (HiveConf.getVar((Configuration)hiveConf, (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_EXECUTION_ENGINE).equals("tez") && HiveConf.getBoolVar((Configuration)hiveConf, (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_CBO_EXTENDED_COST_MODEL)) {
            Double maxSplitSize = HiveConf.getLongVar((Configuration)hiveConf, (HiveConf.ConfVars)HiveConf.ConfVars.MAPRED_MAX_SPLIT_SIZE);
            JaninoRelMetadataProvider metadataProvider = JaninoRelMetadataProvider.of((RelMetadataProvider)ChainedRelMetadataProvider.of((List)ImmutableList.of((Object)HiveRelMdDistinctRowCount.SOURCE, (Object)HiveRelMdCumulativeCost.SOURCE, (Object)new HiveRelMdCost(HiveOnTezCostModel.getCostModel(hiveConf)).getMetadataProvider(), (Object)HiveRelMdSelectivity.SOURCE, (Object)HiveRelMdRowCount.SOURCE, (Object)HiveRelMdUniqueKeys.SOURCE, (Object)HiveRelMdColumnUniqueness.SOURCE, (Object)HiveRelMdExpressionLineage.SOURCE, (Object)HiveRelMdSize.SOURCE, (Object)HiveRelMdMemory.SOURCE, (Object)new HiveRelMdParallelism(maxSplitSize).getMetadataProvider(), (Object)HiveRelMdDistribution.SOURCE, (Object[])new RelMetadataProvider[]{HiveRelMdCollation.SOURCE, HiveRelMdPredicates.SOURCE, HiveRelMdTableReferences.SOURCE, HiveRelMdAggregatedColumns.SOURCE, JaninoRelMetadataProvider.DEFAULT})));
            if (nodeClasses != null) {
                metadataProvider.register(nodeClasses);
            }
            return metadataProvider;
        }
        return DEFAULT;
    }

    public RelMetadataProvider getMetadataProvider() {
        return this.metadataProvider;
    }

    public static void initializeMetadataProviderClass(List<Class<? extends RelNode>> nodeClasses) {
        DEFAULT.register(nodeClasses);
    }
}

