/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.optimizer;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.Stack;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.api.Table;
import org.apache.hadoop.hive.metastore.utils.MetaStoreUtils;
import org.apache.hadoop.hive.ql.exec.TableScanOperator;
import org.apache.hadoop.hive.ql.lib.DefaultRuleDispatcher;
import org.apache.hadoop.hive.ql.lib.Node;
import org.apache.hadoop.hive.ql.lib.NodeProcessorCtx;
import org.apache.hadoop.hive.ql.lib.PreOrderWalker;
import org.apache.hadoop.hive.ql.lib.RuleRegExp;
import org.apache.hadoop.hive.ql.lib.SemanticNodeProcessor;
import org.apache.hadoop.hive.ql.optimizer.Transform;
import org.apache.hadoop.hive.ql.parse.ParseContext;
import org.apache.hadoop.hive.ql.parse.SemanticException;
import org.apache.hadoop.hive.ql.plan.TableScanDesc;
import org.apache.hadoop.hive.serde2.AbstractSerDe;
import org.apache.hive.common.util.ReflectionUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class TablePropertyEnrichmentOptimizer
extends Transform {
    private static Logger LOG = LoggerFactory.getLogger(TablePropertyEnrichmentOptimizer.class);

    TablePropertyEnrichmentOptimizer() {
    }

    private static Map<String, String> getTableParameters(Table table) {
        HashMap<String, String> originalTableParameters = new HashMap<String, String>(table.getParameters());
        Properties tableMetadata = MetaStoreUtils.getTableMetadata((Table)table);
        for (String property : tableMetadata.stringPropertyNames()) {
            if (originalTableParameters.containsKey(property)) continue;
            originalTableParameters.put(property, tableMetadata.getProperty(property));
        }
        return originalTableParameters;
    }

    @Override
    public ParseContext transform(ParseContext pctx) throws SemanticException {
        LOG.info("TablePropertyEnrichmentOptimizer::transform().");
        LinkedHashMap opRules = Maps.newLinkedHashMap();
        opRules.put(new RuleRegExp("R1", TableScanOperator.getOperatorName() + "%"), new Processor());
        WalkerCtx context = new WalkerCtx((Configuration)pctx.getConf());
        DefaultRuleDispatcher disp = new DefaultRuleDispatcher(null, opRules, context);
        ArrayList topNodes = Lists.newArrayList();
        topNodes.addAll(pctx.getTopOps().values());
        PreOrderWalker walker = new PreOrderWalker(disp);
        walker.startWalking(topNodes, null);
        LOG.info("TablePropertyEnrichmentOptimizer::transform() complete!");
        return pctx;
    }

    private static class Processor
    implements SemanticNodeProcessor {
        private Processor() {
        }

        @Override
        public Object process(Node nd, Stack<Node> stack, NodeProcessorCtx procCtx, Object ... nodeOutputs) throws SemanticException {
            TableScanOperator tsOp = (TableScanOperator)nd;
            WalkerCtx context = (WalkerCtx)procCtx;
            TableScanDesc tableScanDesc = (TableScanDesc)tsOp.getConf();
            Table table = ((TableScanDesc)tsOp.getConf()).getTableMetadata().getTTable();
            Map<String, String> originalTableParameters = TablePropertyEnrichmentOptimizer.getTableParameters(table);
            LOG.debug("Original Table parameters: {}", originalTableParameters);
            Properties clonedTableParameters = new Properties();
            clonedTableParameters.putAll(originalTableParameters);
            String deserializerClassName = null;
            try {
                deserializerClassName = tableScanDesc.getTableMetadata().getSd().getSerdeInfo().getSerializationLib();
                AbstractSerDe serDe = (AbstractSerDe)ReflectionUtil.newInstance(context.conf.getClassByName(deserializerClassName).asSubclass(AbstractSerDe.class), (Configuration)context.conf);
                if (context.serdeClassesUnderConsideration.contains(deserializerClassName)) {
                    serDe.initialize(context.conf, clonedTableParameters, null);
                    LOG.debug("SerDe init succeeded for class: {}", (Object)deserializerClassName);
                    for (Map.Entry<Object, Object> property : clonedTableParameters.entrySet()) {
                        if (property.getValue().equals(originalTableParameters.get(property.getKey()))) continue;
                        LOG.debug("Resolving changed parameters! key=" + property.getKey() + ", value=" + property.getValue());
                        table.getParameters().put((String)property.getKey(), (String)property.getValue());
                    }
                } else {
                    LOG.debug("Skipping prefetch for {}", (Object)deserializerClassName);
                }
            }
            catch (Throwable t) {
                LOG.error("SerDe init failed for SerDe class==" + deserializerClassName + ". Didn't change table-properties", t);
            }
            return nd;
        }
    }

    private static class WalkerCtx
    implements NodeProcessorCtx {
        Configuration conf;
        Set<String> serdeClassesUnderConsideration = Sets.newHashSet();

        WalkerCtx(Configuration conf) {
            this.conf = conf;
            this.serdeClassesUnderConsideration.addAll(Arrays.asList(HiveConf.getVar((Configuration)conf, (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_OPTIMIZE_TABLE_PROPERTIES_FROM_SERDE_LIST).split(",")));
            if (LOG.isDebugEnabled()) {
                LOG.debug("TablePropertyEnrichmentOptimizer considers these SerDe classes:");
                for (String className : this.serdeClassesUnderConsideration) {
                    LOG.debug(className);
                }
            }
        }
    }
}

