/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.optimizer;

import java.util.Collection;
import java.util.EnumSet;
import java.util.Stack;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.exec.Operator;
import org.apache.hadoop.hive.ql.exec.ReduceSinkOperator;
import org.apache.hadoop.hive.ql.exec.Utilities;
import org.apache.hadoop.hive.ql.lib.Node;
import org.apache.hadoop.hive.ql.lib.NodeProcessorCtx;
import org.apache.hadoop.hive.ql.lib.SemanticNodeProcessor;
import org.apache.hadoop.hive.ql.parse.OptimizeTezProcContext;
import org.apache.hadoop.hive.ql.parse.SemanticException;
import org.apache.hadoop.hive.ql.plan.ExprNodeDesc;
import org.apache.hadoop.hive.ql.plan.OperatorDesc;
import org.apache.hadoop.hive.ql.plan.ReduceSinkDesc;
import org.apache.hadoop.hive.ql.stats.StatsUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SetReducerParallelism
implements SemanticNodeProcessor {
    private static final Logger LOG = LoggerFactory.getLogger((String)SetReducerParallelism.class.getName());

    @Override
    public Object process(Node nd, Stack<Node> stack, NodeProcessorCtx procContext, Object ... nodeOutputs) throws SemanticException {
        OptimizeTezProcContext context = (OptimizeTezProcContext)procContext;
        ReduceSinkOperator sink = (ReduceSinkOperator)nd;
        ReduceSinkDesc desc = (ReduceSinkDesc)sink.getConf();
        long bytesPerReducer = context.conf.getLongVar(HiveConf.ConfVars.BYTES_PER_REDUCER);
        int maxReducers = context.conf.getIntVar(HiveConf.ConfVars.MAX_REDUCERS);
        int constantReducers = context.conf.getIntVar(HiveConf.ConfVars.HADOOP_NUM_REDUCERS);
        if (context.visitedReduceSinks.contains(sink)) {
            LOG.debug("Already processed reduce sink: " + sink.getName());
            return true;
        }
        context.visitedReduceSinks.add(sink);
        if (desc.getNumReducers() <= 0) {
            if (constantReducers > 0) {
                LOG.info("Parallelism for reduce sink " + sink + " set by user to " + constantReducers);
                desc.setNumReducers(constantReducers);
            } else {
                long numberOfBytes = 0L;
                for (Operator<OperatorDesc> sibling : sink.getChildOperators().get(0).getParentOperators()) {
                    if (sibling.getStatistics() != null) {
                        numberOfBytes = StatsUtils.safeAdd(numberOfBytes, sibling.getStatistics().getDataSize());
                        continue;
                    }
                    LOG.warn("No stats available from: " + sibling);
                }
                int numReducers = Utilities.estimateReducers(numberOfBytes, bytesPerReducer, maxReducers, false);
                LOG.info("Set parallelism for reduce sink " + sink + " to: " + numReducers);
                desc.setNumReducers(numReducers);
                Collection<ExprNodeDesc.ExprNodeDescEqualityWrapper> keyCols = ExprNodeDesc.ExprNodeDescEqualityWrapper.transform(desc.getKeyCols());
                Collection<ExprNodeDesc.ExprNodeDescEqualityWrapper> partCols = ExprNodeDesc.ExprNodeDescEqualityWrapper.transform(desc.getPartitionCols());
                if (keyCols != null && keyCols.equals(partCols)) {
                    desc.setReducerTraits(EnumSet.of(ReduceSinkDesc.ReducerTraits.UNIFORM, ReduceSinkDesc.ReducerTraits.AUTOPARALLEL));
                } else {
                    desc.setReducerTraits(EnumSet.of(ReduceSinkDesc.ReducerTraits.AUTOPARALLEL));
                }
            }
        } else {
            LOG.info("Number of reducers determined to be: " + desc.getNumReducers());
            desc.setReducerTraits(EnumSet.of(ReduceSinkDesc.ReducerTraits.FIXED));
        }
        return false;
    }
}

