/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.optimizer;

import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Stack;
import org.apache.hadoop.hive.ql.exec.Operator;
import org.apache.hadoop.hive.ql.exec.ReduceSinkOperator;
import org.apache.hadoop.hive.ql.exec.Task;
import org.apache.hadoop.hive.ql.lib.Node;
import org.apache.hadoop.hive.ql.lib.NodeProcessorCtx;
import org.apache.hadoop.hive.ql.lib.SemanticNodeProcessor;
import org.apache.hadoop.hive.ql.optimizer.GenMRProcContext;
import org.apache.hadoop.hive.ql.optimizer.GenMapRedUtils;
import org.apache.hadoop.hive.ql.parse.SemanticException;
import org.apache.hadoop.hive.ql.plan.OperatorDesc;

public class GenMRRedSink2
implements SemanticNodeProcessor {
    @Override
    public Object process(Node nd, Stack<Node> stack, NodeProcessorCtx opProcCtx, Object ... nodeOutputs) throws SemanticException {
        ReduceSinkOperator op = (ReduceSinkOperator)nd;
        GenMRProcContext ctx = (GenMRProcContext)opProcCtx;
        LinkedHashMap<Operator<? extends OperatorDesc>, GenMRProcContext.GenMapRedCtx> mapCurrCtx = ctx.getMapCurrCtx();
        GenMRProcContext.GenMapRedCtx mapredCtx = (GenMRProcContext.GenMapRedCtx)mapCurrCtx.get(op.getParentOperators().get(0));
        Task currTask = mapredCtx.getCurrTask();
        String currAliasId = mapredCtx.getCurrAliasId();
        Operator<OperatorDesc> reducer = op.getChildOperators().get(0);
        HashMap<Operator<OperatorDesc>, Task<?>> opTaskMap = ctx.getOpTaskMap();
        Task oldTask = (Task)opTaskMap.get(reducer);
        ctx.setCurrAliasId(currAliasId);
        ctx.setCurrTask(currTask);
        if (oldTask == null) {
            GenMapRedUtils.splitPlan(op, ctx);
        } else {
            GenMapRedUtils.splitPlan(op, currTask, oldTask, ctx);
            currTask = oldTask;
            ctx.setCurrTask(currTask);
        }
        mapCurrCtx.put(op, new GenMRProcContext.GenMapRedCtx(ctx.getCurrTask(), ctx.getCurrAliasId()));
        if (GenMapRedUtils.hasBranchFinished(nodeOutputs)) {
            ctx.addRootIfPossible(currTask);
            return false;
        }
        return true;
    }
}

