/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.optimizer;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import org.apache.hadoop.hive.ql.exec.ColumnInfo;
import org.apache.hadoop.hive.ql.exec.MapJoinOperator;
import org.apache.hadoop.hive.ql.exec.ReduceSinkOperator;
import org.apache.hadoop.hive.ql.exec.Utilities;
import org.apache.hadoop.hive.ql.lib.Node;
import org.apache.hadoop.hive.ql.lib.NodeProcessorCtx;
import org.apache.hadoop.hive.ql.lib.SemanticNodeProcessor;
import org.apache.hadoop.hive.ql.parse.SemanticException;
import org.apache.hadoop.hive.ql.plan.ExprNodeConstantDesc;
import org.apache.hadoop.hive.ql.plan.ExprNodeDesc;
import org.apache.hadoop.hive.ql.plan.ExprNodeDescUtils;
import org.apache.hadoop.hive.ql.plan.ExprNodeGenericFuncDesc;
import org.apache.hadoop.hive.ql.plan.MapJoinDesc;
import org.apache.hadoop.hive.ql.plan.PlanUtils;
import org.apache.hadoop.hive.ql.plan.ReduceSinkDesc;
import org.apache.hadoop.hive.ql.plan.TableDesc;
import org.apache.hadoop.hive.ql.udf.UDFToShort;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDF;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFBridge;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFOPMultiply;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFOPNot;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFOPPlus;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoFactory;

public class FiltertagAppenderProc
implements SemanticNodeProcessor {
    private final TypeInfo shortType = TypeInfoFactory.getPrimitiveTypeInfo((String)"smallint");

    @Override
    public Object process(Node nd, Stack<Node> stack, NodeProcessorCtx procCtx, Object ... nodeOutputs) throws SemanticException {
        MapJoinOperator mapJoinOp = (MapJoinOperator)nd;
        MapJoinDesc mapJoinDesc = (MapJoinDesc)mapJoinOp.getConf();
        if (mapJoinDesc.getFilterMap() == null) {
            return null;
        }
        int[][] filterMap = mapJoinDesc.getFilterMap();
        for (byte pos = 0; pos < filterMap.length; pos = (byte)((byte)(pos + 1))) {
            if (pos == mapJoinDesc.getPosBigTable() || filterMap[pos] == null) continue;
            ExprNodeDesc filterTagExpr = this.generateFilterTagExpression(filterMap[pos], mapJoinDesc.getFilters().get(pos));
            ReduceSinkOperator parent = (ReduceSinkOperator)mapJoinOp.getParentOperators().get(pos);
            ReduceSinkDesc pRsConf = (ReduceSinkDesc)parent.getConf();
            ExprNodeDesc mapSideFilterTagExpr = mapJoinDesc.isDynamicPartitionHashJoin() ? ExprNodeDescUtils.backtrack(filterTagExpr, mapJoinOp, parent) : filterTagExpr;
            String filterColumnName = "_filterTag";
            pRsConf.getValueCols().add(mapSideFilterTagExpr);
            pRsConf.getOutputValueColumnNames().add(filterColumnName);
            pRsConf.getColumnExprMap().put(Utilities.ReduceField.VALUE + "." + filterColumnName, mapSideFilterTagExpr);
            ColumnInfo filterTagColumnInfo = new ColumnInfo(Utilities.ReduceField.VALUE + "." + filterColumnName, this.shortType, "", false);
            parent.getSchema().getSignature().add(filterTagColumnInfo);
            TableDesc newTableDesc = PlanUtils.getReduceValueTableDesc(PlanUtils.getFieldSchemasFromColumnList(pRsConf.getValueCols(), "_col"));
            pRsConf.setValueSerializeInfo(newTableDesc);
        }
        ArrayList<TableDesc> newMapJoinValueFilteredTableDescs = new ArrayList<TableDesc>(mapJoinOp.getParentOperators().size());
        for (int pos = 0; pos < mapJoinOp.getParentOperators().size(); pos = (int)((byte)(pos + 1))) {
            TableDesc tableDesc;
            if (pos == mapJoinDesc.getPosBigTable() || filterMap[pos] == null) {
                tableDesc = mapJoinDesc.getValueFilteredTblDescs().get(pos);
            } else {
                ReduceSinkOperator parent = (ReduceSinkOperator)mapJoinOp.getParentOperators().get(pos);
                ReduceSinkDesc pRsConf = (ReduceSinkDesc)parent.getConf();
                tableDesc = PlanUtils.getMapJoinValueTableDesc(PlanUtils.getFieldSchemasFromColumnList(pRsConf.getValueCols(), "mapjoinvalue"));
            }
            newMapJoinValueFilteredTableDescs.add(tableDesc);
        }
        mapJoinDesc.setValueFilteredTblDescs(newMapJoinValueFilteredTableDescs);
        return null;
    }

    private ExprNodeDesc generateFilterTagExpression(int[] filterMap, List<ExprNodeDesc> filterExprs) {
        ExprNodeDesc filterTagExpr = new ExprNodeConstantDesc(this.shortType, (short)0);
        Map<Byte, ExprNodeDesc> filterExprMap = this.getFilterExprMap(filterMap, filterExprs);
        for (Map.Entry<Byte, ExprNodeDesc> entry : filterExprMap.entrySet()) {
            ExprNodeDesc filterTagMaskExpr = this.generateFilterTagMask(entry.getKey(), entry.getValue());
            if (filterTagExpr instanceof ExprNodeConstantDesc) {
                filterTagExpr = filterTagMaskExpr;
                continue;
            }
            List<ExprNodeDesc> plusArgs = Arrays.asList(filterTagMaskExpr, filterTagExpr);
            filterTagExpr = new ExprNodeGenericFuncDesc(this.shortType, (GenericUDF)new GenericUDFOPPlus(), plusArgs);
        }
        return filterTagExpr;
    }

    private Map<Byte, ExprNodeDesc> getFilterExprMap(int[] filterInfo, List<ExprNodeDesc> filterExprs) {
        HashMap<Byte, ExprNodeDesc> filterExprMap = new HashMap<Byte, ExprNodeDesc>();
        int exprListOffset = 0;
        for (int idx = 0; idx < filterInfo.length; idx += 2) {
            byte tag = (byte)filterInfo[idx];
            int length = filterInfo[idx + 1];
            int nextExprOffset = exprListOffset + length;
            List<ExprNodeDesc> andArgs = filterExprs.subList(exprListOffset, nextExprOffset);
            exprListOffset = nextExprOffset;
            if (andArgs.size() == 1) {
                filterExprMap.put(tag, andArgs.get(0));
                continue;
            }
            if (andArgs.size() <= 1) continue;
            filterExprMap.put(tag, ExprNodeDescUtils.and(andArgs));
        }
        return filterExprMap;
    }

    private ExprNodeDesc generateFilterTagMask(byte tag, ExprNodeDesc condition) {
        ExprNodeConstantDesc filterMaskValue = new ExprNodeConstantDesc(this.shortType, (short)(1 << tag));
        List<ExprNodeDesc> negateArg = Collections.singletonList(condition);
        ExprNodeGenericFuncDesc negate = new ExprNodeGenericFuncDesc((TypeInfo)TypeInfoFactory.getPrimitiveTypeInfo((String)"boolean"), (GenericUDF)new GenericUDFOPNot(), negateArg);
        GenericUDFBridge toShort = new GenericUDFBridge();
        toShort.setUdfClassName(UDFToShort.class.getName());
        toShort.setUdfName(UDFToShort.class.getSimpleName());
        List<ExprNodeDesc> toShortArg = Collections.singletonList(negate);
        ExprNodeGenericFuncDesc conditionAsShort = new ExprNodeGenericFuncDesc(this.shortType, (GenericUDF)toShort, toShortArg);
        List<ExprNodeDesc> multiplyArgs = Arrays.asList(conditionAsShort, filterMaskValue);
        ExprNodeGenericFuncDesc multiply = new ExprNodeGenericFuncDesc(this.shortType, (GenericUDF)new GenericUDFOPMultiply(), multiplyArgs);
        return multiply;
    }
}

