/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.metadata.formatting;

import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.metadata.formatting.JsonMetaDataFormatter;
import org.apache.hadoop.hive.ql.metadata.formatting.MetaDataFormatter;
import org.apache.hadoop.hive.ql.metadata.formatting.TextMetaDataFormatter;

public final class MetaDataFormatUtils {
    private MetaDataFormatUtils() {
        throw new UnsupportedOperationException("MetaDataFormatUtils should not be instantiated");
    }

    public static MetaDataFormatter getFormatter(HiveConf conf) {
        if (MetaDataFormatUtils.isJson(conf)) {
            return new JsonMetaDataFormatter();
        }
        return new TextMetaDataFormatter();
    }

    public static boolean isJson(HiveConf conf) {
        return "json".equals(conf.get(HiveConf.ConfVars.HIVE_DDL_OUTPUT_FORMAT.varname, "text"));
    }
}

