/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.metadata;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.hive.metastore.api.GetPartitionsRequest;
import org.apache.hadoop.hive.metastore.api.PartitionFilterMode;
import org.apache.hadoop.hive.ql.metadata.Hive;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.metadata.Partition;
import org.apache.hadoop.hive.ql.metadata.Table;
import org.apache.thrift.TException;

public class PartitionIterable
implements Iterable<Partition> {
    final Type currType;
    private Collection<Partition> ptnsProvided = null;
    private Hive db = null;
    private Table table = null;
    private Map<String, String> partialPartitionSpec = null;
    private List<String> partitionNames = null;
    private int batchSize;
    private boolean getColStats = false;
    private boolean isAuthRequired = false;
    private String userName;
    private List<String> groupNames;
    private GetPartitionsRequest getPartitionsRequest;

    @Override
    public Iterator<Partition> iterator() {
        return new Iterator<Partition>(){
            private boolean initialized = false;
            private Iterator<Partition> partitionIterator = null;
            private Iterator<String> partitionNamesIter = null;
            private Iterator<Partition> batchIter = null;

            private void initialize() {
                if (!this.initialized) {
                    if (PartitionIterable.this.currType == Type.LIST_PROVIDED) {
                        this.partitionIterator = PartitionIterable.this.ptnsProvided.iterator();
                    } else {
                        this.partitionNamesIter = PartitionIterable.this.partitionNames.iterator();
                    }
                    this.initialized = true;
                }
            }

            @Override
            public boolean hasNext() {
                this.initialize();
                if (PartitionIterable.this.currType == Type.LIST_PROVIDED) {
                    return this.partitionIterator.hasNext();
                }
                return this.batchIter != null && this.batchIter.hasNext() || this.partitionNamesIter.hasNext();
            }

            @Override
            public Partition next() {
                this.initialize();
                if (PartitionIterable.this.currType == Type.LIST_PROVIDED) {
                    return this.partitionIterator.next();
                }
                if (this.batchIter == null || !this.batchIter.hasNext()) {
                    this.getNextBatch();
                }
                return this.batchIter.next();
            }

            private void getNextBatch() {
                ArrayList<String> nameBatch = new ArrayList<String>();
                for (int batchCounter = 0; batchCounter < PartitionIterable.this.batchSize && this.partitionNamesIter.hasNext(); ++batchCounter) {
                    nameBatch.add(this.partitionNamesIter.next());
                }
                try {
                    this.batchIter = PartitionIterable.this.getPartitionsRequest == null ? (PartitionIterable.this.isAuthRequired ? PartitionIterable.this.db.getPartitionsAuthByNames(PartitionIterable.this.table, nameBatch, PartitionIterable.this.userName, PartitionIterable.this.groupNames).iterator() : PartitionIterable.this.db.getPartitionsByNames(PartitionIterable.this.table, nameBatch, PartitionIterable.this.getColStats).iterator()) : PartitionIterable.this.db.getPartitionsWithSpecsByNames(PartitionIterable.this.table, nameBatch, PartitionIterable.this.getPartitionsRequest).iterator();
                }
                catch (HiveException | TException e) {
                    throw new RuntimeException(e);
                }
            }

            @Override
            public void remove() {
                throw new IllegalStateException("PartitionIterable is a read-only iterable and remove() is unsupported");
            }
        };
    }

    public PartitionIterable(Collection<Partition> ptnsProvided) {
        this.currType = Type.LIST_PROVIDED;
        this.ptnsProvided = ptnsProvided;
    }

    public PartitionIterable(Hive db, Table table, Map<String, String> partialPartitionSpec, int batchSize) throws HiveException {
        this(db, table, partialPartitionSpec, batchSize, false);
    }

    public PartitionIterable(Hive db, Table table, Map<String, String> partialPartitionSpec, int batchSize, boolean isAuthRequired, String userName, List<String> groupNames) throws HiveException {
        this(db, table, partialPartitionSpec, batchSize, false, isAuthRequired, userName, groupNames);
    }

    public PartitionIterable(Hive db, Table table, Map<String, String> partialPartitionSpec, int batchSize, boolean getColStats) throws HiveException {
        this(db, table, partialPartitionSpec, batchSize, getColStats, false, null, null);
    }

    public PartitionIterable(Hive db, GetPartitionsRequest getPartitionsRequest, int batchSize) throws HiveException {
        if (batchSize < 1) {
            throw new HiveException("Invalid batch size for partition iterable. Please use a batch size greater than 0");
        }
        this.currType = Type.LAZY_FETCH_PARTITIONS;
        this.db = db;
        this.table = db.getTable(getPartitionsRequest.getDbName(), getPartitionsRequest.getTblName());
        this.batchSize = batchSize;
        this.getPartitionsRequest = getPartitionsRequest;
        List pVals = null;
        if (getPartitionsRequest.isSetFilterSpec()) {
            pVals = this.getPartitionsRequest.getFilterSpec().getFilters();
        }
        if (pVals == null) {
            this.partitionNames = db.getPartitionNames(this.table, (short)-1);
        } else {
            PartitionFilterMode filterMode = getPartitionsRequest.getFilterSpec().getFilterMode();
            switch (filterMode) {
                case BY_NAMES: {
                    this.partitionNames = pVals;
                    break;
                }
                case BY_VALUES: {
                    this.partitionNames = db.getPartitionNamesByPartitionVals(this.table, pVals, (short)-1);
                    break;
                }
                case BY_EXPR: {
                    throw new HiveException("getpartitionsbyexpr is currently unsupported for the getpartitionswithspecs API");
                }
                default: {
                    throw new HiveException("No such partition filter mode: " + filterMode);
                }
            }
        }
    }

    private PartitionIterable(Hive db, Table table, Map<String, String> partialPartitionSpec, int batchSize, boolean getColStats, boolean isAuthRequired, String userName, List<String> groupNames) throws HiveException {
        if (batchSize < 1) {
            throw new HiveException("Invalid batch size for partition iterable. Please use a batch size greater than 0");
        }
        this.currType = Type.LAZY_FETCH_PARTITIONS;
        this.db = db;
        this.table = table;
        this.partialPartitionSpec = partialPartitionSpec;
        this.batchSize = batchSize;
        this.getColStats = getColStats;
        this.isAuthRequired = isAuthRequired;
        this.userName = userName;
        this.groupNames = groupNames;
        this.partitionNames = this.partialPartitionSpec == null ? db.getPartitionNames(table, (short)-1) : db.getPartitionNames(table, partialPartitionSpec, (short)-1);
    }

    static enum Type {
        LIST_PROVIDED,
        LAZY_FETCH_PARTITIONS;

    }
}

