/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.lib;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.Stack;
import org.apache.commons.collections.CollectionUtils;
import org.apache.hadoop.hive.ql.exec.Operator;
import org.apache.hadoop.hive.ql.lib.DefaultGraphWalker;
import org.apache.hadoop.hive.ql.lib.Node;
import org.apache.hadoop.hive.ql.lib.SemanticDispatcher;
import org.apache.hadoop.hive.ql.parse.SemanticException;
import org.apache.hadoop.hive.ql.plan.OperatorDesc;

public class LevelOrderWalker
extends DefaultGraphWalker {
    private Set<Class<? extends Node>> nodeTypes = new HashSet<Class<? extends Node>>();
    private final int numLevels;

    public LevelOrderWalker(SemanticDispatcher disp) {
        super(disp);
        this.numLevels = Integer.MAX_VALUE;
    }

    public LevelOrderWalker(SemanticDispatcher disp, int numLevels) {
        super(disp);
        this.numLevels = numLevels;
    }

    public void setNodeTypes(Class<? extends Node> ... nodeTypes) {
        this.nodeTypes.addAll(Arrays.asList(nodeTypes));
    }

    @Override
    public void startWalking(Collection<Node> startNodes, HashMap<Node, Object> nodeOutput) throws SemanticException {
        this.toWalk.addAll(startNodes);
        HashSet<Node> addedNodes = new HashSet<Node>(startNodes);
        for (int index = 0; index < this.toWalk.size(); ++index) {
            List children = ((Node)this.toWalk.get(index)).getChildren();
            if (!CollectionUtils.isNotEmpty((Collection)children)) continue;
            for (Node child : children) {
                Operator childOP = (Operator)child;
                if (addedNodes.contains(child) || childOP.getParentOperators() != null && !addedNodes.containsAll(childOP.getParentOperators())) continue;
                this.toWalk.add(child);
                addedNodes.add(child);
            }
        }
        for (Node nd : this.toWalk) {
            if (!this.nodeTypes.isEmpty() && !this.nodeTypes.contains(nd.getClass())) continue;
            this.opStack.clear();
            this.opStack.push(nd);
            this.walk(nd, 0, this.opStack);
            if (nodeOutput == null || !this.getDispatchedList().contains(nd)) continue;
            nodeOutput.put(nd, this.retMap.get(nd));
        }
    }

    private void walk(Node nd, int level, Stack<Node> stack) throws SemanticException {
        List<Operator<OperatorDesc>> parents = ((Operator)nd).getParentOperators();
        if (level >= this.numLevels || CollectionUtils.isEmpty(parents)) {
            this.dispatch(stack.peek(), stack);
            return;
        }
        for (Node node : parents) {
            stack.add(0, node);
            this.walk(node, level + 1, stack);
            stack.remove(0);
        }
    }
}

