/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.io.parquet.convert;

import com.google.common.base.MoreObjects;
import java.math.BigDecimal;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.util.ArrayList;
import java.util.Map;
import java.util.Optional;
import java.util.TimeZone;
import org.apache.hadoop.hive.common.type.CalendarUtils;
import org.apache.hadoop.hive.common.type.HiveDecimal;
import org.apache.hadoop.hive.common.type.Timestamp;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.io.parquet.convert.ConverterParent;
import org.apache.hadoop.hive.ql.io.parquet.read.DataWritableReadSupport;
import org.apache.hadoop.hive.ql.io.parquet.timestamp.NanoTime;
import org.apache.hadoop.hive.ql.io.parquet.timestamp.NanoTimeUtils;
import org.apache.hadoop.hive.ql.io.parquet.timestamp.ParquetTimestampUtils;
import org.apache.hadoop.hive.serde2.io.DateWritableV2;
import org.apache.hadoop.hive.serde2.io.DoubleWritable;
import org.apache.hadoop.hive.serde2.io.HiveCharWritable;
import org.apache.hadoop.hive.serde2.io.HiveDecimalWritable;
import org.apache.hadoop.hive.serde2.io.HiveVarcharWritable;
import org.apache.hadoop.hive.serde2.io.TimestampWritableV2;
import org.apache.hadoop.hive.serde2.typeinfo.CharTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.DecimalTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.HiveDecimalUtils;
import org.apache.hadoop.hive.serde2.typeinfo.PrimitiveTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoFactory;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoUtils;
import org.apache.hadoop.hive.serde2.typeinfo.VarcharTypeInfo;
import org.apache.hadoop.io.BooleanWritable;
import org.apache.hadoop.io.BytesWritable;
import org.apache.hadoop.io.FloatWritable;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.Writable;
import org.apache.parquet.Preconditions;
import org.apache.parquet.column.Dictionary;
import org.apache.parquet.io.api.Binary;
import org.apache.parquet.io.api.PrimitiveConverter;
import org.apache.parquet.schema.LogicalTypeAnnotation;
import org.apache.parquet.schema.PrimitiveType;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public enum ETypeConverter {
    EDOUBLE_CONVERTER((Class)Double.TYPE){

        @Override
        PrimitiveConverter getConverter(PrimitiveType type, final int index, final ConverterParent parent, final TypeInfo hiveTypeInfo) {
            if (hiveTypeInfo != null) {
                String typeName = TypeInfoUtils.getBaseName((String)hiveTypeInfo.getTypeName());
                final double minValue = ETypeConverter.getMinValue(typeName, Double.MIN_VALUE);
                final double maxValue = ETypeConverter.getMaxValue(typeName, Double.MAX_VALUE);
                switch (typeName) {
                    case "float": {
                        return new PrimitiveConverter(){

                            public void addDouble(double value) {
                                double absValue = value < 0.0 ? value * -1.0 : value;
                                int exponent = Math.getExponent(value);
                                if (absValue >= minValue && absValue <= maxValue && exponent <= 127 && exponent >= -126) {
                                    parent.set(index, (Writable)new FloatWritable((float)value));
                                } else {
                                    parent.set(index, null);
                                }
                            }
                        };
                    }
                    case "decimal": {
                        return new PrimitiveConverter(){

                            public void addDouble(double value) {
                                HiveDecimalWritable decimalWritable = new HiveDecimalWritable();
                                decimalWritable.setFromDouble(value);
                                parent.set(index, (Writable)HiveDecimalUtils.enforcePrecisionScale((HiveDecimalWritable)decimalWritable, (DecimalTypeInfo)((DecimalTypeInfo)hiveTypeInfo)));
                            }
                        };
                    }
                    case "bigint": {
                        return new PrimitiveConverter(){

                            public void addDouble(double value) {
                                if (value >= minValue && value <= maxValue && value % 1.0 == 0.0) {
                                    parent.set(index, (Writable)new LongWritable((long)value));
                                } else {
                                    parent.set(index, null);
                                }
                            }
                        };
                    }
                    case "int": {
                        return new PrimitiveConverter(){

                            public void addDouble(double value) {
                                if (value >= minValue && value <= maxValue && value % 1.0 == 0.0) {
                                    parent.set(index, (Writable)new IntWritable((int)value));
                                } else {
                                    parent.set(index, null);
                                }
                            }
                        };
                    }
                    case "smallint": {
                        return new PrimitiveConverter(){

                            public void addDouble(double value) {
                                if (value >= minValue && value <= maxValue && value % 1.0 == 0.0) {
                                    parent.set(index, (Writable)new IntWritable((int)value));
                                } else {
                                    parent.set(index, null);
                                }
                            }
                        };
                    }
                    case "tinyint": {
                        return new PrimitiveConverter(){

                            public void addDouble(double value) {
                                if (value >= minValue && value <= maxValue && value % 1.0 == 0.0) {
                                    parent.set(index, (Writable)new IntWritable((int)value));
                                } else {
                                    parent.set(index, null);
                                }
                            }
                        };
                    }
                }
                return new PrimitiveConverter(){

                    public void addDouble(double value) {
                        parent.set(index, (Writable)new DoubleWritable(value));
                    }
                };
            }
            return new PrimitiveConverter(){

                public void addDouble(double value) {
                    parent.set(index, (Writable)new DoubleWritable(value));
                }
            };
        }
    }
    ,
    EBOOLEAN_CONVERTER((Class)Boolean.TYPE){

        @Override
        PrimitiveConverter getConverter(PrimitiveType type, final int index, final ConverterParent parent, TypeInfo hiveTypeInfo) {
            return new PrimitiveConverter(){

                public void addBoolean(boolean value) {
                    parent.set(index, (Writable)new BooleanWritable(value));
                }
            };
        }
    }
    ,
    EFLOAT_CONVERTER((Class)Float.TYPE){

        @Override
        PrimitiveConverter getConverter(PrimitiveType type, final int index, final ConverterParent parent, final TypeInfo hiveTypeInfo) {
            if (hiveTypeInfo != null) {
                String typeName = TypeInfoUtils.getBaseName((String)hiveTypeInfo.getTypeName());
                final double minValue = ETypeConverter.getMinValue(typeName, Double.MIN_VALUE);
                final double maxValue = ETypeConverter.getMaxValue(typeName, Double.MAX_VALUE);
                switch (typeName) {
                    case "double": {
                        return new PrimitiveConverter(){

                            public void addFloat(float value) {
                                parent.set(index, (Writable)new DoubleWritable((double)value));
                            }
                        };
                    }
                    case "decimal": {
                        return new PrimitiveConverter(){

                            public void addFloat(float value) {
                                HiveDecimalWritable decimalWritable = new HiveDecimalWritable();
                                decimalWritable.setFromDouble((double)value);
                                parent.set(index, (Writable)HiveDecimalUtils.enforcePrecisionScale((HiveDecimalWritable)decimalWritable, (DecimalTypeInfo)((DecimalTypeInfo)hiveTypeInfo)));
                            }
                        };
                    }
                    case "bigint": {
                        return new PrimitiveConverter(){

                            public void addFloat(float value) {
                                if ((double)value >= minValue && (double)value <= maxValue && value % 1.0f == 0.0f) {
                                    parent.set(index, (Writable)new LongWritable((long)value));
                                } else {
                                    parent.set(index, null);
                                }
                            }
                        };
                    }
                    case "int": {
                        return new PrimitiveConverter(){

                            public void addFloat(float value) {
                                if ((double)value >= minValue && (double)value <= maxValue && value % 1.0f == 0.0f) {
                                    parent.set(index, (Writable)new IntWritable((int)value));
                                } else {
                                    parent.set(index, null);
                                }
                            }
                        };
                    }
                    case "smallint": {
                        return new PrimitiveConverter(){

                            public void addFloat(float value) {
                                if ((double)value >= minValue && (double)value <= maxValue && value % 1.0f == 0.0f) {
                                    parent.set(index, (Writable)new IntWritable((int)value));
                                } else {
                                    parent.set(index, null);
                                }
                            }
                        };
                    }
                    case "tinyint": {
                        return new PrimitiveConverter(){

                            public void addFloat(float value) {
                                if ((double)value >= minValue && (double)value <= maxValue && value % 1.0f == 0.0f) {
                                    parent.set(index, (Writable)new IntWritable((int)value));
                                } else {
                                    parent.set(index, null);
                                }
                            }
                        };
                    }
                }
                return new PrimitiveConverter(){

                    public void addFloat(float value) {
                        parent.set(index, (Writable)new FloatWritable(value));
                    }
                };
            }
            return new PrimitiveConverter(){

                public void addFloat(float value) {
                    parent.set(index, (Writable)new FloatWritable(value));
                }
            };
        }
    }
    ,
    EINT32_CONVERTER((Class)Integer.TYPE){

        @Override
        PrimitiveConverter getConverter(final PrimitiveType type, final int index, final ConverterParent parent, final TypeInfo hiveTypeInfo) {
            if (hiveTypeInfo != null) {
                String typeName = TypeInfoUtils.getBaseName((String)hiveTypeInfo.getTypeName());
                final long minValue = ETypeConverter.getMinValue(type, typeName, Integer.MIN_VALUE);
                final long maxValue = ETypeConverter.getMaxValue(typeName, Integer.MAX_VALUE);
                switch (typeName) {
                    case "bigint": {
                        return new PrimitiveConverter(){

                            public void addInt(int value) {
                                if ((long)value >= minValue) {
                                    parent.set(index, (Writable)new LongWritable((long)value));
                                } else {
                                    parent.set(index, null);
                                }
                            }
                        };
                    }
                    case "float": {
                        return new PrimitiveConverter(){

                            public void addInt(int value) {
                                if ((long)value >= minValue) {
                                    parent.set(index, (Writable)new FloatWritable((float)value));
                                } else {
                                    parent.set(index, null);
                                }
                            }
                        };
                    }
                    case "double": {
                        return new PrimitiveConverter(){

                            public void addInt(int value) {
                                if ((long)value >= minValue) {
                                    parent.set(index, (Writable)new DoubleWritable((double)value));
                                } else {
                                    parent.set(index, null);
                                }
                            }
                        };
                    }
                    case "decimal": {
                        return new PrimitiveConverter(){

                            public void addInt(int value) {
                                if ((long)value >= minValue) {
                                    parent.set(index, (Writable)HiveDecimalUtils.enforcePrecisionScale((HiveDecimalWritable)new HiveDecimalWritable((long)value), (DecimalTypeInfo)((DecimalTypeInfo)hiveTypeInfo)));
                                } else {
                                    parent.set(index, null);
                                }
                            }
                        };
                    }
                    case "smallint": {
                        return new PrimitiveConverter(){

                            public void addInt(int value) {
                                if ((long)value >= minValue && (long)value <= maxValue) {
                                    parent.set(index, (Writable)new IntWritable(value));
                                } else {
                                    parent.set(index, null);
                                }
                            }
                        };
                    }
                    case "tinyint": {
                        return new PrimitiveConverter(){

                            public void addInt(int value) {
                                if ((long)value >= minValue && (long)value <= maxValue) {
                                    parent.set(index, (Writable)new IntWritable(value));
                                } else {
                                    parent.set(index, null);
                                }
                            }
                        };
                    }
                }
                return new PrimitiveConverter(){

                    public void addInt(int value) {
                        if ((long)value >= minValue && (long)value <= maxValue) {
                            parent.set(index, (Writable)new IntWritable(value));
                        } else {
                            parent.set(index, null);
                        }
                    }
                };
            }
            return new PrimitiveConverter(){

                public void addInt(int value) {
                    if (value >= (ETypeConverter.isUnsignedInteger(type) ? 0 : Integer.MIN_VALUE)) {
                        parent.set(index, (Writable)new IntWritable(value));
                    } else {
                        parent.set(index, null);
                    }
                }
            };
        }
    }
    ,
    EINT64_CONVERTER((Class)Long.TYPE){

        @Override
        PrimitiveConverter getConverter(final PrimitiveType type, final int index, final ConverterParent parent, final TypeInfo hiveTypeInfo) {
            if (hiveTypeInfo != null) {
                String typeName = TypeInfoUtils.getBaseName((String)hiveTypeInfo.getTypeName());
                final long minValue = ETypeConverter.getMinValue(type, typeName, Long.MIN_VALUE);
                final long maxValue = ETypeConverter.getMaxValue(typeName, Long.MAX_VALUE);
                switch (typeName) {
                    case "float": {
                        return new PrimitiveConverter(){

                            public void addLong(long value) {
                                if (value >= minValue) {
                                    parent.set(index, (Writable)new FloatWritable((float)value));
                                } else {
                                    parent.set(index, null);
                                }
                            }
                        };
                    }
                    case "double": {
                        return new PrimitiveConverter(){

                            public void addLong(long value) {
                                if (value >= minValue) {
                                    parent.set(index, (Writable)new DoubleWritable((double)value));
                                } else {
                                    parent.set(index, null);
                                }
                            }
                        };
                    }
                    case "decimal": {
                        return new PrimitiveConverter(){

                            public void addLong(long value) {
                                if (value >= minValue) {
                                    parent.set(index, (Writable)HiveDecimalUtils.enforcePrecisionScale((HiveDecimalWritable)new HiveDecimalWritable(value), (DecimalTypeInfo)((DecimalTypeInfo)hiveTypeInfo)));
                                } else {
                                    parent.set(index, null);
                                }
                            }
                        };
                    }
                    case "int": {
                        return new PrimitiveConverter(){

                            public void addLong(long value) {
                                if (value >= minValue && value <= maxValue) {
                                    parent.set(index, (Writable)new IntWritable((int)value));
                                } else {
                                    parent.set(index, null);
                                }
                            }
                        };
                    }
                    case "smallint": {
                        return new PrimitiveConverter(){

                            public void addLong(long value) {
                                if (value >= minValue && value <= maxValue) {
                                    parent.set(index, (Writable)new IntWritable((int)value));
                                } else {
                                    parent.set(index, null);
                                }
                            }
                        };
                    }
                    case "tinyint": {
                        return new PrimitiveConverter(){

                            public void addLong(long value) {
                                if (value >= minValue && value <= maxValue) {
                                    parent.set(index, (Writable)new IntWritable((int)value));
                                } else {
                                    parent.set(index, null);
                                }
                            }
                        };
                    }
                    case "timestamp": 
                    case "timestamp with local time zone": {
                        if (type.getLogicalTypeAnnotation() instanceof LogicalTypeAnnotation.TimestampLogicalTypeAnnotation) {
                            final LogicalTypeAnnotation.TimestampLogicalTypeAnnotation logicalType = (LogicalTypeAnnotation.TimestampLogicalTypeAnnotation)type.getLogicalTypeAnnotation();
                            return new PrimitiveConverter(){

                                public void addLong(long value) {
                                    Timestamp timestamp = ParquetTimestampUtils.getTimestamp(value, logicalType.getUnit(), logicalType.isAdjustedToUTC());
                                    parent.set(index, (Writable)new TimestampWritableV2(timestamp));
                                }
                            };
                        }
                        throw new IllegalStateException("Cannot reliably convert INT64 value to timestamp without type annotation");
                    }
                }
                return new PrimitiveConverter(){

                    public void addLong(long value) {
                        if (value >= minValue) {
                            parent.set(index, (Writable)new LongWritable(value));
                        } else {
                            parent.set(index, null);
                        }
                    }
                };
            }
            return new PrimitiveConverter(){

                public void addLong(long value) {
                    if (value >= (ETypeConverter.isUnsignedInteger(type) ? 0L : Long.MIN_VALUE)) {
                        parent.set(index, (Writable)new LongWritable(value));
                    } else {
                        parent.set(index, null);
                    }
                }
            };
        }
    }
    ,
    EBINARY_CONVERTER((Class)Binary.class){

        @Override
        PrimitiveConverter getConverter(PrimitiveType type, int index, ConverterParent parent, TypeInfo hiveTypeInfo) {
            return new BinaryConverter<BytesWritable>(type, parent, index){

                @Override
                protected BytesWritable convert(Binary binary) {
                    return new BytesWritable(binary.getBytes());
                }
            };
        }
    }
    ,
    ESTRING_CONVERTER((Class)String.class){

        @Override
        PrimitiveConverter getConverter(PrimitiveType type, int index, ConverterParent parent, final TypeInfo hiveTypeInfo) {
            if (hiveTypeInfo instanceof PrimitiveTypeInfo) {
                PrimitiveTypeInfo t = (PrimitiveTypeInfo)hiveTypeInfo;
                switch (t.getPrimitiveCategory()) {
                    case CHAR: {
                        return new BinaryConverter<HiveCharWritable>(type, parent, index){

                            @Override
                            protected HiveCharWritable convert(Binary binary) {
                                return new HiveCharWritable(binary.getBytes(), ((CharTypeInfo)hiveTypeInfo).getLength());
                            }
                        };
                    }
                    case VARCHAR: {
                        return new BinaryConverter<HiveVarcharWritable>(type, parent, index){

                            @Override
                            protected HiveVarcharWritable convert(Binary binary) {
                                return new HiveVarcharWritable(binary.getBytes(), ((VarcharTypeInfo)hiveTypeInfo).getLength());
                            }
                        };
                    }
                }
            }
            return new BinaryConverter<Text>(type, parent, index){

                @Override
                protected Text convert(Binary binary) {
                    return new Text(binary.getBytes());
                }
            };
        }
    }
    ,
    EDECIMAL_CONVERTER((Class)BigDecimal.class){

        @Override
        PrimitiveConverter getConverter(final PrimitiveType type, final int index, final ConverterParent parent, final TypeInfo hiveTypeInfo) {
            if (hiveTypeInfo != null) {
                String typeName = TypeInfoUtils.getBaseName((String)hiveTypeInfo.getTypeName());
                final double minValue = ETypeConverter.getMinValue(typeName, Double.MIN_VALUE);
                final double maxValue = ETypeConverter.getMaxValue(typeName, Double.MAX_VALUE);
                switch (typeName) {
                    case "float": {
                        return new PrimitiveConverter(){

                            public void addBinary(Binary value) {
                                HiveDecimalWritable decimalWritable = new HiveDecimalWritable(value.getBytes(), this.getScale(type));
                                this.setValue(decimalWritable.doubleValue(), decimalWritable.floatValue());
                            }

                            public void addInt(int value) {
                                HiveDecimal hiveDecimal = HiveDecimal.create((long)value, (int)this.getScale(type));
                                this.setValue(hiveDecimal.doubleValue(), hiveDecimal.floatValue());
                            }

                            public void addLong(long value) {
                                HiveDecimal hiveDecimal = HiveDecimal.create((long)value, (int)this.getScale(type));
                                this.setValue(hiveDecimal.doubleValue(), hiveDecimal.floatValue());
                            }

                            private void setValue(double doubleValue, float floatValue) {
                                double absDoubleValue;
                                double d = absDoubleValue = doubleValue < 0.0 ? doubleValue * -1.0 : doubleValue;
                                if (absDoubleValue >= minValue && absDoubleValue <= maxValue || absDoubleValue == 0.0) {
                                    parent.set(index, (Writable)new FloatWritable(floatValue));
                                } else {
                                    parent.set(index, null);
                                }
                            }

                            private int getScale(PrimitiveType type2) {
                                LogicalTypeAnnotation.DecimalLogicalTypeAnnotation logicalType = (LogicalTypeAnnotation.DecimalLogicalTypeAnnotation)type2.getLogicalTypeAnnotation();
                                return logicalType.getScale();
                            }
                        };
                    }
                    case "double": {
                        return new PrimitiveConverter(){

                            public void addBinary(Binary value) {
                                HiveDecimalWritable decimalWritable = new HiveDecimalWritable(value.getBytes(), this.getScale(type));
                                parent.set(index, (Writable)new DoubleWritable(decimalWritable.doubleValue()));
                            }

                            public void addInt(int value) {
                                HiveDecimal hiveDecimal = HiveDecimal.create((long)value, (int)this.getScale(type));
                                parent.set(index, (Writable)new DoubleWritable(hiveDecimal.doubleValue()));
                            }

                            public void addLong(long value) {
                                HiveDecimal hiveDecimal = HiveDecimal.create((long)value, (int)this.getScale(type));
                                parent.set(index, (Writable)new DoubleWritable(hiveDecimal.doubleValue()));
                            }

                            private int getScale(PrimitiveType type2) {
                                LogicalTypeAnnotation.DecimalLogicalTypeAnnotation logicalType = (LogicalTypeAnnotation.DecimalLogicalTypeAnnotation)type2.getLogicalTypeAnnotation();
                                return logicalType.getScale();
                            }
                        };
                    }
                    case "bigint": {
                        return new PrimitiveConverter(){

                            public void addBinary(Binary value) {
                                HiveDecimalWritable decimalWritable = new HiveDecimalWritable(value.getBytes(), this.getScale(type));
                                this.setValue(decimalWritable.doubleValue(), decimalWritable.longValue());
                            }

                            public void addInt(int value) {
                                HiveDecimal hiveDecimal = HiveDecimal.create((long)value, (int)this.getScale(type));
                                this.setValue(hiveDecimal.doubleValue(), hiveDecimal.longValue());
                            }

                            public void addLong(long value) {
                                HiveDecimal hiveDecimal = HiveDecimal.create((long)value, (int)this.getScale(type));
                                this.setValue(hiveDecimal.doubleValue(), hiveDecimal.longValue());
                            }

                            private void setValue(double doubleValue, long longValue) {
                                if (doubleValue >= minValue && doubleValue <= maxValue && doubleValue % 1.0 == 0.0) {
                                    parent.set(index, (Writable)new LongWritable(longValue));
                                } else {
                                    parent.set(index, null);
                                }
                            }

                            private int getScale(PrimitiveType type2) {
                                LogicalTypeAnnotation.DecimalLogicalTypeAnnotation logicalType = (LogicalTypeAnnotation.DecimalLogicalTypeAnnotation)type2.getLogicalTypeAnnotation();
                                return logicalType.getScale();
                            }
                        };
                    }
                    case "int": 
                    case "smallint": 
                    case "tinyint": {
                        return new PrimitiveConverter(){

                            public void addBinary(Binary value) {
                                HiveDecimalWritable decimalWritable = new HiveDecimalWritable(value.getBytes(), this.getScale(type));
                                this.setValue(decimalWritable.doubleValue(), decimalWritable.intValue());
                            }

                            public void addInt(int value) {
                                HiveDecimal hiveDecimal = HiveDecimal.create((long)value, (int)this.getScale(type));
                                this.setValue(hiveDecimal.doubleValue(), hiveDecimal.intValue());
                            }

                            public void addLong(long value) {
                                HiveDecimal hiveDecimal = HiveDecimal.create((long)value, (int)this.getScale(type));
                                this.setValue(hiveDecimal.doubleValue(), hiveDecimal.intValue());
                            }

                            private void setValue(double doubleValue, int intValue) {
                                if (doubleValue >= minValue && doubleValue <= maxValue && doubleValue % 1.0 == 0.0) {
                                    parent.set(index, (Writable)new IntWritable(intValue));
                                } else {
                                    parent.set(index, null);
                                }
                            }

                            private int getScale(PrimitiveType type2) {
                                LogicalTypeAnnotation.DecimalLogicalTypeAnnotation logicalType = (LogicalTypeAnnotation.DecimalLogicalTypeAnnotation)type2.getLogicalTypeAnnotation();
                                return logicalType.getScale();
                            }
                        };
                    }
                    case "char": {
                        return new BinaryConverterForDecimalType<HiveCharWritable>(type, parent, index, hiveTypeInfo){

                            @Override
                            protected HiveCharWritable convert(Binary binary) {
                                return new HiveCharWritable(this.convertToBytes(binary), ((CharTypeInfo)hiveTypeInfo).getLength());
                            }
                        };
                    }
                    case "varchar": {
                        return new BinaryConverterForDecimalType<HiveVarcharWritable>(type, parent, index, hiveTypeInfo){

                            @Override
                            protected HiveVarcharWritable convert(Binary binary) {
                                return new HiveVarcharWritable(this.convertToBytes(binary), ((VarcharTypeInfo)hiveTypeInfo).getLength());
                            }
                        };
                    }
                    case "string": {
                        return new BinaryConverterForDecimalType<BytesWritable>(type, parent, index, hiveTypeInfo){

                            @Override
                            protected BytesWritable convert(Binary binary) {
                                return new BytesWritable(this.convertToBytes(binary));
                            }
                        };
                    }
                }
                return new BinaryConverter<HiveDecimalWritable>(type, parent, index, hiveTypeInfo){

                    @Override
                    protected HiveDecimalWritable convert(Binary binary) {
                        LogicalTypeAnnotation.DecimalLogicalTypeAnnotation logicalType = (LogicalTypeAnnotation.DecimalLogicalTypeAnnotation)this.type.getLogicalTypeAnnotation();
                        return HiveDecimalUtils.enforcePrecisionScale((HiveDecimalWritable)new HiveDecimalWritable(binary.getBytes(), logicalType.getScale()), (DecimalTypeInfo)((DecimalTypeInfo)hiveTypeInfo));
                    }

                    @Override
                    public boolean hasDictionarySupport() {
                        return false;
                    }

                    public void addInt(int value) {
                        this.addDecimal(value);
                    }

                    public void addLong(long value) {
                        this.addDecimal(value);
                    }

                    private void addDecimal(long value) {
                        DecimalTypeInfo decimalInfo = (DecimalTypeInfo)hiveTypeInfo;
                        HiveDecimal hiveDecimal = HiveDecimal.create((long)value, (int)decimalInfo.scale());
                        HiveDecimalWritable result = HiveDecimalUtils.enforcePrecisionScale((HiveDecimalWritable)new HiveDecimalWritable(hiveDecimal), (DecimalTypeInfo)((DecimalTypeInfo)hiveTypeInfo));
                        parent.set(index, (Writable)result);
                    }
                };
            }
            return new BinaryConverter<HiveDecimalWritable>(type, parent, index){

                @Override
                protected HiveDecimalWritable convert(Binary binary) {
                    LogicalTypeAnnotation.DecimalLogicalTypeAnnotation logicalType = (LogicalTypeAnnotation.DecimalLogicalTypeAnnotation)this.type.getLogicalTypeAnnotation();
                    return new HiveDecimalWritable(binary.getBytes(), logicalType.getScale());
                }
            };
        }
    }
    ,
    EINT96_TIMESTAMP_CONVERTER((Class)TimestampWritableV2.class){

        @Override
        PrimitiveConverter getConverter(PrimitiveType type, int index, final ConverterParent parent, TypeInfo hiveTypeInfo) {
            if (hiveTypeInfo != null) {
                String typeName;
                switch (typeName = TypeInfoUtils.getBaseName((String)hiveTypeInfo.getTypeName())) {
                    case "bigint": {
                        return new BinaryConverter<LongWritable>(type, parent, index){

                            @Override
                            protected LongWritable convert(Binary binary) {
                                Preconditions.checkArgument((binary.length() == 12 ? 1 : 0) != 0, (String)"Must be 12 bytes");
                                ByteBuffer buf = binary.toByteBuffer();
                                buf.order(ByteOrder.LITTLE_ENDIAN);
                                long longVal = buf.getLong();
                                return new LongWritable(longVal);
                            }
                        };
                    }
                }
            }
            return new BinaryConverter<TimestampWritableV2>(type, parent, index){

                @Override
                protected TimestampWritableV2 convert(Binary binary) {
                    NanoTime nt = NanoTime.fromBinary(binary);
                    Map<String, String> metadata = parent.getMetadata();
                    boolean skipConversion = Boolean.parseBoolean(metadata.get(HiveConf.ConfVars.HIVE_PARQUET_TIMESTAMP_SKIP_CONVERSION.varname));
                    String legacyConversion = metadata.get("writer.zone.conversion.legacy");
                    assert (legacyConversion != null);
                    ZoneOffset targetZone = skipConversion ? ZoneOffset.UTC : (ZoneId)MoreObjects.firstNonNull((Object)DataWritableReadSupport.getWriterTimeZoneId(metadata), (Object)TimeZone.getDefault().toZoneId());
                    Timestamp ts = NanoTimeUtils.getTimestamp(nt, targetZone, Boolean.parseBoolean(legacyConversion));
                    return new TimestampWritableV2(ts);
                }
            };
        }
    }
    ,
    EDATE_CONVERTER((Class)DateWritableV2.class){

        @Override
        PrimitiveConverter getConverter(PrimitiveType type, final int index, final ConverterParent parent, TypeInfo hiveTypeInfo) {
            return new PrimitiveConverter(){

                public void addInt(int value) {
                    Map<String, String> metadata = parent.getMetadata();
                    Boolean skipProlepticConversion = DataWritableReadSupport.getWriterDateProleptic(metadata);
                    if (skipProlepticConversion == null) {
                        skipProlepticConversion = Boolean.parseBoolean(metadata.get(HiveConf.ConfVars.HIVE_PARQUET_DATE_PROLEPTIC_GREGORIAN_DEFAULT.varname));
                    }
                    parent.set(index, (Writable)new DateWritableV2(skipProlepticConversion != false ? value : CalendarUtils.convertDateToProleptic((int)value)));
                }
            };
        }
    };

    final Class<?> _type;

    private ETypeConverter(Class<?> type) {
        this._type = type;
    }

    private Class<?> getType() {
        return this._type;
    }

    abstract PrimitiveConverter getConverter(PrimitiveType var1, int var2, ConverterParent var3, TypeInfo var4);

    public static PrimitiveConverter getNewConverter(final PrimitiveType type, final int index, final ConverterParent parent, final TypeInfo hiveTypeInfo) {
        Optional converter;
        if (type.isPrimitive() && type.asPrimitiveType().getPrimitiveTypeName().equals((Object)PrimitiveType.PrimitiveTypeName.INT96)) {
            return EINT96_TIMESTAMP_CONVERTER.getConverter(type, index, parent, hiveTypeInfo);
        }
        if (type.getLogicalTypeAnnotation() != null && (converter = type.getLogicalTypeAnnotation().accept((LogicalTypeAnnotation.LogicalTypeAnnotationVisitor)new LogicalTypeAnnotation.LogicalTypeAnnotationVisitor<PrimitiveConverter>(){

            public Optional<PrimitiveConverter> visit(LogicalTypeAnnotation.DecimalLogicalTypeAnnotation logicalTypeAnnotation) {
                return Optional.of(EDECIMAL_CONVERTER.getConverter(type, index, parent, hiveTypeInfo));
            }

            public Optional<PrimitiveConverter> visit(LogicalTypeAnnotation.StringLogicalTypeAnnotation logicalTypeAnnotation) {
                return Optional.of(ESTRING_CONVERTER.getConverter(type, index, parent, hiveTypeInfo));
            }

            public Optional<PrimitiveConverter> visit(LogicalTypeAnnotation.DateLogicalTypeAnnotation logicalTypeAnnotation) {
                return Optional.of(EDATE_CONVERTER.getConverter(type, index, parent, hiveTypeInfo));
            }

            public Optional<PrimitiveConverter> visit(LogicalTypeAnnotation.TimestampLogicalTypeAnnotation logicalTypeAnnotation) {
                PrimitiveTypeInfo info = hiveTypeInfo == null ? TypeInfoFactory.timestampTypeInfo : hiveTypeInfo;
                return Optional.of(EINT64_CONVERTER.getConverter(type, index, parent, (TypeInfo)info));
            }
        })).isPresent()) {
            return (PrimitiveConverter)converter.get();
        }
        Class javaType = type.getPrimitiveTypeName().javaType;
        for (ETypeConverter eConverter : ETypeConverter.values()) {
            if (eConverter.getType() != javaType) continue;
            return eConverter.getConverter(type, index, parent, hiveTypeInfo);
        }
        throw new IllegalArgumentException("Converter not found ... for type : " + type);
    }

    public static boolean isUnsignedInteger(PrimitiveType type) {
        Optional isUnsignedInteger;
        if (type.getLogicalTypeAnnotation() != null && (isUnsignedInteger = type.getLogicalTypeAnnotation().accept((LogicalTypeAnnotation.LogicalTypeAnnotationVisitor)new LogicalTypeAnnotation.LogicalTypeAnnotationVisitor<Boolean>(){

            public Optional<Boolean> visit(LogicalTypeAnnotation.IntLogicalTypeAnnotation intLogicalType) {
                return Optional.of(!intLogicalType.isSigned());
            }
        })).isPresent()) {
            return (Boolean)isUnsignedInteger.get();
        }
        return false;
    }

    private static long getMinValue(PrimitiveType type, String typeName, long defaultValue) {
        if (ETypeConverter.isUnsignedInteger(type)) {
            return 0L;
        }
        switch (typeName) {
            case "int": {
                return Integer.MIN_VALUE;
            }
            case "smallint": {
                return -32768L;
            }
            case "tinyint": {
                return -128L;
            }
        }
        return defaultValue;
    }

    private static long getMaxValue(String typeName, long defaultValue) {
        switch (typeName) {
            case "int": {
                return Integer.MAX_VALUE;
            }
            case "smallint": {
                return 32767L;
            }
            case "tinyint": {
                return 127L;
            }
        }
        return defaultValue;
    }

    private static double getMinValue(String typeName, double defaultValue) {
        switch (typeName) {
            case "bigint": {
                return -9.223372036854776E18;
            }
            case "int": {
                return -2.147483648E9;
            }
            case "smallint": {
                return -32768.0;
            }
            case "tinyint": {
                return -128.0;
            }
            case "float": {
                return 1.4E-45f;
            }
        }
        return defaultValue;
    }

    private static double getMaxValue(String typeName, double defaultValue) {
        switch (typeName) {
            case "bigint": {
                return 9.223372036854776E18;
            }
            case "int": {
                return 2.147483647E9;
            }
            case "smallint": {
                return 32767.0;
            }
            case "tinyint": {
                return 127.0;
            }
            case "float": {
                return 3.4028234663852886E38;
            }
        }
        return defaultValue;
    }

    public static abstract class BinaryConverterForDecimalType<T extends Writable>
    extends BinaryConverter<T> {
        public BinaryConverterForDecimalType(PrimitiveType type, ConverterParent parent, int index, TypeInfo hiveTypeInfo) {
            super(type, parent, index, hiveTypeInfo);
        }

        protected byte[] convertToBytes(Binary binary) {
            LogicalTypeAnnotation.DecimalLogicalTypeAnnotation logicalType = (LogicalTypeAnnotation.DecimalLogicalTypeAnnotation)this.type.getLogicalTypeAnnotation();
            return HiveDecimalUtils.enforcePrecisionScale((HiveDecimalWritable)new HiveDecimalWritable(binary.getBytes(), logicalType.getScale()), (DecimalTypeInfo)new DecimalTypeInfo(logicalType.getPrecision(), logicalType.getScale())).toString().getBytes();
        }
    }

    public static abstract class BinaryConverter<T extends Writable>
    extends PrimitiveConverter {
        protected final PrimitiveType type;
        private final ConverterParent parent;
        private final int index;
        private final TypeInfo hiveTypeInfo;
        private ArrayList<T> lookupTable;

        public BinaryConverter(PrimitiveType type, ConverterParent parent, int index, TypeInfo hiveTypeInfo) {
            this.type = type;
            this.parent = parent;
            this.index = index;
            this.hiveTypeInfo = hiveTypeInfo;
        }

        public BinaryConverter(PrimitiveType type, ConverterParent parent, int index) {
            this(type, parent, index, null);
        }

        protected abstract T convert(Binary var1);

        public boolean hasDictionarySupport() {
            return true;
        }

        public void setDictionary(Dictionary dictionary) {
            int length = dictionary.getMaxId() + 1;
            this.lookupTable = new ArrayList();
            for (int i = 0; i < length; ++i) {
                this.lookupTable.add(this.convert(dictionary.decodeToBinary(i)));
            }
        }

        public void addValueFromDictionary(int dictionaryId) {
            this.parent.set(this.index, (Writable)this.lookupTable.get(dictionaryId));
        }

        public void addBinary(Binary value) {
            this.parent.set(this.index, (Writable)this.convert(value));
        }
    }
}

