/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.io;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.mapred.JobConf;

public final class SyntheticFileId
implements Writable {
    private static final String JOBCONF_KEY = "SYNTHETIC_FILE_ID";
    private static final Pattern STRING_PATTERN = Pattern.compile("\\[(-?\\d+),\\s(-?\\d+),\\s(\\d+)\\]");
    private long pathHash;
    private long modTime;
    private long length;
    private static final short THREE_LONGS = 24;

    public SyntheticFileId() {
    }

    public SyntheticFileId(Path path, long len, long modificationTime) {
        this.pathHash = this.hashCode(path.toUri().getPath());
        this.modTime = modificationTime;
        this.length = len;
    }

    private SyntheticFileId(String fileIdAsString) {
        Matcher matcher = STRING_PATTERN.matcher(fileIdAsString);
        if (!matcher.matches()) {
            throw new IllegalArgumentException("Expected format " + STRING_PATTERN + " but got " + fileIdAsString);
        }
        this.pathHash = Long.parseLong(matcher.group(1));
        this.modTime = Long.parseLong(matcher.group(2));
        this.length = Long.parseLong(matcher.group(3));
    }

    public SyntheticFileId(FileStatus file) {
        this(file.getPath(), file.getLen(), file.getModificationTime());
    }

    public String toString() {
        return "[" + this.pathHash + ", " + this.modTime + ", " + this.length + "]";
    }

    public int hashCode() {
        int prime = 31;
        int result = 31 + (int)(this.length ^ this.length >>> 32);
        result = 31 * result + (int)(this.modTime ^ this.modTime >>> 32);
        return 31 * result + (int)(this.pathHash ^ this.pathHash >>> 32);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof SyntheticFileId)) {
            return false;
        }
        SyntheticFileId other = (SyntheticFileId)obj;
        return this.length == other.length && this.modTime == other.modTime && this.pathHash == other.pathHash;
    }

    private long hashCode(String path) {
        long h = 0L;
        for (int i = 0; i < path.length(); ++i) {
            h = 1223L * h + (long)path.charAt(i);
        }
        return h;
    }

    public void write(DataOutput out) throws IOException {
        out.writeShort(24);
        out.writeLong(this.pathHash);
        out.writeLong(this.modTime);
        out.writeLong(this.length);
    }

    public void readFields(DataInput in) throws IOException {
        short len = in.readShort();
        if (len < 24) {
            throw new IOException("Need at least 24 bytes");
        }
        this.pathHash = in.readLong();
        this.modTime = in.readLong();
        this.length = in.readLong();
        int extraBytes = len - 24;
        if (extraBytes > 0) {
            in.skipBytes(extraBytes);
        }
    }

    public long getPathHash() {
        return this.pathHash;
    }

    public long getModTime() {
        return this.modTime;
    }

    public long getLength() {
        return this.length;
    }

    public void toJobConf(JobConf job) {
        job.set(JOBCONF_KEY, this.toString());
    }

    public static SyntheticFileId fromJobConf(JobConf job) {
        String idAsString = job.get(JOBCONF_KEY);
        if (idAsString == null) {
            return null;
        }
        return new SyntheticFileId(idAsString);
    }
}

