/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.hooks;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.metastore.api.Catalog;
import org.apache.hadoop.hive.metastore.api.DataConnector;
import org.apache.hadoop.hive.metastore.api.Database;
import org.apache.hadoop.hive.ql.hooks.Entity;
import org.apache.hadoop.hive.ql.metadata.Partition;
import org.apache.hadoop.hive.ql.metadata.Table;

public class ReadEntity
extends Entity
implements Serializable {
    private boolean isDirect = true;
    private boolean needsLock = true;
    private boolean isUpdateOrDelete = false;
    public transient boolean isFromTopLevelQuery = true;
    private final Set<ReadEntity> parents = new LinkedHashSet<ReadEntity>();
    private final List<String> accessedColumns = new ArrayList<String>();

    public ReadEntity() {
    }

    public ReadEntity(Catalog catalog) {
        super(catalog, true);
    }

    public ReadEntity(Database database) {
        super(database, true);
    }

    public ReadEntity(DataConnector connector) {
        super(connector, true);
    }

    public ReadEntity(Table t) {
        super(t, true);
    }

    private void initParent(ReadEntity parent) {
        if (parent != null) {
            this.parents.add(parent);
        }
    }

    public ReadEntity(Table t, ReadEntity parent) {
        super(t, true);
        this.initParent(parent);
    }

    public ReadEntity(Table t, ReadEntity parent, boolean isDirect) {
        this(t, parent);
        this.isDirect = isDirect;
    }

    public ReadEntity(Database db, String objName, String className, Entity.Type type) {
        super(db, objName, className, type);
    }

    public ReadEntity(Partition p) {
        super(p, true);
    }

    public ReadEntity(Partition p, ReadEntity parent) {
        super(p, true);
        this.initParent(parent);
    }

    public ReadEntity(Partition p, ReadEntity parent, boolean isDirect) {
        this(p, parent);
        this.isDirect = isDirect;
    }

    public ReadEntity(Path d, boolean islocal) {
        super(d, islocal, true);
    }

    public Set<ReadEntity> getParents() {
        return this.parents;
    }

    @Override
    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (o instanceof ReadEntity) {
            ReadEntity ore = (ReadEntity)o;
            return this.getName().equalsIgnoreCase(ore.getName());
        }
        return false;
    }

    public boolean isDirect() {
        return this.isDirect;
    }

    public void setDirect(boolean isDirect) {
        this.isDirect = isDirect;
    }

    public boolean needsLock() {
        return this.needsLock;
    }

    public void noLockNeeded() {
        this.needsLock = false;
    }

    public List<String> getAccessedColumns() {
        return this.accessedColumns;
    }

    public void setUpdateOrDelete(boolean isUpdateOrDelete) {
        this.isUpdateOrDelete = isUpdateOrDelete;
    }

    public boolean isUpdateOrDelete() {
        return this.isUpdateOrDelete;
    }
}

