/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.hooks;

import java.util.Map;
import javax.annotation.Nullable;
import org.apache.hadoop.hive.ql.exec.ExplainTask;
import org.apache.hadoop.hive.ql.exec.TaskFactory;
import org.apache.hadoop.hive.ql.hooks.HiveProtoLoggingHook;
import org.apache.hadoop.hive.ql.hooks.proto.HiveHookEvents;
import org.apache.hadoop.hive.ql.plan.ExplainWork;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HiveHookEventProtoPartialBuilder {
    private static final Logger LOG = LoggerFactory.getLogger((String)HiveHookEventProtoPartialBuilder.class.getName());
    private final HiveHookEvents.HiveHookEventProto event;
    @Nullable
    private final ExplainWork explainWork;
    private final Map<HiveProtoLoggingHook.OtherInfoType, JSONObject> otherInfo;
    private final String queryStr;
    private final String stageIdRearrange;

    public HiveHookEventProtoPartialBuilder(HiveHookEvents.HiveHookEventProto.Builder builder, ExplainWork explainWork, Map<HiveProtoLoggingHook.OtherInfoType, JSONObject> otherInfo, String queryStr, String stageIdRearrange) {
        this.event = builder.buildPartial();
        this.explainWork = explainWork;
        this.otherInfo = otherInfo;
        this.queryStr = queryStr;
        this.stageIdRearrange = stageIdRearrange;
    }

    public HiveHookEvents.HiveHookEventProto build() {
        if (this.explainWork != null) {
            this.addQueryObj(this.explainWork);
        }
        HiveHookEvents.HiveHookEventProto.Builder builder = HiveHookEvents.HiveHookEventProto.newBuilder();
        for (Map.Entry<HiveProtoLoggingHook.OtherInfoType, JSONObject> each : this.otherInfo.entrySet()) {
            HiveProtoLoggingHook.OtherInfoType type = each.getKey();
            JSONObject json = each.getValue();
            try {
                HiveProtoLoggingHook.EventLogger.addMapEntry(builder, type, json.toString());
            }
            catch (Exception e) {
                LOG.error("Unexpected exception while serializing json.", (Throwable)e);
            }
        }
        return builder.mergeFrom(this.event).build();
    }

    private void addQueryObj(ExplainWork explainWork) {
        try {
            JSONObject queryObj = new JSONObject();
            queryObj.put("queryText", (Object)this.queryStr);
            queryObj.put("queryPlan", (Object)this.getExplainJSON(explainWork));
            this.otherInfo.put(HiveProtoLoggingHook.OtherInfoType.QUERY, queryObj);
        }
        catch (Exception e) {
            LOG.error("Unexpected exception while serializing json.", (Throwable)e);
        }
    }

    private JSONObject getExplainJSON(ExplainWork explainWork) throws Exception {
        ExplainTask explain = (ExplainTask)TaskFactory.get(explainWork, null);
        return explain.getJSONPlan(null, explainWork, this.stageIdRearrange);
    }
}

