/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.vector.mapjoin.optimized;

import java.io.IOException;
import java.util.Properties;
import org.apache.hadoop.hive.ql.exec.vector.mapjoin.optimized.VectorMapJoinOptimizedHashTable;
import org.apache.hadoop.hive.ql.plan.TableDesc;
import org.apache.hadoop.hive.serde2.ByteStream;
import org.apache.hadoop.hive.serde2.binarysortable.fast.BinarySortableSerializeWrite;

public class VectorMapJoinOptimizedStringCommon {
    private BinarySortableSerializeWrite keyBinarySortableSerializeWrite;
    private transient ByteStream.Output output;
    private transient VectorMapJoinOptimizedHashTable.SerializedBytes serializedBytes;
    private transient TableDesc tableDesc;

    public VectorMapJoinOptimizedHashTable.SerializedBytes serialize(byte[] keyBytes, int keyStart, int keyLength) throws IOException {
        this.keyBinarySortableSerializeWrite.reset();
        this.keyBinarySortableSerializeWrite.writeString(keyBytes, keyStart, keyLength);
        this.serializedBytes.bytes = this.output.getData();
        this.serializedBytes.offset = 0;
        this.serializedBytes.length = this.output.getLength();
        return this.serializedBytes;
    }

    public VectorMapJoinOptimizedStringCommon(boolean isOuterJoin, TableDesc tableDesc) {
        this.tableDesc = tableDesc;
        this.keyBinarySortableSerializeWrite = BinarySortableSerializeWrite.with((Properties)tableDesc.getProperties(), (int)1);
        this.output = new ByteStream.Output();
        this.keyBinarySortableSerializeWrite.set(this.output);
        this.serializedBytes = new VectorMapJoinOptimizedHashTable.SerializedBytes();
    }

    public TableDesc getTableDesc() {
        return this.tableDesc;
    }
}

