/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.vector.mapjoin.fast;

import com.google.common.annotations.VisibleForTesting;
import java.io.IOException;
import org.apache.hadoop.hive.ql.exec.JoinUtil;
import org.apache.hadoop.hive.ql.exec.vector.mapjoin.fast.VectorMapJoinFastHashSet;
import org.apache.hadoop.hive.ql.exec.vector.mapjoin.fast.VectorMapJoinFastLongHashTable;
import org.apache.hadoop.hive.ql.exec.vector.mapjoin.hashtable.VectorMapJoinHashSetResult;
import org.apache.hadoop.hive.ql.exec.vector.mapjoin.hashtable.VectorMapJoinLongHashSet;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.plan.TableDesc;
import org.apache.hadoop.hive.ql.plan.VectorMapJoinDesc;
import org.apache.hadoop.io.BytesWritable;
import org.apache.hive.common.util.HashCodeUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VectorMapJoinFastLongHashSet
extends VectorMapJoinFastLongHashTable
implements VectorMapJoinLongHashSet {
    public static final Logger LOG = LoggerFactory.getLogger(VectorMapJoinFastLongHashSet.class);

    @Override
    public VectorMapJoinHashSetResult createHashSetResult() {
        return new VectorMapJoinFastHashSet.HashSetResult();
    }

    @Override
    public void putRow(long hashCode, BytesWritable currentKey, BytesWritable currentValue) throws HiveException, IOException {
        this.adaptPutRow(hashCode, currentKey, currentValue);
    }

    @Override
    public boolean containsLongKey(long currentKey) {
        return this.containsKey(currentKey);
    }

    @VisibleForTesting
    public void testPutRow(long currentKey) throws HiveException, IOException {
        long hashCode = HashCodeUtil.calculateLongHashCode((long)currentKey);
        this.add(hashCode, currentKey, null);
    }

    @Override
    public void assignSlot(int slot, long key, boolean isNewKey, BytesWritable currentValue) {
        int pairIndex = 2 * slot;
        if (isNewKey) {
            this.slotPairs[pairIndex] = 1L;
            this.slotPairs[pairIndex + 1] = key;
        }
    }

    @Override
    public JoinUtil.JoinResult contains(long key, VectorMapJoinHashSetResult hashSetResult) {
        VectorMapJoinFastHashSet.HashSetResult optimizedHashSetResult = (VectorMapJoinFastHashSet.HashSetResult)hashSetResult;
        optimizedHashSetResult.forget();
        long hashCode = HashCodeUtil.calculateLongHashCode((long)key);
        int pairIndex = this.findReadSlot(key, hashCode);
        JoinUtil.JoinResult joinResult = pairIndex == -1 ? JoinUtil.JoinResult.NOMATCH : JoinUtil.JoinResult.MATCH;
        optimizedHashSetResult.setJoinResult(joinResult);
        return joinResult;
    }

    public VectorMapJoinFastLongHashSet(boolean isFullOuter, boolean minMaxEnabled, VectorMapJoinDesc.HashTableKeyType hashTableKeyType, int initialCapacity, float loadFactor, int writeBuffersSize, long estimatedKeyCount, TableDesc tableDesc) {
        super(isFullOuter, minMaxEnabled, hashTableKeyType, initialCapacity, loadFactor, writeBuffersSize, estimatedKeyCount, tableDesc);
    }

    @Override
    public long getEstimatedMemorySize() {
        return super.getEstimatedMemorySize();
    }
}

