/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.vector.expressions.gen;

import java.sql.Timestamp;
import java.util.Arrays;
import org.apache.hadoop.hive.ql.exec.vector.LongColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.TimestampColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.VectorExpressionDescriptor;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedRowBatch;
import org.apache.hadoop.hive.ql.exec.vector.expressions.VectorExpression;
import org.apache.hadoop.hive.ql.metadata.HiveException;

public class TimestampColumnBetween
extends VectorExpression {
    private static final long serialVersionUID = 1L;
    private final Timestamp leftValue;
    private final Timestamp rightValue;

    public TimestampColumnBetween() {
        this.leftValue = null;
        this.rightValue = null;
    }

    public TimestampColumnBetween(int colNum, Timestamp leftValue, Timestamp rightValue, int outputColumnNum) {
        super(colNum, outputColumnNum);
        this.leftValue = leftValue;
        this.rightValue = rightValue;
    }

    @Override
    public void evaluate(VectorizedRowBatch batch) throws HiveException {
        if (this.childExpressions != null) {
            super.evaluateChildren(batch);
        }
        TimestampColumnVector inputColVector = (TimestampColumnVector)batch.cols[this.inputColumnNum[0]];
        LongColumnVector outputColVector = (LongColumnVector)batch.cols[this.outputColumnNum];
        int[] sel = batch.selected;
        boolean[] inputIsNull = inputColVector.isNull;
        boolean[] outputIsNull = outputColVector.isNull;
        int n = batch.size;
        long[] outputVector = outputColVector.vector;
        if (n == 0) {
            return;
        }
        outputColVector.isRepeating = false;
        if (inputColVector.isRepeating) {
            if (inputColVector.noNulls || !inputIsNull[0]) {
                outputIsNull[0] = false;
                outputVector[0] = inputColVector.compareTo(0, this.leftValue) < 0 || inputColVector.compareTo(0, this.rightValue) > 0 ? 0L : 1L;
            } else {
                outputIsNull[0] = true;
                outputColVector.noNulls = false;
            }
            outputColVector.isRepeating = true;
            return;
        }
        if (inputColVector.noNulls) {
            if (batch.selectedInUse) {
                if (!outputColVector.noNulls) {
                    for (int j = 0; j != n; ++j) {
                        int i = sel[j];
                        outputIsNull[i] = false;
                        outputVector[i] = inputColVector.compareTo(i, this.leftValue) < 0 || inputColVector.compareTo(i, this.rightValue) > 0 ? 0L : 1L;
                    }
                } else {
                    for (int j = 0; j != n; ++j) {
                        int i = sel[j];
                        outputVector[i] = inputColVector.compareTo(i, this.leftValue) < 0 || inputColVector.compareTo(i, this.rightValue) > 0 ? 0L : 1L;
                    }
                }
            } else {
                if (!outputColVector.noNulls) {
                    Arrays.fill(outputIsNull, false);
                    outputColVector.noNulls = true;
                }
                for (int i = 0; i != n; ++i) {
                    outputVector[i] = inputColVector.compareTo(i, this.leftValue) < 0 || inputColVector.compareTo(i, this.rightValue) > 0 ? 0L : 1L;
                }
            }
        } else {
            outputColVector.noNulls = false;
            if (batch.selectedInUse) {
                for (int j = 0; j != n; ++j) {
                    int i = sel[j];
                    outputIsNull[i] = inputIsNull[i];
                    if (inputIsNull[i]) continue;
                    outputVector[i] = inputColVector.compareTo(i, this.leftValue) < 0 || inputColVector.compareTo(i, this.rightValue) > 0 ? 0L : 1L;
                }
            } else {
                System.arraycopy(inputIsNull, 0, outputIsNull, 0, n);
                for (int i = 0; i != n; ++i) {
                    if (inputIsNull[i]) continue;
                    outputVector[i] = inputColVector.compareTo(i, this.leftValue) < 0 || inputColVector.compareTo(i, this.rightValue) > 0 ? 0L : 1L;
                }
            }
        }
    }

    @Override
    public VectorExpressionDescriptor.Descriptor getDescriptor() {
        return null;
    }

    @Override
    public String vectorExpressionParameters() {
        return this.getColumnParamString(0, this.inputColumnNum[0]) + ", left " + this.leftValue.toString() + ", right " + this.rightValue.toString();
    }
}

