/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.vector.expressions;

import java.sql.Timestamp;
import java.time.ZoneId;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.common.type.TimestampTZUtil;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.exec.vector.TimestampColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.expressions.VectorUDFTimestampFieldTimestamp;
import org.apache.hadoop.hive.ql.metadata.HiveException;

public final class VectorUDFUnixTimeStampTimestamp
extends VectorUDFTimestampFieldTimestamp {
    private static final long serialVersionUID = 1L;
    private org.apache.hadoop.hive.common.type.Timestamp timestamp;
    private ZoneId timeZone;

    @Override
    public void transientInit(Configuration conf) throws HiveException {
        super.transientInit(conf);
        if (this.timeZone == null) {
            String timeZoneStr = HiveConf.getVar((Configuration)conf, (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_LOCAL_TIME_ZONE);
            this.timeZone = TimestampTZUtil.parseTimeZone((String)timeZoneStr);
        }
    }

    @Override
    protected long getTimestampField(TimestampColumnVector timestampColVector, int elementNum) {
        Timestamp ts = timestampColVector.asScratchTimestamp(elementNum);
        this.timestamp.setTimeInMillis(ts.getTime(), ts.getNanos());
        return TimestampTZUtil.convert((org.apache.hadoop.hive.common.type.Timestamp)this.timestamp, (ZoneId)this.timeZone).getEpochSecond();
    }

    public VectorUDFUnixTimeStampTimestamp(int colNum, int outputColumnNum) {
        super(-1, colNum, outputColumnNum);
        this.timestamp = new org.apache.hadoop.hive.common.type.Timestamp();
    }

    public VectorUDFUnixTimeStampTimestamp() {
    }
}

