/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.vector.expressions;

import com.google.common.collect.ImmutableList;
import java.nio.charset.StandardCharsets;
import java.util.List;
import org.apache.hadoop.hive.ql.exec.vector.expressions.AbstractFilterStringColLikeStringScalar;
import org.apache.hadoop.hive.ql.udf.UDFLike;

public class FilterStringColLikeStringScalar
extends AbstractFilterStringColLikeStringScalar {
    private static final long serialVersionUID = 1L;
    private static final List<AbstractFilterStringColLikeStringScalar.CheckerFactory> CHECKER_FACTORIES = ImmutableList.of(pattern -> {
        UDFLikePattern udfLike = UDFLikePattern.matcher(pattern);
        try {
            return udfLike.checker.getConstructor(String.class).newInstance(udfLike.format(pattern));
        }
        catch (Exception e) {
            throw new IllegalArgumentException("unable to initialize Checker");
        }
    });

    public FilterStringColLikeStringScalar() {
    }

    public FilterStringColLikeStringScalar(int colNum, byte[] likePattern) {
        super(colNum, null);
        super.setPattern(new String(likePattern, StandardCharsets.UTF_8));
    }

    @Override
    protected List<AbstractFilterStringColLikeStringScalar.CheckerFactory> getCheckerFactories() {
        return CHECKER_FACTORIES;
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    private static enum UDFLikePattern {
        BEGIN(AbstractFilterStringColLikeStringScalar.BeginChecker.class){

            @Override
            String format(String pattern) {
                return pattern.substring(0, pattern.length() - 1);
            }
        }
        ,
        END(AbstractFilterStringColLikeStringScalar.EndChecker.class){

            @Override
            String format(String pattern) {
                return pattern.substring(1);
            }
        }
        ,
        MIDDLE(AbstractFilterStringColLikeStringScalar.MiddleChecker.class){

            @Override
            String format(String pattern) {
                return pattern.substring(1, pattern.length() - 1);
            }
        }
        ,
        COMPLEX(AbstractFilterStringColLikeStringScalar.ComplexChecker.class){

            @Override
            String format(String pattern) {
                return "^" + UDFLike.likePatternToRegExp(pattern) + "$";
            }
        }
        ,
        CHAINED(AbstractFilterStringColLikeStringScalar.ChainedChecker.class),
        NONE(AbstractFilterStringColLikeStringScalar.NoneChecker.class);

        Class<? extends AbstractFilterStringColLikeStringScalar.Checker> checker;

        private UDFLikePattern(Class<? extends AbstractFilterStringColLikeStringScalar.Checker> checker) {
            this.checker = checker;
        }

        private static UDFLikePattern matcher(String pattern) {
            UDFLikePattern lastType = NONE;
            int length = pattern.length();
            int lastChar = 0;
            for (int i = 0; i < length; ++i) {
                char n = pattern.charAt(i);
                if (n == '_' && lastChar != 92) {
                    return COMPLEX;
                }
                if (n == '%') {
                    if (i == 0) {
                        lastType = END;
                    } else if (i < length - 1) {
                        if (lastChar != 92) {
                            lastType = CHAINED;
                        }
                    } else if (lastChar != 92) {
                        if (lastType == END) {
                            lastType = MIDDLE;
                        } else if (lastType != CHAINED) {
                            lastType = BEGIN;
                        }
                    }
                }
                lastChar = n;
            }
            return lastType;
        }

        String format(String pattern) {
            return pattern;
        }
    }
}

