/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.vector;

import com.google.common.base.Preconditions;
import java.io.IOException;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.stream.IntStream;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.common.type.DataTypePhysicalVariation;
import org.apache.hadoop.hive.common.type.Date;
import org.apache.hadoop.hive.common.type.HiveChar;
import org.apache.hadoop.hive.common.type.HiveDecimal;
import org.apache.hadoop.hive.common.type.HiveIntervalDayTime;
import org.apache.hadoop.hive.common.type.HiveIntervalYearMonth;
import org.apache.hadoop.hive.common.type.Timestamp;
import org.apache.hadoop.hive.ql.exec.Utilities;
import org.apache.hadoop.hive.ql.exec.vector.BytesColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.ColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.Decimal64ColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.DecimalColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.DoubleColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.IntervalDayTimeColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.LongColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.StructColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.TimestampColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedBatchUtil;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedRowBatch;
import org.apache.hadoop.hive.ql.io.BucketIdentifier;
import org.apache.hadoop.hive.ql.io.HiveFileFormatUtils;
import org.apache.hadoop.hive.ql.io.IOPrepareCache;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.metadata.VirtualColumn;
import org.apache.hadoop.hive.ql.plan.MapWork;
import org.apache.hadoop.hive.ql.plan.PartitionDesc;
import org.apache.hadoop.hive.serde2.io.DateWritableV2;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorConverters;
import org.apache.hadoop.hive.serde2.objectinspector.StructObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.PrimitiveObjectInspectorFactory;
import org.apache.hadoop.hive.serde2.typeinfo.CharTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.PrimitiveTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoUtils;
import org.apache.hadoop.mapred.FileSplit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VectorizedRowBatchCtx {
    private static final long serialVersionUID = 1L;
    private static final Logger LOG = LoggerFactory.getLogger((String)VectorizedRowBatchCtx.class.getName());
    private String[] rowColumnNames;
    private TypeInfo[] rowColumnTypeInfos;
    private DataTypePhysicalVariation[] rowDataTypePhysicalVariations;
    private int[] dataColumnNums;
    private int dataColumnCount;
    private int partitionColumnCount;
    private int virtualColumnCount;
    private VirtualColumn[] neededVirtualColumns;
    private String[] scratchColumnTypeNames;
    private DataTypePhysicalVariation[] scratchDataTypePhysicalVariations;

    public VectorizedRowBatchCtx() {
    }

    public VectorizedRowBatchCtx(String[] rowColumnNames, TypeInfo[] rowColumnTypeInfos, DataTypePhysicalVariation[] rowDataTypePhysicalVariations, int[] dataColumnNums, int partitionColumnCount, int virtualColumnCount, VirtualColumn[] neededVirtualColumns, String[] scratchColumnTypeNames, DataTypePhysicalVariation[] scratchDataTypePhysicalVariations) {
        this.rowColumnNames = rowColumnNames;
        this.rowColumnTypeInfos = rowColumnTypeInfos;
        if (rowDataTypePhysicalVariations == null) {
            this.rowDataTypePhysicalVariations = new DataTypePhysicalVariation[rowColumnTypeInfos.length];
            Arrays.fill(this.rowDataTypePhysicalVariations, DataTypePhysicalVariation.NONE);
        } else {
            this.rowDataTypePhysicalVariations = rowDataTypePhysicalVariations;
        }
        this.dataColumnNums = dataColumnNums;
        this.partitionColumnCount = partitionColumnCount;
        if (neededVirtualColumns == null) {
            neededVirtualColumns = new VirtualColumn[]{};
        } else {
            this.neededVirtualColumns = neededVirtualColumns;
        }
        this.virtualColumnCount = virtualColumnCount;
        this.scratchColumnTypeNames = scratchColumnTypeNames;
        if (scratchDataTypePhysicalVariations == null) {
            this.scratchDataTypePhysicalVariations = new DataTypePhysicalVariation[scratchColumnTypeNames.length];
            Arrays.fill(this.scratchDataTypePhysicalVariations, DataTypePhysicalVariation.NONE);
        } else {
            this.scratchDataTypePhysicalVariations = scratchDataTypePhysicalVariations;
        }
        this.dataColumnCount = rowColumnTypeInfos.length - partitionColumnCount - virtualColumnCount;
    }

    public String[] getRowColumnNames() {
        return this.rowColumnNames;
    }

    public TypeInfo[] getRowColumnTypeInfos() {
        return this.rowColumnTypeInfos;
    }

    public DataTypePhysicalVariation[] getRowdataTypePhysicalVariations() {
        return this.rowDataTypePhysicalVariations;
    }

    public void setRowDataTypePhysicalVariations(DataTypePhysicalVariation[] rowDataTypePhysicalVariations) {
        this.rowDataTypePhysicalVariations = rowDataTypePhysicalVariations;
    }

    public int[] getDataColumnNums() {
        return this.dataColumnNums;
    }

    public int getDataColumnCount() {
        return this.dataColumnCount;
    }

    public int getPartitionColumnCount() {
        return this.partitionColumnCount;
    }

    public int getVirtualColumnCount() {
        return this.virtualColumnCount;
    }

    public VirtualColumn[] getNeededVirtualColumns() {
        return this.neededVirtualColumns;
    }

    public boolean isVirtualColumnNeeded(String virtualColumnName) {
        for (VirtualColumn neededVirtualColumn : this.neededVirtualColumns) {
            if (!neededVirtualColumn.getName().equals(virtualColumnName)) continue;
            return true;
        }
        return false;
    }

    public int findVirtualColumnNum(VirtualColumn virtualColumn) {
        int partitionEndColumnNum = this.dataColumnCount + this.partitionColumnCount;
        int virtualEndColumnNum = partitionEndColumnNum + this.virtualColumnCount;
        for (int virtualColumnNum = partitionEndColumnNum; virtualColumnNum < virtualEndColumnNum; ++virtualColumnNum) {
            String virtualColumnName = this.rowColumnNames[virtualColumnNum];
            if (!virtualColumnName.equals(virtualColumn.getName()) || !this.isVirtualColumnNeeded(virtualColumnName)) continue;
            return virtualColumnNum;
        }
        return -1;
    }

    public String[] getScratchColumnTypeNames() {
        return this.scratchColumnTypeNames;
    }

    public DataTypePhysicalVariation[] getScratchDataTypePhysicalVariations() {
        return this.scratchDataTypePhysicalVariations;
    }

    public void init(StructObjectInspector structObjectInspector, String[] scratchColumnTypeNames) throws HiveException {
        this.rowColumnNames = VectorizedBatchUtil.columnNamesFromStructObjectInspector(structObjectInspector);
        this.rowColumnTypeInfos = VectorizedBatchUtil.typeInfosFromStructObjectInspector(structObjectInspector);
        this.dataColumnNums = null;
        this.partitionColumnCount = 0;
        this.virtualColumnCount = 0;
        this.neededVirtualColumns = new VirtualColumn[0];
        this.dataColumnCount = this.rowColumnTypeInfos.length;
        this.scratchColumnTypeNames = scratchColumnTypeNames;
        int scratchSize = scratchColumnTypeNames.length;
        this.scratchDataTypePhysicalVariations = new DataTypePhysicalVariation[scratchSize];
        Arrays.fill(this.scratchDataTypePhysicalVariations, DataTypePhysicalVariation.NONE);
    }

    public void init(StructObjectInspector structObjectInspector, String[] scratchColumnTypeNames, DataTypePhysicalVariation[] scratchDataTypePhysicalVariations) throws HiveException {
        this.rowColumnNames = VectorizedBatchUtil.columnNamesFromStructObjectInspector(structObjectInspector);
        this.rowColumnTypeInfos = VectorizedBatchUtil.typeInfosFromStructObjectInspector(structObjectInspector);
        this.dataColumnNums = null;
        this.partitionColumnCount = 0;
        this.virtualColumnCount = 0;
        this.neededVirtualColumns = new VirtualColumn[0];
        this.dataColumnCount = this.rowColumnTypeInfos.length;
        this.scratchColumnTypeNames = scratchColumnTypeNames;
        this.scratchDataTypePhysicalVariations = scratchDataTypePhysicalVariations;
    }

    public static void getPartitionValues(VectorizedRowBatchCtx vrbCtx, Configuration hiveConf, FileSplit split, Object[] partitionValues) throws IOException {
        MapWork mapWork = Utilities.getMapWork(hiveConf);
        VectorizedRowBatchCtx.getPartitionValues(vrbCtx, mapWork, split, partitionValues);
    }

    public static void getPartitionValues(VectorizedRowBatchCtx vrbCtx, MapWork mapWork, FileSplit split, Object[] partitionValues) throws IOException {
        Map<Path, PartitionDesc> pathToPartitionInfo = mapWork.getPathToPartitionInfo();
        PartitionDesc partDesc = HiveFileFormatUtils.getFromPathRecursively(pathToPartitionInfo, split.getPath(), IOPrepareCache.get().getPartitionDescMap());
        VectorizedRowBatchCtx.getPartitionValues(vrbCtx, partDesc, partitionValues);
    }

    public static void getPartitionValues(VectorizedRowBatchCtx vrbCtx, PartitionDesc partDesc, Object[] partitionValues) {
        LinkedHashMap<String, String> partSpec = partDesc.getPartSpec();
        for (int i = 0; i < vrbCtx.partitionColumnCount; ++i) {
            Object objectValue;
            if (partSpec == null) {
                objectValue = null;
            } else {
                String key = vrbCtx.rowColumnNames[vrbCtx.dataColumnCount + i];
                TypeInfo partColTypeInfo = vrbCtx.rowColumnTypeInfos[vrbCtx.dataColumnCount + i];
                ObjectInspector objectInspector = TypeInfoUtils.getStandardJavaObjectInspectorFromTypeInfo((TypeInfo)partColTypeInfo);
                objectValue = ObjectInspectorConverters.getConverter((ObjectInspector)PrimitiveObjectInspectorFactory.javaStringObjectInspector, (ObjectInspector)objectInspector).convert((Object)partSpec.get(key));
                if (partColTypeInfo instanceof CharTypeInfo) {
                    objectValue = ((HiveChar)objectValue).getStrippedValue();
                }
            }
            partitionValues[i] = objectValue;
        }
    }

    private ColumnVector createColumnVectorFromRowColumnTypeInfos(int columnNum) {
        TypeInfo typeInfo = this.rowColumnTypeInfos[columnNum];
        DataTypePhysicalVariation dataTypePhysicalVariation = this.rowDataTypePhysicalVariations != null ? this.rowDataTypePhysicalVariations[columnNum] : DataTypePhysicalVariation.NONE;
        return VectorizedBatchUtil.createColumnVector(typeInfo, dataTypePhysicalVariation);
    }

    public VectorizedRowBatch createVectorizedRowBatch() {
        int i;
        int nonScratchColumnCount = this.rowColumnTypeInfos.length;
        int totalColumnCount = nonScratchColumnCount + this.scratchColumnTypeNames.length;
        VectorizedRowBatch result = new VectorizedRowBatch(totalColumnCount);
        if (this.dataColumnNums == null) {
            for (i = 0; i < nonScratchColumnCount; ++i) {
                result.cols[i] = this.createColumnVectorFromRowColumnTypeInfos(i);
            }
        } else {
            for (i = 0; i < this.dataColumnNums.length; ++i) {
                int columnNum = this.dataColumnNums[i];
                Preconditions.checkState((columnNum < nonScratchColumnCount ? 1 : 0) != 0);
                result.cols[columnNum] = this.createColumnVectorFromRowColumnTypeInfos(columnNum);
            }
            int partitionEndColumnNum = this.dataColumnCount + this.partitionColumnCount;
            for (int partitionColumnNum = this.dataColumnCount; partitionColumnNum < partitionEndColumnNum; ++partitionColumnNum) {
                result.cols[partitionColumnNum] = this.createColumnVectorFromRowColumnTypeInfos(partitionColumnNum);
            }
            int virtualEndColumnNum = partitionEndColumnNum + this.virtualColumnCount;
            for (int virtualColumnNum = partitionEndColumnNum; virtualColumnNum < virtualEndColumnNum; ++virtualColumnNum) {
                String virtualColumnName = this.rowColumnNames[virtualColumnNum];
                if (!this.isVirtualColumnNeeded(virtualColumnName)) continue;
                result.cols[virtualColumnNum] = VectorizedBatchUtil.createColumnVector(this.rowColumnTypeInfos[virtualColumnNum]);
            }
        }
        for (i = 0; i < this.scratchColumnTypeNames.length; ++i) {
            String typeName = this.scratchColumnTypeNames[i];
            DataTypePhysicalVariation dataTypePhysicalVariation = this.scratchDataTypePhysicalVariations[i];
            result.cols[nonScratchColumnCount + i] = VectorizedBatchUtil.createColumnVector(typeName, dataTypePhysicalVariation);
        }
        result.setPartitionInfo(this.dataColumnCount, this.partitionColumnCount);
        result.reset();
        return result;
    }

    public void setBucketAndWriteIdOf(VectorizedRowBatch vectorizedRowBatch, BucketIdentifier bucketIdentifier) {
        if (bucketIdentifier == null) {
            return;
        }
        int virtualColumnNum = this.findVirtualColumnNum(VirtualColumn.ROWID);
        if (virtualColumnNum == -1) {
            return;
        }
        StructColumnVector rowIdStructColVector = (StructColumnVector)vectorizedRowBatch.cols[virtualColumnNum];
        LongColumnVector writeIdColVector = (LongColumnVector)rowIdStructColVector.fields[0];
        writeIdColVector.isRepeating = true;
        writeIdColVector.vector[0] = bucketIdentifier.getWriteId();
        LongColumnVector bucketIdColVector = (LongColumnVector)rowIdStructColVector.fields[1];
        bucketIdColVector.isRepeating = true;
        bucketIdColVector.vector[0] = bucketIdentifier.getBucketProperty();
        LongColumnVector rowIdColVector = (LongColumnVector)rowIdStructColVector.fields[2];
    }

    public void addPartitionColsToBatch(VectorizedRowBatch batch, Object[] partitionValues) {
        this.addPartitionColsToBatch(batch.cols, partitionValues);
    }

    public void addPartitionColsToBatch(ColumnVector[] cols, Object[] partitionValues) {
        int[] colIndices = IntStream.range(this.dataColumnCount, this.dataColumnCount + this.partitionColumnCount).toArray();
        if (partitionValues != null) {
            for (int i = 0; i < colIndices.length; ++i) {
                int colIndex = colIndices[i];
                this.addPartitionColsToBatch(cols[colIndex], partitionValues[i], colIndex);
            }
        }
    }

    public void addPartitionColsToBatch(ColumnVector col, Object value, int colIndex) {
        String partitionColumnName = this.rowColumnNames[colIndex];
        PrimitiveTypeInfo primitiveTypeInfo = (PrimitiveTypeInfo)this.rowColumnTypeInfos[colIndex];
        switch (primitiveTypeInfo.getPrimitiveCategory()) {
            case BOOLEAN: {
                LongColumnVector lcv = (LongColumnVector)col;
                if (value == null) {
                    lcv.noNulls = false;
                    lcv.isNull[0] = true;
                    lcv.isRepeating = true;
                    break;
                }
                lcv.fill((Boolean)value == true ? 1L : 0L);
                break;
            }
            case BYTE: {
                LongColumnVector lcv = (LongColumnVector)col;
                if (value == null) {
                    lcv.noNulls = false;
                    lcv.isNull[0] = true;
                    lcv.isRepeating = true;
                    break;
                }
                lcv.fill((long)((Byte)value).byteValue());
                break;
            }
            case SHORT: {
                LongColumnVector lcv = (LongColumnVector)col;
                if (value == null) {
                    lcv.noNulls = false;
                    lcv.isNull[0] = true;
                    lcv.isRepeating = true;
                    break;
                }
                lcv.fill((long)((Short)value).shortValue());
                break;
            }
            case INT: {
                LongColumnVector lcv = (LongColumnVector)col;
                if (value == null) {
                    lcv.noNulls = false;
                    lcv.isNull[0] = true;
                    lcv.isRepeating = true;
                    break;
                }
                lcv.fill((long)((Integer)value).intValue());
                break;
            }
            case LONG: {
                LongColumnVector lcv = (LongColumnVector)col;
                if (value == null) {
                    lcv.noNulls = false;
                    lcv.isNull[0] = true;
                    lcv.isRepeating = true;
                    break;
                }
                lcv.fill(((Long)value).longValue());
                break;
            }
            case DATE: {
                LongColumnVector lcv = (LongColumnVector)col;
                if (value == null) {
                    lcv.noNulls = false;
                    lcv.isNull[0] = true;
                    lcv.isRepeating = true;
                    break;
                }
                lcv.fill((long)DateWritableV2.dateToDays((Date)((Date)value)));
                break;
            }
            case TIMESTAMP: {
                TimestampColumnVector lcv = (TimestampColumnVector)col;
                if (value == null) {
                    lcv.noNulls = false;
                    lcv.isNull[0] = true;
                    lcv.isRepeating = true;
                    break;
                }
                lcv.fill(((Timestamp)value).toSqlTimestamp());
                break;
            }
            case INTERVAL_YEAR_MONTH: {
                LongColumnVector lcv = (LongColumnVector)col;
                if (value == null) {
                    lcv.noNulls = false;
                    lcv.isNull[0] = true;
                    lcv.isRepeating = true;
                    break;
                }
                lcv.fill((long)((HiveIntervalYearMonth)value).getTotalMonths());
                break;
            }
            case INTERVAL_DAY_TIME: {
                IntervalDayTimeColumnVector icv = (IntervalDayTimeColumnVector)col;
                if (value == null) {
                    icv.noNulls = false;
                    icv.isNull[0] = true;
                    icv.isRepeating = true;
                    break;
                }
                icv.fill((HiveIntervalDayTime)value);
                break;
            }
            case FLOAT: {
                DoubleColumnVector dcv = (DoubleColumnVector)col;
                if (value == null) {
                    dcv.noNulls = false;
                    dcv.isNull[0] = true;
                    dcv.isRepeating = true;
                    break;
                }
                dcv.fill((double)((Float)value).floatValue());
                break;
            }
            case DOUBLE: {
                DoubleColumnVector dcv = (DoubleColumnVector)col;
                if (value == null) {
                    dcv.noNulls = false;
                    dcv.isNull[0] = true;
                    dcv.isRepeating = true;
                    break;
                }
                dcv.fill(((Double)value).doubleValue());
                break;
            }
            case DECIMAL: {
                DataTypePhysicalVariation dataTypePhysicalVariation;
                DataTypePhysicalVariation dataTypePhysicalVariation2 = dataTypePhysicalVariation = this.rowDataTypePhysicalVariations != null ? this.rowDataTypePhysicalVariations[colIndex] : DataTypePhysicalVariation.NONE;
                if (dataTypePhysicalVariation == DataTypePhysicalVariation.DECIMAL_64) {
                    Decimal64ColumnVector dv = (Decimal64ColumnVector)col;
                    if (value == null) {
                        dv.noNulls = false;
                        dv.isNull[0] = true;
                        dv.isRepeating = true;
                        break;
                    }
                    dv.fill((HiveDecimal)value);
                    break;
                }
                DecimalColumnVector dv = (DecimalColumnVector)col;
                if (value == null) {
                    dv.noNulls = false;
                    dv.isNull[0] = true;
                    dv.isRepeating = true;
                    break;
                }
                dv.fill((HiveDecimal)value);
                break;
            }
            case BINARY: {
                BytesColumnVector bcv = (BytesColumnVector)col;
                byte[] bytes = (byte[])value;
                if (bytes == null) {
                    bcv.noNulls = false;
                    bcv.isNull[0] = true;
                    bcv.isRepeating = true;
                    break;
                }
                bcv.fill(bytes);
                break;
            }
            case STRING: 
            case CHAR: 
            case VARCHAR: {
                BytesColumnVector bcv = (BytesColumnVector)col;
                if (value == null) {
                    bcv.noNulls = false;
                    bcv.isNull[0] = true;
                    bcv.isRepeating = true;
                    break;
                }
                String sVal = value.toString();
                bcv.fill(sVal.getBytes());
                break;
            }
            default: {
                throw new RuntimeException("Unable to recognize the partition type " + primitiveTypeInfo.getPrimitiveCategory() + " for column " + partitionColumnName);
            }
        }
    }

    public final boolean isPartitionCol(int colNum) {
        return colNum >= this.dataColumnCount && colNum < this.rowColumnTypeInfos.length;
    }
}

