/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.repl.bootstrap.events.filesystem;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Iterator;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.PathFilter;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.exec.repl.ReplDumpTask;
import org.apache.hadoop.hive.ql.exec.repl.bootstrap.events.filesystem.FSConstraintEvent;
import org.apache.hadoop.hive.ql.parse.EximUtil;

public class ConstraintEventsIterator
implements Iterator<FSConstraintEvent> {
    private FileStatus[] dbDirs;
    private int currentDbIndex;
    private FileStatus[] constraintFiles = null;
    private int currentConstraintIndex;
    private FileSystem fs;
    private Path path;
    private ReplDumpTask.ConstraintFileType mode = ReplDumpTask.ConstraintFileType.COMMON;

    public ConstraintEventsIterator(String dumpDirectory, HiveConf hiveConf) throws IOException {
        this.path = new Path(dumpDirectory);
        this.fs = this.path.getFileSystem((Configuration)hiveConf);
    }

    private FileStatus[] listConstraintFilesInDBDir(FileSystem fs, Path dbDir, final String prefix) {
        try {
            return fs.listStatus(new Path(dbDir, "_constraints"), new PathFilter(){

                public boolean accept(Path p) {
                    return p.getName().startsWith(prefix);
                }
            });
        }
        catch (FileNotFoundException e) {
            return new FileStatus[0];
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    boolean hasNext(ReplDumpTask.ConstraintFileType type) {
        if (this.dbDirs == null) {
            try {
                this.dbDirs = this.fs.listStatus(this.path, EximUtil.getDirectoryFilter(this.fs));
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            this.currentDbIndex = 0;
            if (this.dbDirs.length != 0) {
                this.currentConstraintIndex = 0;
                this.constraintFiles = this.listConstraintFilesInDBDir(this.fs, this.dbDirs[0].getPath(), type.getPrefix());
            }
        }
        if (this.currentDbIndex < this.dbDirs.length && this.currentConstraintIndex < this.constraintFiles.length) {
            return true;
        }
        while (this.currentDbIndex < this.dbDirs.length && this.currentConstraintIndex == this.constraintFiles.length) {
            ++this.currentDbIndex;
            if (this.currentDbIndex < this.dbDirs.length) {
                this.currentConstraintIndex = 0;
                this.constraintFiles = this.listConstraintFilesInDBDir(this.fs, this.dbDirs[this.currentDbIndex].getPath(), type.getPrefix());
                continue;
            }
            this.constraintFiles = null;
        }
        return this.constraintFiles != null;
    }

    @Override
    public boolean hasNext() {
        if (this.mode == ReplDumpTask.ConstraintFileType.COMMON) {
            if (this.hasNext(ReplDumpTask.ConstraintFileType.COMMON)) {
                return true;
            }
            this.mode = ReplDumpTask.ConstraintFileType.FOREIGNKEY;
            this.currentDbIndex = 0;
            this.currentConstraintIndex = 0;
            this.dbDirs = null;
        }
        return this.hasNext(ReplDumpTask.ConstraintFileType.FOREIGNKEY);
    }

    @Override
    public FSConstraintEvent next() {
        int thisIndex = this.currentConstraintIndex++;
        return new FSConstraintEvent(this.constraintFiles[thisIndex].getPath());
    }
}

