/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.repl;

import com.google.common.annotations.VisibleForTesting;
import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.atlas.model.impexp.AtlasExportRequest;
import org.apache.atlas.model.impexp.AtlasServer;
import org.apache.atlas.model.instance.AtlasObjectId;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.utils.SecurityUtils;
import org.apache.hadoop.hive.ql.ErrorMsg;
import org.apache.hadoop.hive.ql.exec.Task;
import org.apache.hadoop.hive.ql.exec.repl.AtlasDumpWork;
import org.apache.hadoop.hive.ql.exec.repl.atlas.AtlasReplInfo;
import org.apache.hadoop.hive.ql.exec.repl.atlas.AtlasRequestBuilder;
import org.apache.hadoop.hive.ql.exec.repl.atlas.AtlasRestClient;
import org.apache.hadoop.hive.ql.exec.repl.atlas.AtlasRestClientBuilder;
import org.apache.hadoop.hive.ql.exec.repl.util.ReplUtils;
import org.apache.hadoop.hive.ql.exec.util.Retryable;
import org.apache.hadoop.hive.ql.parse.SemanticException;
import org.apache.hadoop.hive.ql.parse.repl.dump.Utils;
import org.apache.hadoop.hive.ql.parse.repl.dump.log.AtlasDumpLogger;
import org.apache.hadoop.hive.ql.parse.repl.metric.event.Status;
import org.apache.hadoop.hive.ql.plan.api.StageType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AtlasDumpTask
extends Task<AtlasDumpWork>
implements Serializable {
    private static final Logger LOG = LoggerFactory.getLogger(AtlasDumpTask.class);
    private static final long serialVersionUID = 1L;
    private transient AtlasRestClient atlasRestClient;

    public AtlasDumpTask() {
    }

    @VisibleForTesting
    AtlasDumpTask(AtlasRestClient atlasRestClient, HiveConf conf, AtlasDumpWork work) {
        this.conf = conf;
        this.work = work;
        this.atlasRestClient = atlasRestClient;
    }

    @Override
    public int execute() {
        try {
            SecurityUtils.reloginExpiringKeytabUser();
            AtlasReplInfo atlasReplInfo = this.createAtlasReplInfo();
            LOG.info("Dumping Atlas metadata of srcDb: {}, for TgtDb: {} to staging location: {}", new Object[]{atlasReplInfo.getSrcDB(), atlasReplInfo.getTgtDB(), atlasReplInfo.getStagingDir()});
            AtlasDumpLogger replLogger = new AtlasDumpLogger(atlasReplInfo.getSrcDB(), atlasReplInfo.getStagingDir().toString());
            replLogger.startLog();
            HashMap<String, Long> metricMap = new HashMap<String, Long>();
            metricMap.put(ReplUtils.MetricName.ENTITIES.name(), 0L);
            ((AtlasDumpWork)this.work).getMetricCollector().reportStageStart(this.getName(), metricMap);
            this.atlasRestClient = new AtlasRestClientBuilder(atlasReplInfo.getAtlasEndpoint()).getClient(atlasReplInfo.getConf());
            AtlasRequestBuilder atlasRequestBuilder = new AtlasRequestBuilder();
            String entityGuid = this.checkHiveEntityGuid(atlasRequestBuilder, atlasReplInfo.getSrcCluster(), atlasReplInfo.getSrcDB());
            long numBytesWritten = this.dumpAtlasMetaData(atlasRequestBuilder, atlasReplInfo);
            LOG.debug("Finished dumping atlas metadata, total:{} bytes written", (Object)numBytesWritten);
            long currentModifiedTime = this.getCurrentTimestamp(atlasReplInfo, entityGuid);
            this.createDumpMetadata(atlasReplInfo, currentModifiedTime);
            replLogger.endLog(0L);
            ((AtlasDumpWork)this.work).getMetricCollector().reportStageEnd(this.getName(), Status.SUCCESS);
            return 0;
        }
        catch (RuntimeException e) {
            LOG.error("RuntimeException while dumping atlas metadata", (Throwable)e);
            this.setException(e);
            try {
                ReplUtils.handleException(true, e, ((AtlasDumpWork)this.work).getStagingDir().getParent().toString(), ((AtlasDumpWork)this.work).getMetricCollector(), this.getName(), this.conf);
            }
            catch (Exception ex) {
                LOG.error("Failed to collect replication metrics: ", (Throwable)ex);
            }
            throw e;
        }
        catch (Exception e) {
            LOG.error("Exception while dumping atlas metadata", (Throwable)e);
            this.setException(e);
            int errorCode = ErrorMsg.getErrorMsg((String)e.getMessage()).getErrorCode();
            try {
                return ReplUtils.handleException(true, e, ((AtlasDumpWork)this.work).getStagingDir().getParent().toString(), ((AtlasDumpWork)this.work).getMetricCollector(), this.getName(), this.conf);
            }
            catch (Exception ex) {
                LOG.error("Failed to collect replication metrics: ", (Throwable)ex);
                return errorCode;
            }
        }
    }

    private AtlasReplInfo createAtlasReplInfo() throws SemanticException, MalformedURLException {
        String errorFormat = "%s is mandatory config for Atlas metadata replication";
        String endpoint = new URL(ReplUtils.getNonEmpty(HiveConf.ConfVars.REPL_ATLAS_ENDPOINT.varname, this.conf, errorFormat)).toString();
        String tgtDB = ReplUtils.getNonEmpty(HiveConf.ConfVars.REPL_ATLAS_REPLICATED_TO_DB.varname, this.conf, errorFormat);
        String srcCluster = ReplUtils.getNonEmpty(HiveConf.ConfVars.REPL_SOURCE_CLUSTER_NAME.varname, this.conf, errorFormat);
        String tgtCluster = ReplUtils.getNonEmpty(HiveConf.ConfVars.REPL_TARGET_CLUSTER_NAME.varname, this.conf, errorFormat);
        AtlasReplInfo atlasReplInfo = new AtlasReplInfo(endpoint, ((AtlasDumpWork)this.work).getSrcDB(), tgtDB, srcCluster, tgtCluster, ((AtlasDumpWork)this.work).getStagingDir(), ((AtlasDumpWork)this.work).getTableListPath(), this.conf);
        atlasReplInfo.setSrcFsUri(this.conf.get("fs.defaultFS"));
        long lastTimeStamp = ((AtlasDumpWork)this.work).isBootstrap() ? 0L : this.lastStoredTimeStamp();
        atlasReplInfo.setTimeStamp(lastTimeStamp);
        return atlasReplInfo;
    }

    private long lastStoredTimeStamp() throws SemanticException {
        Path prevMetadataPath = new Path(((AtlasDumpWork)this.work).getPrevAtlasDumpDir(), "_metadata");
        Retryable retryable = Retryable.builder().withHiveConf(this.conf).withRetryOnException(IOException.class).withFailOnException(FileNotFoundException.class).build();
        try {
            return retryable.executeCallable(() -> {
                BufferedReader br = null;
                try {
                    FileSystem fs = prevMetadataPath.getFileSystem((Configuration)this.conf);
                    br = new BufferedReader(new InputStreamReader((InputStream)fs.open(prevMetadataPath), Charset.defaultCharset()));
                    String line = br.readLine();
                    if (line == null) {
                        throw new SemanticException(ErrorMsg.REPL_INVALID_INTERNAL_CONFIG_FOR_SERVICE.format(new String[]{"Could not read lastStoredTimeStamp from atlas metadata file", "atlas"}));
                    }
                    String[] lineContents = line.split("\t", 5);
                    Long l = Long.parseLong(lineContents[1]);
                    return l;
                }
                finally {
                    if (br != null) {
                        try {
                            br.close();
                        }
                        catch (IOException iOException) {}
                    }
                }
            });
        }
        catch (SemanticException e) {
            throw e;
        }
        catch (Exception e) {
            throw new SemanticException(ErrorMsg.REPL_RETRY_EXHAUSTED.format(e.getMessage()), (Throwable)e);
        }
    }

    private long getCurrentTimestamp(AtlasReplInfo atlasReplInfo, String entityGuid) throws SemanticException {
        AtlasServer atlasServer = this.atlasRestClient.getServer(atlasReplInfo.getSrcCluster(), this.conf);
        long ret = atlasServer == null || atlasServer.getAdditionalInfoRepl(entityGuid) == null ? 0L : (Long)atlasServer.getAdditionalInfoRepl(entityGuid);
        LOG.debug("Current timestamp is: {}", (Object)ret);
        return ret;
    }

    long dumpAtlasMetaData(AtlasRequestBuilder atlasRequestBuilder, AtlasReplInfo atlasReplInfo) throws SemanticException {
        InputStream inputStream = null;
        long numBytesWritten = 0L;
        try {
            AtlasExportRequest exportRequest = atlasRequestBuilder.createExportRequest(atlasReplInfo);
            inputStream = this.atlasRestClient.exportData(exportRequest);
            if (inputStream == null) {
                LOG.info("There is no Atlas metadata to be exported");
            } else {
                FileSystem fs = atlasReplInfo.getStagingDir().getFileSystem((Configuration)atlasReplInfo.getConf());
                Path exportFilePath = new Path(atlasReplInfo.getStagingDir(), "atlas_export.zip");
                numBytesWritten = Utils.writeFile(fs, exportFilePath, inputStream, this.conf);
            }
        }
        catch (SemanticException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new SemanticException(ex.getMessage(), (Throwable)ex);
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException iOException) {}
            }
        }
        return numBytesWritten;
    }

    private String checkHiveEntityGuid(AtlasRequestBuilder atlasRequestBuilder, String clusterName, String srcDb) throws SemanticException {
        AtlasObjectId objectId = atlasRequestBuilder.getItemToExport(clusterName, srcDb);
        Set entries = objectId.getUniqueAttributes().entrySet();
        if (entries == null || entries.isEmpty()) {
            throw new SemanticException(ErrorMsg.REPL_INVALID_INTERNAL_CONFIG_FOR_SERVICE.format(new String[]{"Could find entries in objectId for:" + clusterName, "atlas"}));
        }
        Map.Entry item = entries.iterator().next();
        String guid = this.atlasRestClient.getEntityGuid(objectId.getTypeName(), (String)item.getKey(), (String)item.getValue());
        if (guid == null || guid.isEmpty()) {
            throw new SemanticException(ErrorMsg.REPL_INVALID_INTERNAL_CONFIG_FOR_SERVICE.format(new String[]{"Entity not found:" + objectId, "atlas"}));
        }
        return guid;
    }

    void createDumpMetadata(AtlasReplInfo atlasReplInfo, long lastModifiedTime) throws SemanticException {
        Path dumpFile = new Path(atlasReplInfo.getStagingDir(), "_metadata");
        ArrayList<List<String>> listValues = new ArrayList<List<String>>();
        listValues.add(Arrays.asList(atlasReplInfo.getSrcFsUri(), String.valueOf(lastModifiedTime)));
        Utils.writeOutput(listValues, dumpFile, this.conf, true);
        LOG.debug("Stored metadata for Atlas dump at:", (Object)dumpFile.toString());
    }

    @Override
    public StageType getType() {
        return StageType.ATLAS_DUMP;
    }

    public String getName() {
        return "ATLAS_DUMP";
    }

    @Override
    public boolean canExecuteInParallel() {
        return false;
    }
}

