/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.ddl.workloadmanagement.resourceplan.show;

import org.apache.hadoop.hive.ql.QueryState;
import org.apache.hadoop.hive.ql.ddl.DDLSemanticAnalyzerFactory;
import org.apache.hadoop.hive.ql.ddl.DDLUtils;
import org.apache.hadoop.hive.ql.ddl.DDLWork;
import org.apache.hadoop.hive.ql.ddl.workloadmanagement.resourceplan.show.ShowResourcePlanDesc;
import org.apache.hadoop.hive.ql.exec.Task;
import org.apache.hadoop.hive.ql.exec.TaskFactory;
import org.apache.hadoop.hive.ql.parse.ASTNode;
import org.apache.hadoop.hive.ql.parse.BaseSemanticAnalyzer;
import org.apache.hadoop.hive.ql.parse.SemanticException;

@DDLSemanticAnalyzerFactory.DDLType(types={1221})
public class ShowResourcePlanAnalyzer
extends BaseSemanticAnalyzer {
    public ShowResourcePlanAnalyzer(QueryState queryState) throws SemanticException {
        super(queryState);
    }

    @Override
    public void analyzeInternal(ASTNode root) throws SemanticException {
        if (root.getChildCount() > 1) {
            throw new SemanticException("Invalid syntax for SHOW RESOURCE PLAN statement");
        }
        this.ctx.setResFile(this.ctx.getLocalTmpPath());
        String resourcePlanName = root.getChildCount() == 0 ? null : ShowResourcePlanAnalyzer.unescapeIdentifier(root.getChild(0).getText());
        ShowResourcePlanDesc desc = new ShowResourcePlanDesc(resourcePlanName, this.ctx.getResFile().toString());
        Task<DDLWork> task = TaskFactory.get(new DDLWork(this.getInputs(), this.getOutputs(), desc));
        this.rootTasks.add(task);
        task.setFetchSource(true);
        this.setFetchTask(this.createFetchTask(desc.getSchema()));
        DDLUtils.addServiceOutput(this.conf, this.getOutputs());
    }
}

