/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.ddl.workloadmanagement.pool.alter;

import java.io.Serializable;
import org.apache.hadoop.hive.ql.ddl.DDLDesc;
import org.apache.hadoop.hive.ql.plan.Explain;

@Explain(displayName="Alter Pool", explainLevels={Explain.Level.USER, Explain.Level.DEFAULT, Explain.Level.EXTENDED})
public class AlterWMPoolDesc
implements DDLDesc,
Serializable {
    private static final long serialVersionUID = 4872940135771213510L;
    private final String resourcePlanName;
    private final String poolPath;
    private final Double allocFraction;
    private final Integer queryParallelism;
    private final String schedulingPolicy;
    private final boolean removeSchedulingPolicy;
    private final String newPath;

    public AlterWMPoolDesc(String resourcePlanName, String poolPath, Double allocFraction, Integer queryParallelism, String schedulingPolicy, boolean removeSchedulingPolicy, String newPath) {
        this.resourcePlanName = resourcePlanName;
        this.poolPath = poolPath;
        this.allocFraction = allocFraction;
        this.queryParallelism = queryParallelism;
        this.schedulingPolicy = schedulingPolicy;
        this.removeSchedulingPolicy = removeSchedulingPolicy;
        this.newPath = newPath;
    }

    @Explain(displayName="Resource plan name", explainLevels={Explain.Level.USER, Explain.Level.DEFAULT, Explain.Level.EXTENDED})
    public String getResourcePlanName() {
        return this.resourcePlanName;
    }

    @Explain(displayName="Pool path", explainLevels={Explain.Level.USER, Explain.Level.DEFAULT, Explain.Level.EXTENDED})
    public String getPoolPath() {
        return this.poolPath;
    }

    @Explain(displayName="Alloc fraction", explainLevels={Explain.Level.USER, Explain.Level.DEFAULT, Explain.Level.EXTENDED})
    public Double getAllocFraction() {
        return this.allocFraction;
    }

    @Explain(displayName="Query parallelism", explainLevels={Explain.Level.USER, Explain.Level.DEFAULT, Explain.Level.EXTENDED})
    public Integer getQueryParallelism() {
        return this.queryParallelism;
    }

    @Explain(displayName="Scheduling policy", explainLevels={Explain.Level.USER, Explain.Level.DEFAULT, Explain.Level.EXTENDED})
    public String getSchedulingPolicy() {
        return this.schedulingPolicy;
    }

    @Explain(displayName="Remove scheduling policy", explainLevels={Explain.Level.USER, Explain.Level.DEFAULT, Explain.Level.EXTENDED}, displayOnlyOnTrue=true)
    public boolean isRemoveSchedulingPolicy() {
        return this.removeSchedulingPolicy;
    }

    @Explain(displayName="New path", explainLevels={Explain.Level.USER, Explain.Level.DEFAULT, Explain.Level.EXTENDED})
    public String getNewPath() {
        return this.newPath;
    }
}

