/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.ddl.table.partition.rename;

import java.io.Serializable;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.hadoop.hive.common.TableName;
import org.apache.hadoop.hive.ql.ddl.DDLDesc;
import org.apache.hadoop.hive.ql.metadata.Table;
import org.apache.hadoop.hive.ql.parse.ReplicationSpec;
import org.apache.hadoop.hive.ql.plan.Explain;

@Explain(displayName="Rename Partition", explainLevels={Explain.Level.USER, Explain.Level.DEFAULT, Explain.Level.EXTENDED})
public class AlterTableRenamePartitionDesc
implements DDLDesc.DDLDescWithWriteId,
Serializable {
    private static final long serialVersionUID = 1L;
    private final TableName tableName;
    private final Map<String, String> oldPartSpec;
    private final Map<String, String> newPartSpec;
    private final ReplicationSpec replicationSpec;
    private long writeId;

    public AlterTableRenamePartitionDesc(TableName tableName, Map<String, String> oldPartSpec, Map<String, String> newPartSpec, ReplicationSpec replicationSpec, Table table) {
        this.tableName = tableName;
        this.oldPartSpec = new LinkedHashMap<String, String>(oldPartSpec);
        this.newPartSpec = new LinkedHashMap<String, String>(newPartSpec);
        this.replicationSpec = replicationSpec;
    }

    @Explain(displayName="table", explainLevels={Explain.Level.USER, Explain.Level.DEFAULT, Explain.Level.EXTENDED})
    public String getTableName() {
        return this.tableName.getNotEmptyDbTable();
    }

    @Explain(displayName="old partitions", explainLevels={Explain.Level.USER, Explain.Level.DEFAULT, Explain.Level.EXTENDED})
    public Map<String, String> getOldPartSpec() {
        return this.oldPartSpec;
    }

    @Explain(displayName="new partitions", explainLevels={Explain.Level.USER, Explain.Level.DEFAULT, Explain.Level.EXTENDED})
    public Map<String, String> getNewPartSpec() {
        return this.newPartSpec;
    }

    @Explain(displayName="replication", explainLevels={Explain.Level.USER, Explain.Level.DEFAULT, Explain.Level.EXTENDED})
    public ReplicationSpec getReplicationSpec() {
        return this.replicationSpec;
    }

    @Override
    public void setWriteId(long writeId) {
        this.writeId = writeId;
    }

    public long getWriteId() {
        return this.writeId;
    }

    @Override
    public String getFullTableName() {
        return this.tableName.getNotEmptyDbTable();
    }

    @Override
    public boolean mayNeedWriteId() {
        return true;
    }
}

