/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.ddl.table.info.show.status;

import java.io.Closeable;
import java.io.DataOutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.ql.ErrorMsg;
import org.apache.hadoop.hive.ql.ddl.DDLOperation;
import org.apache.hadoop.hive.ql.ddl.DDLOperationContext;
import org.apache.hadoop.hive.ql.ddl.ShowUtils;
import org.apache.hadoop.hive.ql.ddl.table.info.show.status.ShowTableStatusDesc;
import org.apache.hadoop.hive.ql.ddl.table.info.show.status.formatter.ShowTableStatusFormatter;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.metadata.Partition;
import org.apache.hadoop.hive.ql.metadata.Table;
import org.apache.hadoop.hive.ql.udf.UDFLike;
import org.apache.hadoop.io.IOUtils;

public class ShowTableStatusOperation
extends DDLOperation<ShowTableStatusDesc> {
    public ShowTableStatusOperation(DDLOperationContext context, ShowTableStatusDesc desc) {
        super(context, desc);
    }

    @Override
    public int execute() throws HiveException {
        ArrayList<Table> tables = new ArrayList<Table>();
        Map<String, String> partitionSpec = ((ShowTableStatusDesc)this.desc).getPartSpec();
        Partition partition = null;
        if (partitionSpec != null) {
            Table table = this.context.getDb().getTable(((ShowTableStatusDesc)this.desc).getDbName(), ((ShowTableStatusDesc)this.desc).getPattern());
            partition = this.context.getDb().getPartition(table, partitionSpec, false);
            if (partition == null) {
                throw new HiveException("Partition " + partitionSpec + " for table " + ((ShowTableStatusDesc)this.desc).getPattern() + " does not exist.");
            }
            tables.add(table);
        } else {
            LOG.debug("pattern: {}", (Object)((ShowTableStatusDesc)this.desc).getPattern());
            List<String> tableNames = this.context.getDb().getTablesForDb(((ShowTableStatusDesc)this.desc).getDbName(), null);
            if (((ShowTableStatusDesc)this.desc).getPattern() != null) {
                Pattern pattern = Pattern.compile(UDFLike.likePatternToRegExp(((ShowTableStatusDesc)this.desc).getPattern()), 2);
                tableNames = tableNames.stream().filter(name -> pattern.matcher((CharSequence)name).matches()).collect(Collectors.toList());
            }
            Collections.sort(tableNames);
            for (String tableName : tableNames) {
                Table table = this.context.getDb().getTable(((ShowTableStatusDesc)this.desc).getDbName(), tableName);
                tables.add(table);
            }
            LOG.info("Found {} table(s) matching the SHOW TABLE EXTENDED statement.", (Object)tableNames.size());
        }
        DataOutputStream outStream = ShowUtils.getOutputStream(new Path(((ShowTableStatusDesc)this.desc).getResFile()), this.context);
        try {
            ShowTableStatusFormatter formatter = ShowTableStatusFormatter.getFormatter(this.context.getConf());
            formatter.showTableStatus(outStream, this.context.getDb(), this.context.getConf(), tables, partition);
        }
        catch (Exception e) {
            throw new HiveException((Throwable)e, ErrorMsg.GENERIC_ERROR, new String[]{"show table status"});
        }
        finally {
            IOUtils.closeStream((Closeable)outStream);
        }
        return 0;
    }
}

