/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.ddl.table.create.show;

import java.io.DataOutputStream;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.ql.ddl.DDLOperation;
import org.apache.hadoop.hive.ql.ddl.DDLOperationContext;
import org.apache.hadoop.hive.ql.ddl.ShowUtils;
import org.apache.hadoop.hive.ql.ddl.table.create.show.ShowCreateTableDesc;
import org.apache.hadoop.hive.ql.exec.DDLPlanUtils;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.metadata.Table;

public class ShowCreateTableOperation
extends DDLOperation<ShowCreateTableDesc> {
    public ShowCreateTableOperation(DDLOperationContext context, ShowCreateTableDesc desc) {
        super(context, desc);
    }

    @Override
    public int execute() throws HiveException {
        int n;
        block12: {
            DataOutputStream outStream = ShowUtils.getOutputStream(new Path(((ShowCreateTableDesc)this.desc).getResFile()), this.context);
            try {
                String command;
                Table table = this.context.getDb().getTable(((ShowCreateTableDesc)this.desc).getDatabaseName(), ((ShowCreateTableDesc)this.desc).getTableName());
                DDLPlanUtils ddlObj = new DDLPlanUtils();
                if (table.isView()) {
                    command = ddlObj.getCreateViewCommand(table, ((ShowCreateTableDesc)this.desc).isRelative());
                } else {
                    ArrayList<String> commands = new ArrayList<String>();
                    commands.add(ddlObj.getCreateTableCommand(table, ((ShowCreateTableDesc)this.desc).isRelative()));
                    String primaryKeyStmt = ddlObj.getAlterTableStmtPrimaryKeyConstraint(table.getPrimaryKeyInfo());
                    if (primaryKeyStmt != null) {
                        commands.add(primaryKeyStmt);
                    }
                    commands.addAll(ddlObj.populateConstraints(table));
                    command = String.join((CharSequence)"\n", commands);
                }
                outStream.write(command.getBytes(StandardCharsets.UTF_8));
                n = 0;
                if (outStream == null) break block12;
            }
            catch (Throwable throwable) {
                try {
                    if (outStream != null) {
                        try {
                            outStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    LOG.info("Show create table failed", (Throwable)e);
                    return 1;
                }
                catch (Exception e) {
                    throw new HiveException((Throwable)e);
                }
            }
            outStream.close();
        }
        return n;
    }
}

