/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.ddl.dataconnector.create;

import java.io.Serializable;
import java.util.Map;
import org.apache.hadoop.hive.ql.ddl.DDLDesc;
import org.apache.hadoop.hive.ql.plan.Explain;

@Explain(displayName="Create DataConnector", explainLevels={Explain.Level.USER, Explain.Level.DEFAULT, Explain.Level.EXTENDED})
public class CreateDataConnectorDesc
implements DDLDesc,
Serializable {
    private static final long serialVersionUID = 1L;
    private final String connectorName;
    private final String type;
    private final String url;
    private final String description;
    private final boolean ifNotExists;
    private final Map<String, String> dcProperties;

    public CreateDataConnectorDesc(String connectorName, String type, String url, boolean ifNotExists, String description, Map<String, String> dcProperties) {
        this.connectorName = connectorName;
        this.type = type;
        this.url = url;
        this.ifNotExists = ifNotExists;
        this.dcProperties = dcProperties;
        this.description = description;
    }

    @Explain(displayName="if not exists", displayOnlyOnTrue=true)
    public boolean getIfNotExists() {
        return this.ifNotExists;
    }

    public Map<String, String> getConnectorProperties() {
        return this.dcProperties;
    }

    @Explain(displayName="name", explainLevels={Explain.Level.USER, Explain.Level.DEFAULT, Explain.Level.EXTENDED})
    public String getName() {
        return this.connectorName;
    }

    @Explain(displayName="description")
    public String getComment() {
        return this.description;
    }

    @Explain(displayName="url")
    public String getURL() {
        return this.url;
    }

    @Explain(displayName="connector type")
    public String getType() {
        return this.type;
    }
}

