/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql;

import com.google.common.base.Strings;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.common.ValidTxnWriteIdList;
import org.apache.hadoop.hive.common.metrics.common.Metrics;
import org.apache.hadoop.hive.common.metrics.common.MetricsFactory;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.Context;
import org.apache.hadoop.hive.ql.Driver;
import org.apache.hadoop.hive.ql.DriverContext;
import org.apache.hadoop.hive.ql.DriverState;
import org.apache.hadoop.hive.ql.DriverUtils;
import org.apache.hadoop.hive.ql.ErrorMsg;
import org.apache.hadoop.hive.ql.MapRedStats;
import org.apache.hadoop.hive.ql.QueryDisplay;
import org.apache.hadoop.hive.ql.QueryPlan;
import org.apache.hadoop.hive.ql.TaskQueue;
import org.apache.hadoop.hive.ql.cache.results.CacheUsage;
import org.apache.hadoop.hive.ql.cache.results.QueryResultsCache;
import org.apache.hadoop.hive.ql.exec.ConditionalTask;
import org.apache.hadoop.hive.ql.exec.FetchTask;
import org.apache.hadoop.hive.ql.exec.Task;
import org.apache.hadoop.hive.ql.exec.TaskFactory;
import org.apache.hadoop.hive.ql.exec.TaskResult;
import org.apache.hadoop.hive.ql.exec.TaskRunner;
import org.apache.hadoop.hive.ql.exec.Utilities;
import org.apache.hadoop.hive.ql.history.HiveHistory;
import org.apache.hadoop.hive.ql.hooks.HookContext;
import org.apache.hadoop.hive.ql.hooks.PrivateHookContext;
import org.apache.hadoop.hive.ql.io.AcidUtils;
import org.apache.hadoop.hive.ql.metadata.Hive;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.plan.FetchWork;
import org.apache.hadoop.hive.ql.plan.HiveOperation;
import org.apache.hadoop.hive.ql.processors.CommandProcessorException;
import org.apache.hadoop.hive.ql.session.SessionState;
import org.apache.hadoop.util.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Executor {
    private static final String CLASS_NAME = Driver.class.getName();
    private static final Logger LOG = LoggerFactory.getLogger((String)CLASS_NAME);
    private static final SessionState.LogHelper CONSOLE = new SessionState.LogHelper(LOG);
    private final Context context;
    private final DriverContext driverContext;
    private final DriverState driverState;
    private final TaskQueue taskQueue;
    private HookContext hookContext;

    public Executor(Context context, DriverContext driverContext, DriverState driverState, TaskQueue taskQueue) {
        this.context = context;
        this.driverContext = driverContext;
        this.driverState = driverState;
        this.taskQueue = taskQueue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute() throws CommandProcessorException {
        SessionState.getPerfLogger().perfLogBegin(CLASS_NAME, "Driver.execute");
        boolean noName = Strings.isNullOrEmpty((String)this.driverContext.getConf().get("mapreduce.job.name"));
        this.checkState();
        boolean executionError = false;
        try {
            LOG.info("Executing command(queryId=" + this.driverContext.getQueryId() + "): " + this.driverContext.getQueryString());
            this.hookContext = new PrivateHookContext(this.driverContext, this.context);
            this.preExecutionActions();
            this.preExecutionCacheActions();
            this.driverContext.getQueryState().disableHMSCache();
            this.runTasks(noName);
            this.driverContext.getQueryState().enableHMSCache();
            this.postExecutionCacheActions();
            this.postExecutionActions();
        }
        catch (CommandProcessorException cpe) {
            executionError = true;
            throw cpe;
        }
        catch (Throwable e) {
            executionError = true;
            DriverUtils.checkInterrupted(this.driverState, this.driverContext, "during query execution: \n" + e.getMessage(), this.hookContext, SessionState.getPerfLogger());
            this.handleException(this.hookContext, e);
        }
        finally {
            this.cleanUp(noName, this.hookContext, executionError);
            this.driverContext.getQueryState().enableHMSCache();
        }
    }

    private void checkState() throws CommandProcessorException {
        this.driverState.lock();
        try {
            if (!this.driverState.isCompiled() && !this.driverState.isExecuting()) {
                String errorMessage = "FAILED: unexpected driverstate: " + this.driverState + ", for query " + this.driverContext.getQueryString();
                CONSOLE.printError(errorMessage);
                throw DriverUtils.createProcessorException(this.driverContext, 1000, errorMessage, "HY008", null);
            }
            this.driverState.executing();
        }
        finally {
            this.driverState.unlock();
        }
    }

    private void preExecutionActions() throws Exception {
        Hive.get().clearMetaCallTiming();
        this.driverContext.getPlan().setStarted();
        SessionState.get().getHiveHistory().startQuery(this.driverContext.getQueryString(), this.driverContext.getQueryId());
        SessionState.get().getHiveHistory().logPlanProgress(this.driverContext.getPlan());
        this.driverContext.setResStream(null);
        this.hookContext.setHookType(HookContext.HookType.PRE_EXEC_HOOK);
        this.driverContext.getHookRunner().runPreHooks(this.hookContext);
        this.driverContext.getHookRunner().runBeforeExecutionHook(this.driverContext.getQueryString(), this.hookContext);
        this.setQueryDisplays(this.driverContext.getPlan().getRootTasks());
        DriverUtils.checkInterrupted(this.driverState, this.driverContext, "before running tasks.", this.hookContext, SessionState.getPerfLogger());
        this.taskQueue.prepare(this.driverContext.getPlan());
        this.context.setHDFSCleanup(true);
        SessionState.get().setMapRedStats(new LinkedHashMap<String, MapRedStats>());
        SessionState.get().setStackTraces(new HashMap<String, List<List<String>>>());
        SessionState.get().setLocalMapRedErrors(new HashMap<String, List<String>>());
        Metrics metrics = MetricsFactory.getInstance();
        for (Task<?> task : this.driverContext.getPlan().getRootTasks()) {
            assert (task.getParentTasks() == null || task.getParentTasks().isEmpty());
            this.taskQueue.addToRunnable(task);
            if (metrics == null) continue;
            task.updateTaskMetrics(metrics);
        }
    }

    private void setQueryDisplays(List<Task<?>> tasks) {
        if (tasks != null) {
            HashSet visited = new HashSet();
            while (!tasks.isEmpty()) {
                tasks = this.setQueryDisplays(tasks, visited);
            }
        }
    }

    private List<Task<?>> setQueryDisplays(List<Task<?>> tasks, Set<Task<?>> visited) {
        ArrayList childTasks = new ArrayList();
        for (Task<?> task : tasks) {
            if (visited.contains(task)) continue;
            task.setQueryDisplay(this.driverContext.getQueryDisplay());
            if (task.getDependentTasks() != null) {
                childTasks.addAll(task.getDependentTasks());
            }
            visited.add(task);
        }
        return childTasks;
    }

    private void preExecutionCacheActions() throws Exception {
        if (this.driverContext.getCacheUsage() == null) {
            return;
        }
        if (this.driverContext.getCacheUsage().getStatus() == CacheUsage.CacheStatus.CAN_CACHE_QUERY_RESULTS && this.driverContext.getPlan().getFetchTask() != null) {
            QueryResultsCache.CacheEntry pendingCacheEntry;
            ValidTxnWriteIdList txnWriteIdList = null;
            if (this.driverContext.getPlan().hasAcidResourcesInQuery()) {
                txnWriteIdList = AcidUtils.getValidTxnWriteIdList((Configuration)this.driverContext.getConf());
            }
            if ((pendingCacheEntry = QueryResultsCache.getInstance().addToCache(this.driverContext.getCacheUsage().getQueryInfo(), txnWriteIdList)) != null) {
                this.driverContext.getCacheUsage().setCacheEntry(pendingCacheEntry);
            }
        }
    }

    private void runTasks(boolean noName) throws Exception {
        SessionState.getPerfLogger().perfLogBegin(CLASS_NAME, "runTasks");
        int jobCount = this.getJobCount();
        String jobName = this.getJobName();
        while (this.taskQueue.isRunning()) {
            this.launchTasks(noName, jobCount, jobName);
            this.handleFinished();
        }
        SessionState.getPerfLogger().perfLogEnd(CLASS_NAME, "runTasks");
    }

    private void handleFinished() throws Exception {
        boolean isReplicationOperation;
        TaskRunner taskRun = this.taskQueue.pollFinished();
        if (taskRun == null) {
            return;
        }
        String opName = this.driverContext.getPlan().getOperationName();
        boolean bl = isReplicationOperation = opName.equals(HiveOperation.REPLDUMP.getOperationName()) || opName.equals(HiveOperation.REPLLOAD.getOperationName());
        if (!isReplicationOperation) {
            this.hookContext.addCompleteTask(taskRun);
        }
        this.driverContext.getQueryDisplay().setTaskResult(taskRun.getTask().getId(), taskRun.getTaskResult());
        Task<?> task = taskRun.getTask();
        TaskResult result = taskRun.getTaskResult();
        int exitVal = result.getExitVal();
        SessionState.get().getHiveHistory().setTaskProperty(this.driverContext.getQueryId(), task.getId(), HiveHistory.Keys.TASK_RET_CODE, String.valueOf(exitVal));
        SessionState.get().getHiveHistory().endTask(this.driverContext.getQueryId(), task);
        DriverUtils.checkInterrupted(this.driverState, this.driverContext, "when checking the execution result.", this.hookContext, SessionState.getPerfLogger());
        if (exitVal != 0) {
            this.handleTaskFailure(task, result, exitVal);
            return;
        }
        this.taskQueue.finished(taskRun);
        if (task.getChildTasks() != null) {
            for (Task<?> child : task.getChildTasks()) {
                if (!TaskQueue.isLaunchable(child)) continue;
                this.taskQueue.addToRunnable(child);
            }
        }
    }

    private String getJobName() {
        int maxlen = this.driverContext.getConf().getIntVar(HiveConf.ConfVars.HIVE_JOBNAME_LENGTH);
        return Utilities.abbreviate(this.driverContext.getQueryString(), maxlen - 6);
    }

    private int getJobCount() {
        int mrJobCount = Utilities.getMRTasks(this.driverContext.getPlan().getRootTasks()).size();
        int jobCount = mrJobCount + Utilities.getTezTasks(this.driverContext.getPlan().getRootTasks()).size();
        if (jobCount > 0) {
            if (mrJobCount > 0 && "mr".equals(HiveConf.getVar((Configuration)this.driverContext.getConf(), (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_EXECUTION_ENGINE))) {
                LOG.warn(HiveConf.generateMrDeprecationWarning());
            }
            CONSOLE.printInfo("Query ID = " + this.driverContext.getPlan().getQueryId());
            CONSOLE.printInfo("Total jobs = " + jobCount);
        }
        if (SessionState.get() != null) {
            SessionState.get().getHiveHistory().setQueryProperty(this.driverContext.getPlan().getQueryId(), HiveHistory.Keys.QUERY_NUM_TASKS, String.valueOf(jobCount));
            SessionState.get().getHiveHistory().setIdToTableMap(this.driverContext.getPlan().getIdToTableNameMap());
        }
        return jobCount;
    }

    private void launchTasks(boolean noName, int jobCount, String jobName) throws HiveException {
        TaskRunner runner;
        Task<?> task;
        int maxthreads = HiveConf.getIntVar((Configuration)this.driverContext.getConf(), (HiveConf.ConfVars)HiveConf.ConfVars.EXEC_PARALLEL_THREAD_NUMBER);
        while ((task = this.taskQueue.getRunnable(maxthreads)) != null && (runner = this.launchTask(task, noName, jobName, jobCount)).isRunning()) {
        }
    }

    private TaskRunner launchTask(Task<?> task, boolean noName, String jobName, int jobCount) throws HiveException {
        SessionState.get().getHiveHistory().startTask(this.driverContext.getQueryId(), task, task.getClass().getName());
        if (task.isMapRedTask() && !(task instanceof ConditionalTask)) {
            if (noName) {
                this.driverContext.getConf().set("mapreduce.job.name", jobName + " (" + task.getId() + ")");
            }
            this.taskQueue.incCurJobNo(1);
            CONSOLE.printInfo("Launching Job " + this.taskQueue.getCurJobNo() + " out of " + jobCount);
        }
        task.initialize(this.driverContext.getQueryState(), this.driverContext.getPlan(), this.taskQueue, this.context);
        TaskRunner taskRun = new TaskRunner(task, this.taskQueue);
        this.taskQueue.launching(taskRun);
        if (HiveConf.getBoolVar((Configuration)task.getConf(), (HiveConf.ConfVars)HiveConf.ConfVars.EXEC_PARALLEL) && task.canExecuteInParallel()) {
            LOG.info("Starting task [" + task + "] in parallel");
            taskRun.start();
        } else {
            LOG.info("Starting task [" + task + "] in serial mode");
            taskRun.runSequential();
        }
        return taskRun;
    }

    private void handleTaskFailure(Task<?> task, TaskResult result, int exitVal) throws HiveException, Exception, CommandProcessorException {
        Task<?> backupTask = task.getAndInitBackupTask();
        if (backupTask != null) {
            Object errorMessage = this.getErrorMsgAndDetail(exitVal, result.getTaskError(), task);
            CONSOLE.printError((String)errorMessage);
            errorMessage = "ATTEMPT: Execute BackupTask: " + backupTask.getClass().getName();
            CONSOLE.printError((String)errorMessage);
            if (TaskQueue.isLaunchable(backupTask)) {
                this.taskQueue.addToRunnable(backupTask);
            }
        } else {
            ErrorMsg errorMsg;
            Object errorMessage = this.getErrorMsgAndDetail(exitVal, result.getTaskError(), task);
            if (this.taskQueue.isShutdown()) {
                errorMessage = "FAILED: Operation cancelled. " + (String)errorMessage;
            }
            DriverUtils.invokeFailureHooks(this.driverContext, SessionState.getPerfLogger(), this.hookContext, (String)errorMessage + Strings.nullToEmpty((String)task.getDiagnosticsMessage()), result.getTaskError());
            String sqlState = "08S01";
            if (result.getTaskError() instanceof HiveException && (errorMsg = ((HiveException)result.getTaskError()).getCanonicalErrorMsg()) != ErrorMsg.GENERIC_ERROR) {
                sqlState = errorMsg.getSQLState();
            }
            CONSOLE.printError((String)errorMessage);
            this.taskQueue.shutdown();
            this.context.restoreOriginalTracker();
            throw DriverUtils.createProcessorException(this.driverContext, exitVal, (String)errorMessage, sqlState, result.getTaskError());
        }
    }

    private String getErrorMsgAndDetail(int exitVal, Throwable downstreamError, Task<?> task) {
        String errorMessage = "FAILED: Execution Error, return code " + exitVal + " from " + task.getClass().getName();
        if (downstreamError != null) {
            errorMessage = downstreamError.getMessage() != null ? errorMessage + ". " + downstreamError.getMessage() : errorMessage + ". " + StringUtils.stringifyException((Throwable)downstreamError);
        } else {
            ErrorMsg em = ErrorMsg.getErrorMsg((int)exitVal);
            if (em != null) {
                errorMessage = errorMessage + ". " + em.getMsg();
            }
        }
        return errorMessage;
    }

    private void postExecutionCacheActions() throws Exception {
        if (this.driverContext.getCacheUsage() == null) {
            return;
        }
        if (this.driverContext.getCacheUsage().getStatus() == CacheUsage.CacheStatus.QUERY_USING_CACHE) {
            QueryResultsCache.CacheEntry cacheEntry = this.driverContext.getCacheUsage().getCacheEntry();
            this.driverContext.setUsedCacheEntry(cacheEntry);
        } else if (this.driverContext.getCacheUsage().getStatus() == CacheUsage.CacheStatus.CAN_CACHE_QUERY_RESULTS && this.driverContext.getCacheUsage().getCacheEntry() != null && this.driverContext.getPlan().getFetchTask() != null) {
            SessionState.getPerfLogger().perfLogBegin(CLASS_NAME, "saveToResultsCache");
            QueryResultsCache.CacheEntry cacheEntry = this.driverContext.getCacheUsage().getCacheEntry();
            boolean savedToCache = QueryResultsCache.getInstance().setEntryValid(cacheEntry, (FetchWork)this.driverContext.getPlan().getFetchTask().getWork());
            LOG.info("savedToCache: {} ({})", (Object)savedToCache, (Object)cacheEntry);
            if (savedToCache) {
                this.useFetchFromCache(this.driverContext.getCacheUsage().getCacheEntry());
                this.driverContext.setUsedCacheEntry(this.driverContext.getCacheUsage().getCacheEntry());
            }
            SessionState.getPerfLogger().perfLogEnd(CLASS_NAME, "saveToResultsCache");
        }
    }

    private void useFetchFromCache(QueryResultsCache.CacheEntry cacheEntry) {
        FetchTask fetchTaskFromCache = (FetchTask)TaskFactory.get(cacheEntry.getFetchWork());
        fetchTaskFromCache.initialize(this.driverContext.getQueryState(), this.driverContext.getPlan(), null, this.context);
        this.driverContext.getPlan().setFetchTask(fetchTaskFromCache);
        this.driverContext.setCacheUsage(new CacheUsage(CacheUsage.CacheStatus.QUERY_USING_CACHE, cacheEntry));
    }

    private void postExecutionActions() throws Exception {
        this.context.restoreOriginalTracker();
        if (this.taskQueue.isShutdown()) {
            String errorMessage = "FAILED: Operation cancelled";
            DriverUtils.invokeFailureHooks(this.driverContext, SessionState.getPerfLogger(), this.hookContext, errorMessage, null);
            CONSOLE.printError(errorMessage);
            throw DriverUtils.createProcessorException(this.driverContext, 1000, errorMessage, "HY008", null);
        }
        this.driverContext.getPlan().getOutputs().removeIf(x -> !x.isComplete());
        this.hookContext.setHookType(HookContext.HookType.POST_EXEC_HOOK);
        this.driverContext.getHookRunner().runPostExecHooks(this.hookContext);
        SessionState.get().getHiveHistory().setQueryProperty(this.driverContext.getQueryId(), HiveHistory.Keys.QUERY_RET_CODE, String.valueOf(0));
        SessionState.get().getHiveHistory().printRowCount(this.driverContext.getQueryId());
        this.releasePlan(this.driverContext.getPlan());
    }

    private void releasePlan(QueryPlan plan) {
        this.driverState.lock();
        try {
            if (plan != null) {
                plan.setDone();
                if (SessionState.get() != null) {
                    try {
                        SessionState.get().getHiveHistory().logPlanProgress(plan);
                    }
                    catch (Exception e) {
                        LOG.warn("Could not log query plan progress", (Throwable)e);
                    }
                }
            }
        }
        finally {
            this.driverState.unlock();
        }
    }

    private void handleException(HookContext hookContext, Throwable e) throws CommandProcessorException {
        this.context.restoreOriginalTracker();
        if (SessionState.get() != null) {
            SessionState.get().getHiveHistory().setQueryProperty(this.driverContext.getQueryId(), HiveHistory.Keys.QUERY_RET_CODE, String.valueOf(12));
        }
        String errorMessage = "FAILED: Hive Internal Error: " + Utilities.getNameMessage(e);
        if (hookContext != null) {
            try {
                DriverUtils.invokeFailureHooks(this.driverContext, SessionState.getPerfLogger(), hookContext, errorMessage, e);
            }
            catch (Exception t) {
                LOG.warn("Failed to invoke failure hook", (Throwable)t);
            }
        }
        CONSOLE.printError(errorMessage + "\n" + StringUtils.stringifyException((Throwable)e));
        throw DriverUtils.createProcessorException(this.driverContext, 12, errorMessage, "08S01", e);
    }

    private void cleanUp(boolean noName, HookContext hookContext, boolean executionError) {
        try {
            this.driverContext.getHookRunner().runAfterExecutionHook(this.driverContext.getQueryString(), hookContext, executionError);
        }
        catch (Exception e) {
            LOG.warn("Failed when invoking query after execution hook", (Throwable)e);
        }
        SessionState.get().getHiveHistory().endQuery(this.driverContext.getQueryId());
        if (noName) {
            this.driverContext.getConf().set("mapreduce.job.name", "");
        }
        double duration = (double)SessionState.getPerfLogger().perfLogEnd(CLASS_NAME, "Driver.execute") / 1000.0;
        ImmutableMap<String, Long> executionHMSTimings = Hive.dumpMetaCallTimingWithoutEx("execution");
        this.driverContext.getQueryDisplay().setHmsTimings(QueryDisplay.Phase.EXECUTION, (Map<String, Long>)executionHMSTimings);
        this.logExecutionResourceUsage();
        this.driverState.executionFinishedWithLocking(executionError);
        if (this.driverState.isAborted()) {
            LOG.info("Executing command(queryId={}) has been interrupted after {} seconds", (Object)this.driverContext.getQueryId(), (Object)duration);
        } else {
            LOG.info("Completed executing command(queryId={}); Time taken: {} seconds", (Object)this.driverContext.getQueryId(), (Object)duration);
        }
    }

    private void logExecutionResourceUsage() {
        Map<String, MapRedStats> stats = SessionState.get().getMapRedStats();
        if (stats != null && !stats.isEmpty()) {
            long totalCpu = 0L;
            long numModifiedRows = 0L;
            CONSOLE.printInfo("MapReduce Jobs Launched: ");
            for (Map.Entry<String, MapRedStats> entry : stats.entrySet()) {
                CONSOLE.printInfo("Stage-" + entry.getKey() + ": " + entry.getValue());
                totalCpu += entry.getValue().getCpuMSec();
                if (numModifiedRows <= -1L) continue;
                try {
                    numModifiedRows = Math.addExact(numModifiedRows, entry.getValue().getNumModifiedRows());
                }
                catch (ArithmeticException e) {
                    numModifiedRows = -1L;
                }
            }
            this.driverContext.getQueryState().setNumModifiedRows(numModifiedRows);
            CONSOLE.printInfo("Total MapReduce CPU Time Spent: " + Utilities.formatMsecToStr(totalCpu));
        }
    }
}

