/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql;

import com.google.common.collect.ImmutableMap;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.conf.VariableSubstitution;
import org.apache.hadoop.hive.metastore.HiveMetaStoreUtils;
import org.apache.hadoop.hive.metastore.api.FieldSchema;
import org.apache.hadoop.hive.metastore.api.Schema;
import org.apache.hadoop.hive.metastore.api.TxnType;
import org.apache.hadoop.hive.ql.Context;
import org.apache.hadoop.hive.ql.Driver;
import org.apache.hadoop.hive.ql.DriverContext;
import org.apache.hadoop.hive.ql.DriverState;
import org.apache.hadoop.hive.ql.DriverUtils;
import org.apache.hadoop.hive.ql.ErrorMsg;
import org.apache.hadoop.hive.ql.QueryDisplay;
import org.apache.hadoop.hive.ql.QueryPlan;
import org.apache.hadoop.hive.ql.QueryState;
import org.apache.hadoop.hive.ql.exec.ExplainTask;
import org.apache.hadoop.hive.ql.exec.FetchTask;
import org.apache.hadoop.hive.ql.hooks.HookUtils;
import org.apache.hadoop.hive.ql.io.AcidUtils;
import org.apache.hadoop.hive.ql.lockmgr.HiveTxnManager;
import org.apache.hadoop.hive.ql.lockmgr.LockException;
import org.apache.hadoop.hive.ql.log.PerfLogger;
import org.apache.hadoop.hive.ql.metadata.AuthorizationException;
import org.apache.hadoop.hive.ql.metadata.Hive;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.parse.ASTNode;
import org.apache.hadoop.hive.ql.parse.BaseSemanticAnalyzer;
import org.apache.hadoop.hive.ql.parse.HiveSemanticAnalyzerHookContextImpl;
import org.apache.hadoop.hive.ql.parse.ParseException;
import org.apache.hadoop.hive.ql.parse.ParseUtils;
import org.apache.hadoop.hive.ql.parse.SemanticAnalyzerFactory;
import org.apache.hadoop.hive.ql.plan.FetchWork;
import org.apache.hadoop.hive.ql.plan.HiveOperation;
import org.apache.hadoop.hive.ql.plan.PlanUtils;
import org.apache.hadoop.hive.ql.plan.TableDesc;
import org.apache.hadoop.hive.ql.processors.CommandProcessorException;
import org.apache.hadoop.hive.ql.reexec.ReCompileException;
import org.apache.hadoop.hive.ql.security.authorization.command.CommandAuthorizer;
import org.apache.hadoop.hive.ql.session.SessionState;
import org.apache.hadoop.hive.serde2.Deserializer;
import org.apache.hadoop.util.StringUtils;
import org.apache.logging.log4j.util.Strings;
import org.apache.thrift.TException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Compiler {
    private static final String CLASS_NAME = Driver.class.getName();
    private static final Logger LOG = LoggerFactory.getLogger((String)CLASS_NAME);
    private static final SessionState.LogHelper CONSOLE = new SessionState.LogHelper(LOG);
    private final Context context;
    private final DriverContext driverContext;
    private final QueryState queryState;
    private final DriverState driverState;
    private final PerfLogger perfLogger = SessionState.getPerfLogger();
    private ASTNode tree;

    public Compiler(Context context, DriverContext driverContext, DriverState driverState) {
        this.context = context;
        this.driverContext = driverContext;
        this.queryState = driverContext.getQueryState();
        this.queryState.setValidTxnList(this::openTxnAndGetValidTxnList);
        this.driverState = driverState;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public QueryPlan compile(String rawCommand, boolean deferClose) throws CommandProcessorException {
        this.initialize(rawCommand);
        Throwable compileException = null;
        boolean parsed = false;
        QueryPlan plan = null;
        try {
            DriverUtils.checkInterrupted(this.driverState, this.driverContext, "before parsing and analysing the query", null, null);
            this.parse();
            parsed = true;
            BaseSemanticAnalyzer sem = this.analyze();
            DriverUtils.checkInterrupted(this.driverState, this.driverContext, "after analyzing query.", null, null);
            plan = this.createPlan(sem);
            if (HiveOperation.START_TRANSACTION == this.queryState.getHiveOperation() || plan.isRequiresOpenTransaction()) {
                this.openTxnAndGetValidTxnList();
            }
            this.verifyTxnState();
            this.initializeFetchTask(plan);
            this.authorize(sem);
            this.explainOutput(sem, plan);
        }
        catch (CommandProcessorException cpe) {
            compileException = cpe.getCause();
            throw cpe;
        }
        catch (Exception e) {
            compileException = e;
            DriverUtils.checkInterrupted(this.driverState, this.driverContext, "during query compilation: " + e.getMessage(), null, null);
            this.handleException(e);
        }
        finally {
            this.cleanUp(compileException, parsed, deferClose);
        }
        return plan;
    }

    private void initialize(String rawCommand) throws CommandProcessorException {
        String command;
        this.perfLogger.perfLogBegin(CLASS_NAME, "compile");
        this.driverState.compilingWithLocking();
        VariableSubstitution variableSubstitution = new VariableSubstitution(() -> SessionState.get().getHiveVariables());
        String queryStr = command = variableSubstitution.substitute(this.driverContext.getConf(), rawCommand);
        try {
            queryStr = HookUtils.redactLogString(this.driverContext.getConf(), command);
        }
        catch (Exception e) {
            LOG.warn("WARNING! Query command could not be redacted." + e);
        }
        DriverUtils.checkInterrupted(this.driverState, this.driverContext, "at beginning of compilation.", null, null);
        this.context.setCmd(command);
        this.driverContext.getQueryDisplay().setQueryStr(queryStr);
        LOG.info("Compiling command(queryId=" + this.driverContext.getQueryId() + "): " + queryStr);
        this.driverContext.getConf().setQueryString(queryStr);
        if (SessionState.get() != null) {
            SessionState.get().getConf().setQueryString(queryStr);
            SessionState.get().setupQueryCurrentTimestamp();
        }
    }

    private void parse() throws ParseException {
        this.perfLogger.perfLogBegin(CLASS_NAME, "parse");
        this.driverContext.getHookRunner().runBeforeParseHook(this.context.getCmd());
        boolean success = false;
        try {
            this.tree = ParseUtils.parse(this.context.getCmd(), this.context);
            success = true;
            this.driverContext.getHookRunner().runAfterParseHook(this.context.getCmd(), !success);
        }
        catch (Throwable throwable) {
            this.driverContext.getHookRunner().runAfterParseHook(this.context.getCmd(), !success);
            throw throwable;
        }
        this.perfLogger.perfLogEnd(CLASS_NAME, "parse");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private BaseSemanticAnalyzer analyze() throws Exception {
        this.perfLogger.perfLogBegin(CLASS_NAME, "semanticAnalyze");
        this.driverContext.getHookRunner().runBeforeCompileHook(this.context.getCmd());
        SessionState.get().getCurrentFunctionsInUse().clear();
        Hive.get().getMSC().flushCache();
        boolean executeHooks = this.driverContext.getHookRunner().hasPreAnalyzeHooks();
        HiveSemanticAnalyzerHookContextImpl hookCtx = new HiveSemanticAnalyzerHookContextImpl();
        if (executeHooks) {
            hookCtx.setConf((Configuration)this.driverContext.getConf());
            hookCtx.setUserName(SessionState.get().getUserName());
            hookCtx.setIpAddress(SessionState.get().getUserIpAddress());
            hookCtx.setCommand(this.context.getCmd());
            hookCtx.setHiveOperation(this.queryState.getHiveOperation());
            this.tree = this.driverContext.getHookRunner().runPreAnalyzeHooks(hookCtx, this.tree);
        }
        BaseSemanticAnalyzer sem = SemanticAnalyzerFactory.get(this.queryState, this.tree);
        if (HiveOperation.REPLDUMP == this.queryState.getHiveOperation() && !this.driverContext.isRetrial()) {
            this.setLastReplIdForDump(this.queryState.getConf());
        }
        this.driverContext.setValidTxnListsGenerated(false);
        try {
            sem.startAnalysis();
            sem.analyze(this.tree, this.context);
        }
        finally {
            sem.endAnalysis(this.tree);
        }
        if (executeHooks) {
            hookCtx.update(sem);
            this.driverContext.getHookRunner().runPostAnalyzeHooks(hookCtx, sem.getAllRootTasks());
        }
        LOG.info("Semantic Analysis Completed (retrial = {})", (Object)this.driverContext.isRetrial());
        if (this.driverContext.getConf().getBoolVar(HiveConf.ConfVars.HIVE_QUERY_RESULTS_CACHE_ENABLED)) {
            this.driverContext.setCacheUsage(sem.getCacheUsage());
        }
        sem.validate();
        this.perfLogger.perfLogEnd(CLASS_NAME, "semanticAnalyze");
        return sem;
    }

    private void setLastReplIdForDump(HiveConf conf) throws HiveException, TException {
        Hive hiveDb = Hive.get();
        long lastReplId = hiveDb.getMSC().getCurrentNotificationEventId().getEventId();
        conf.setLong("hive.repl.last.repl.id", lastReplId);
        LOG.debug("Setting hive.repl.last.repl.id = " + lastReplId);
    }

    private String openTxnAndGetValidTxnList() {
        String txnString = this.driverContext.getConf().get("hive.txn.valid.txns");
        if (SessionState.get().isCompaction()) {
            return txnString;
        }
        HiveTxnManager txnMgr = this.driverContext.getTxnManager();
        try {
            this.openTransaction(txnMgr);
            if (txnMgr.isTxnOpen() && Strings.isEmpty((CharSequence)txnString)) {
                txnString = this.generateValidTxnList(txnMgr);
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to open a new transaction", e);
        }
        return txnString;
    }

    private void openTransaction(HiveTxnManager txnMgr) throws LockException, CommandProcessorException {
        if (txnMgr.isTxnOpen() || !DriverUtils.checkConcurrency(this.driverContext) || !this.startImplicitTxn()) {
            return;
        }
        TxnType txnType = AcidUtils.getTxnType((Configuration)this.driverContext.getConf(), this.tree);
        this.driverContext.setTxnType(txnType);
        HiveOperation hiveOperation = this.queryState.getHiveOperation();
        if (!(HiveOperation.REPLDUMP != hiveOperation && HiveOperation.REPLLOAD != hiveOperation || this.context.isExplainPlan())) {
            this.context.setReplPolicy(PlanUtils.stripQuotes(this.tree.getChild(0).getText()));
        }
        String userFromUGI = DriverUtils.getUserFromUGI(this.driverContext);
        txnMgr.openTxn(this.context, userFromUGI, txnType);
    }

    private boolean startImplicitTxn() {
        HiveOperation hiveOperation = this.queryState.getHiveOperation();
        switch (hiveOperation == null ? HiveOperation.QUERY : hiveOperation) {
            case COMMIT: 
            case ROLLBACK: 
            case SWITCHDATABASE: 
            case SET_AUTOCOMMIT: 
            case SHOWDATABASES: 
            case SHOWTABLES: 
            case SHOW_TABLESTATUS: 
            case SHOW_TBLPROPERTIES: 
            case SHOWCOLUMNS: 
            case SHOWFUNCTIONS: 
            case SHOWPARTITIONS: 
            case SHOWLOCKS: 
            case SHOWVIEWS: 
            case SHOW_ROLES: 
            case SHOW_ROLE_PRINCIPALS: 
            case SHOW_COMPACTIONS: 
            case SHOW_TRANSACTIONS: 
            case ABORT_TRANSACTIONS: 
            case KILL_QUERY: {
                return false;
            }
        }
        return true;
    }

    private void verifyTxnState() throws LockException {
        HiveOperation hiveOperation = this.queryState.getHiveOperation();
        if (hiveOperation != null && hiveOperation.isRequiresOpenTransaction() && !this.driverContext.getTxnManager().isTxnOpen()) {
            throw new LockException(null, ErrorMsg.OP_NOT_ALLOWED_WITHOUT_TXN, hiveOperation.getOperationName());
        }
    }

    private String generateValidTxnList(HiveTxnManager txnMgr) throws LockException {
        try {
            String txnString = txnMgr.getValidTxns().toString();
            this.driverContext.getConf().set("hive.txn.valid.txns", txnString);
            LOG.debug("Encoding valid txns info {}, txnid: {}", (Object)txnString, (Object)txnMgr.getCurrentTxnId());
            this.driverContext.setValidTxnListsGenerated(true);
            return txnString;
        }
        catch (LockException e) {
            LOG.error("Exception while acquiring valid txn list", (Throwable)((Object)e));
            throw e;
        }
    }

    private QueryPlan createPlan(BaseSemanticAnalyzer sem) {
        this.setSchema(sem);
        QueryPlan plan = new QueryPlan(this.driverContext.getQueryString(), sem, this.driverContext.getQueryDisplay().getQueryStartTime(), this.driverContext.getQueryId(), this.queryState.getHiveOperation(), this.driverContext.getSchema());
        plan.setOptimizedCBOPlan(this.context.getCalcitePlan());
        plan.setOptimizedQueryString(this.context.getOptimizedSql());
        if (sem.isPrepareQuery()) {
            plan.setPrepareQuery(true);
        }
        return plan;
    }

    protected void initializeFetchTask(QueryPlan plan) {
        if (plan.isPrepareQuery()) {
            return;
        }
        if (plan.getFetchTask() != null) {
            plan.getFetchTask().initialize(this.queryState, plan, null, this.context);
        }
    }

    private void setSchema(BaseSemanticAnalyzer sem) {
        Schema schema = new Schema();
        if (sem == null) {
            LOG.info("No semantic analyzer, using empty schema.");
        } else if (sem.getResultSchema() != null) {
            List<FieldSchema> lst = sem.getResultSchema();
            schema = new Schema(lst, null);
        } else if (sem.getFetchTask() != null) {
            FetchTask ft = sem.getFetchTask();
            TableDesc td = ft.getTblDesc();
            if (td == null && ft.getWork() != null && ((FetchWork)ft.getWork()).getPartDesc() != null && ((FetchWork)ft.getWork()).getPartDesc().size() > 0) {
                td = ((FetchWork)ft.getWork()).getPartDesc().get(0).getTableDesc();
            }
            if (td == null) {
                LOG.info("No returning schema, using empty schema");
            } else {
                String tableName = "result";
                List lst = null;
                try {
                    lst = HiveMetaStoreUtils.getFieldsFromDeserializer((String)tableName, (Deserializer)td.getDeserializer((Configuration)this.driverContext.getConf()), (Configuration)this.driverContext.getConf());
                }
                catch (Exception e) {
                    LOG.warn("Error getting schema", (Throwable)e);
                }
                if (lst != null) {
                    schema = new Schema(lst, null);
                }
            }
        }
        LOG.info("Created Hive schema: " + schema);
        this.driverContext.setSchema(schema);
    }

    private void authorize(BaseSemanticAnalyzer sem) throws HiveException, CommandProcessorException {
        if (!sem.skipAuthorization()) {
            try {
                this.perfLogger.perfLogBegin(CLASS_NAME, "doAuthorization");
                if (this.queryState.getHiveOperation() != HiveOperation.KILL_QUERY) {
                    CommandAuthorizer.doAuthorization(this.queryState.getHiveOperation(), sem, this.context.getCmd());
                }
            }
            catch (AuthorizationException authExp) {
                CONSOLE.printError("Authorization failed:" + authExp.getMessage() + ". Use SHOW GRANT to get more details.");
                throw DriverUtils.createProcessorException(this.driverContext, 403, authExp.getMessage(), "42000", null);
            }
            finally {
                this.perfLogger.perfLogEnd(CLASS_NAME, "doAuthorization");
            }
        }
    }

    private void explainOutput(BaseSemanticAnalyzer sem, QueryPlan plan) throws IOException {
        String explainOutput;
        boolean queryHistoryExplainPlanEnabled;
        HiveConf conf = this.driverContext.getConf();
        boolean bl = queryHistoryExplainPlanEnabled = conf.getBoolVar(HiveConf.ConfVars.HIVE_QUERY_HISTORY_ENABLED) && conf.getBoolVar(HiveConf.ConfVars.HIVE_QUERY_HISTORY_EXPLAIN_PLAN_ENABLED);
        if ((conf.getBoolVar(HiveConf.ConfVars.HIVE_LOG_EXPLAIN_OUTPUT) || conf.getBoolVar(HiveConf.ConfVars.HIVE_SERVER2_WEBUI_EXPLAIN_OUTPUT) || queryHistoryExplainPlanEnabled) && (explainOutput = ExplainTask.getExplainOutput(sem, plan, this.tree, this.queryState, this.context, conf)) != null) {
            if (conf.getBoolVar(HiveConf.ConfVars.HIVE_LOG_EXPLAIN_OUTPUT)) {
                if (conf.getBoolVar(HiveConf.ConfVars.HIVE_LOG_EXPLAIN_OUTPUT_TO_CONSOLE)) {
                    CONSOLE.printInfo("EXPLAIN output for queryid " + this.driverContext.getQueryId() + " : " + explainOutput);
                } else {
                    LOG.info("EXPLAIN output for queryid " + this.driverContext.getQueryId() + " : " + explainOutput);
                }
            }
            if (conf.isWebUiQueryInfoCacheEnabled() && conf.getBoolVar(HiveConf.ConfVars.HIVE_SERVER2_WEBUI_EXPLAIN_OUTPUT)) {
                this.driverContext.getQueryDisplay().setExplainPlan(explainOutput);
            }
            if (queryHistoryExplainPlanEnabled) {
                this.driverContext.setExplainPlan(explainOutput);
            }
        }
    }

    private void handleException(Exception e) throws CommandProcessorException {
        ErrorMsg error = ErrorMsg.getErrorMsg((String)e.getMessage());
        String errorMessage = "FAILED: " + e.getClass().getSimpleName();
        if (error != ErrorMsg.GENERIC_ERROR) {
            errorMessage = errorMessage + " [Error " + error.getErrorCode() + "]:";
        }
        errorMessage = e instanceof IllegalArgumentException && e.getMessage() == null && e.getCause() != null ? errorMessage + " " + e.getCause().getMessage() : errorMessage + " " + e.getMessage();
        if (error == ErrorMsg.TXNMGR_NOT_ACID) {
            errorMessage = errorMessage + ". Failed command: " + this.driverContext.getQueryString();
        }
        if (!(e instanceof ReCompileException)) {
            CONSOLE.printError(errorMessage, "\n" + StringUtils.stringifyException((Throwable)e));
        }
        throw DriverUtils.createProcessorException(this.driverContext, error.getErrorCode(), errorMessage, error.getSQLState(), e);
    }

    private void cleanUp(Throwable compileException, boolean parsed, boolean deferClose) {
        double duration = (double)this.perfLogger.perfLogEnd(CLASS_NAME, "compile") / 1000.0;
        if (parsed) {
            try {
                this.driverContext.getHookRunner().runAfterCompilationHook(this.driverContext, this.context, compileException);
            }
            catch (Exception e) {
                LOG.warn("Failed when invoking query after-compilation hook.", (Throwable)e);
            }
        }
        ImmutableMap<String, Long> compileHMSTimings = Hive.dumpMetaCallTimingWithoutEx("compilation");
        this.driverContext.getQueryDisplay().setHmsTimings(QueryDisplay.Phase.COMPILATION, (Map<String, Long>)compileHMSTimings);
        if (this.driverState.isAborted()) {
            this.driverState.compilationInterruptedWithLocking(deferClose);
            LOG.info("Compiling command(queryId={}) has been interrupted after {} seconds", (Object)this.driverContext.getQueryId(), (Object)duration);
        } else {
            this.driverState.compilationFinishedWithLocking(compileException != null);
            LOG.info("Completed compiling command(queryId={}); Time taken: {} seconds", (Object)this.driverContext.getQueryId(), (Object)duration);
        }
    }
}

