/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.llap;

import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import javax.net.SocketFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.common.TableName;
import org.apache.hadoop.hive.common.io.CacheTag;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.llap.daemon.rpc.LlapDaemonProtocolProtos;
import org.apache.hadoop.hive.llap.impl.LlapManagementProtocolClientImpl;
import org.apache.hadoop.hive.llap.registry.LlapServiceInstance;
import org.apache.hadoop.hive.llap.registry.impl.LlapRegistryService;
import org.apache.hadoop.io.retry.RetryPolicies;
import org.apache.hadoop.io.retry.RetryPolicy;
import org.apache.hadoop.net.NetUtils;
import org.apache.hive.common.util.ShutdownHookManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ProactiveEviction {
    private static final Logger LOG = LoggerFactory.getLogger(ProactiveEviction.class);
    private static final ExecutorService EXECUTOR;

    private ProactiveEviction() {
    }

    public static void evict(Configuration conf, Request request) {
        if (!HiveConf.getBoolVar((Configuration)conf, (HiveConf.ConfVars)HiveConf.ConfVars.LLAP_IO_PROACTIVE_EVICTION_ENABLED)) {
            return;
        }
        try {
            LlapRegistryService llapRegistryService = LlapRegistryService.getClient((Configuration)conf);
            Collection instances = llapRegistryService.getInstances().getAll();
            if (instances.size() == 0) {
                return;
            }
            LOG.info("Requesting proactive LLAP cache eviction.");
            LOG.debug("Request: {}", (Object)request);
            for (LlapServiceInstance instance : instances) {
                EvictionRequestTask task = new EvictionRequestTask(conf, instance, request);
                EXECUTOR.execute(task);
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    static {
        ShutdownHookManager.addShutdownHook((Runnable)new Runnable(){

            @Override
            public void run() {
                if (EXECUTOR != null) {
                    EXECUTOR.shutdownNow();
                }
            }
        });
        EXECUTOR = Executors.newSingleThreadExecutor(new ThreadFactoryBuilder().setNameFormat("Proactive-Eviction-Requester").setDaemon(true).build());
    }

    public static class EvictionRequestTask
    implements Runnable {
        private final Request request;
        private Configuration conf;
        private LlapServiceInstance instance;
        private SocketFactory socketFactory;
        private RetryPolicy retryPolicy;

        EvictionRequestTask(Configuration conf, LlapServiceInstance llapServiceInstance, Request request) {
            this.conf = conf;
            this.instance = llapServiceInstance;
            this.socketFactory = NetUtils.getDefaultSocketFactory((Configuration)conf);
            this.retryPolicy = RetryPolicies.retryUpToMaximumTimeWithFixedSleep((long)10000L, (long)2000L, (TimeUnit)TimeUnit.MILLISECONDS);
            this.request = request;
        }

        @Override
        public void run() {
            if (this.request.isEmpty()) {
                throw new IllegalArgumentException("No entities set to trigger eviction on.");
            }
            try {
                LlapManagementProtocolClientImpl client = new LlapManagementProtocolClientImpl(this.conf, this.instance.getHost(), this.instance.getManagementPort(), this.retryPolicy, this.socketFactory);
                List<LlapDaemonProtocolProtos.EvictEntityRequestProto> protoRequests = this.request.toProtoRequests();
                long evictedBytes = 0L;
                for (LlapDaemonProtocolProtos.EvictEntityRequestProto protoRequest : protoRequests) {
                    LOG.debug("Requesting proactive eviction for entities in database {}", (Object)protoRequest.getDbName());
                    LlapDaemonProtocolProtos.EvictEntityResponseProto response = client.evictEntity(null, protoRequest);
                    evictedBytes += response.getEvictedBytes();
                    LOG.debug("Proactively evicted {} bytes", (Object)response.getEvictedBytes());
                }
                LOG.debug("Proactive eviction freed {} bytes on LLAP daemon {} in total", (Object)evictedBytes, (Object)this.instance);
            }
            catch (Exception e) {
                LOG.warn("Exception while requesting proactive eviction.", (Throwable)e);
            }
        }
    }

    public static final class Request {
        private final Map<String, Map<String, Set<LinkedHashMap<String, String>>>> entities;

        private Request(Map<String, Map<String, Set<LinkedHashMap<String, String>>>> entities) {
            this.entities = entities;
        }

        public Map<String, Map<String, Set<LinkedHashMap<String, String>>>> getEntities() {
            return this.entities;
        }

        public boolean isEmpty() {
            return this.entities.isEmpty();
        }

        public String getSingleDbName() {
            if (this.entities.size() == 1) {
                return (String)this.entities.keySet().stream().findFirst().get();
            }
            return null;
        }

        public List<LlapDaemonProtocolProtos.EvictEntityRequestProto> toProtoRequests() {
            LinkedList<LlapDaemonProtocolProtos.EvictEntityRequestProto> protoRequests = new LinkedList<LlapDaemonProtocolProtos.EvictEntityRequestProto>();
            for (Map.Entry<String, Map<String, Set<LinkedHashMap<String, String>>>> dbEntry : this.entities.entrySet()) {
                String dbName = dbEntry.getKey();
                Map<String, Set<LinkedHashMap<String, String>>> tables = dbEntry.getValue();
                LlapDaemonProtocolProtos.EvictEntityRequestProto.Builder requestBuilder = LlapDaemonProtocolProtos.EvictEntityRequestProto.newBuilder();
                LlapDaemonProtocolProtos.TableProto.Builder tableBuilder = null;
                requestBuilder.setDbName(dbName.toLowerCase());
                for (Map.Entry<String, Set<LinkedHashMap<String, String>>> tableEntry : tables.entrySet()) {
                    String tableName = tableEntry.getKey();
                    tableBuilder = LlapDaemonProtocolProtos.TableProto.newBuilder();
                    tableBuilder.setTableName(tableName.toLowerCase());
                    Set<LinkedHashMap<String, String>> partitions = tableEntry.getValue();
                    LinkedHashSet partitionKeys = null;
                    for (Map map : partitions) {
                        if (partitionKeys == null) {
                            partitionKeys = new LinkedHashSet(map.keySet());
                            tableBuilder.addAllPartKey(partitionKeys);
                        }
                        for (String partKey : tableBuilder.getPartKeyList()) {
                            tableBuilder.addPartVal((String)map.get(partKey));
                        }
                    }
                    requestBuilder.addTable(tableBuilder.build());
                }
                protoRequests.add(requestBuilder.build());
            }
            return protoRequests;
        }

        public boolean isTagMatch(CacheTag cacheTag) {
            String db = this.getSingleDbName();
            if (db == null) {
                throw new UnsupportedOperationException("Predicate only implemented for 1 DB case.");
            }
            TableName tagTableName = TableName.fromString((String)cacheTag.getTableName(), null, null);
            if (!db.equals(tagTableName.getDb())) {
                return false;
            }
            Map<String, Set<LinkedHashMap<String, String>>> tables = this.entities.get(db);
            if (tables.isEmpty()) {
                return true;
            }
            LinkedHashMap tagPartDescMap = null;
            if (cacheTag instanceof CacheTag.PartitionCacheTag) {
                tagPartDescMap = ((CacheTag.PartitionCacheTag)cacheTag).getPartitionDescMap();
            }
            for (String tableAndDbName : tables.keySet()) {
                if (!tableAndDbName.equals(tagTableName.getNotEmptyDbTable())) continue;
                Set<LinkedHashMap<String, String>> partDescs = tables.get(tableAndDbName);
                if (partDescs == null) {
                    return true;
                }
                if (!(cacheTag instanceof CacheTag.PartitionCacheTag)) {
                    throw new IllegalArgumentException("CacheTag has no partition information, while trying to evict due to (and based on) a drop partition DDL statement..");
                }
                if (!partDescs.contains(tagPartDescMap)) continue;
                return true;
            }
            return false;
        }

        public String toString() {
            return "Request { entities = " + this.entities + " }";
        }

        public static final class Builder {
            private final Map<String, Map<String, Set<LinkedHashMap<String, String>>>> entities = new HashMap<String, Map<String, Set<LinkedHashMap<String, String>>>>();

            private Builder() {
            }

            public static Builder create() {
                return new Builder();
            }

            public Builder addPartitionOfATable(String db, String tableName, LinkedHashMap<String, String> partSpec) {
                this.ensureDb(db);
                this.ensureTable(db, tableName);
                this.entities.get(db).get(tableName).add(partSpec);
                return this;
            }

            public Builder addDb(String db) {
                this.ensureDb(db);
                return this;
            }

            public Builder addTable(String db, String table) {
                this.ensureDb(db);
                this.ensureTable(db, table);
                return this;
            }

            public Request build() {
                return new Request(this.entities);
            }

            private void ensureDb(String dbName) {
                Map<String, Set<LinkedHashMap<String, String>>> tables = this.entities.get(dbName);
                if (tables == null) {
                    tables = new HashMap<String, Set<LinkedHashMap<String, String>>>();
                    this.entities.put(dbName, tables);
                }
            }

            private void ensureTable(String dbName, String tableName) {
                this.ensureDb(dbName);
                Map<String, Set<LinkedHashMap<String, String>>> tables = this.entities.get(dbName);
                Set<LinkedHashMap<String, String>> partitions = tables.get(tableName);
                if (partitions == null) {
                    partitions = new HashSet<LinkedHashMap<String, String>>();
                    tables.put(tableName, partitions);
                }
            }

            public Builder fromProtoRequest(LlapDaemonProtocolProtos.EvictEntityRequestProto protoRequest) {
                this.entities.clear();
                String dbName = protoRequest.getDbName().toLowerCase();
                HashMap entitiesInDb = new HashMap();
                List tables = protoRequest.getTableList();
                if (tables != null && !tables.isEmpty()) {
                    for (LlapDaemonProtocolProtos.TableProto table : tables) {
                        String dbAndTableName = (dbName + '.' + table.getTableName()).toLowerCase();
                        if (table.getPartValCount() == 0) {
                            entitiesInDb.put(dbAndTableName, null);
                            continue;
                        }
                        HashSet partitions = new HashSet();
                        LinkedHashMap<String, String> partDesc = new LinkedHashMap<String, String>();
                        for (int valIx = 0; valIx < table.getPartValCount(); ++valIx) {
                            int keyIx = valIx % table.getPartKeyCount();
                            partDesc.put(table.getPartKey(keyIx).toLowerCase(), table.getPartVal(valIx));
                            if (keyIx != table.getPartKeyCount() - 1) continue;
                            partitions.add(partDesc);
                            partDesc = new LinkedHashMap();
                        }
                        entitiesInDb.put(dbAndTableName, partitions);
                    }
                }
                this.entities.put(dbName, entitiesInDb);
                return this;
            }
        }
    }
}

