/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.serde2.typeinfo;

import java.io.Serializable;
import java.util.Objects;
import org.apache.hadoop.hive.common.classification.InterfaceAudience;
import org.apache.hadoop.hive.common.classification.InterfaceStability;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.PrimitiveObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.PrimitiveObjectInspectorUtils;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfo;

@InterfaceAudience.Public
@InterfaceStability.Stable
public class PrimitiveTypeInfo
extends TypeInfo
implements Serializable {
    private static final long serialVersionUID = 1L;
    protected String typeName;
    protected transient PrimitiveObjectInspectorUtils.PrimitiveTypeEntry typeEntry;

    public PrimitiveTypeInfo() {
    }

    PrimitiveTypeInfo(String typeName) {
        Objects.requireNonNull(typeName);
        this.typeName = typeName;
        this.typeEntry = PrimitiveObjectInspectorUtils.getTypeEntryFromTypeName(typeName);
    }

    @Override
    public ObjectInspector.Category getCategory() {
        return ObjectInspector.Category.PRIMITIVE;
    }

    public PrimitiveObjectInspector.PrimitiveCategory getPrimitiveCategory() {
        return this.getPrimitiveTypeEntry().primitiveCategory;
    }

    public Class<?> getPrimitiveWritableClass() {
        return this.getPrimitiveTypeEntry().primitiveWritableClass;
    }

    public Class<?> getPrimitiveJavaClass() {
        return this.getPrimitiveTypeEntry().primitiveJavaClass;
    }

    public void setTypeName(String typeName) {
        this.typeName = typeName;
        this.typeEntry = null;
    }

    @Override
    public String getTypeName() {
        return this.typeName;
    }

    public PrimitiveObjectInspectorUtils.PrimitiveTypeEntry getPrimitiveTypeEntry() {
        if (this.typeEntry == null) {
            this.typeEntry = PrimitiveObjectInspectorUtils.getTypeEntryFromTypeName(this.typeName);
        }
        return this.typeEntry;
    }

    @Override
    public String toString() {
        return this.typeName;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.typeName == null ? 0 : this.typeName.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        PrimitiveTypeInfo other = (PrimitiveTypeInfo)obj;
        return !(this.typeName == null ? other.typeName != null : !this.typeName.equals(other.typeName));
    }
}

